/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.heclib.util.HecTime;
import hec.lang.annotation.Scriptable;
import hec.model.RunTimeWindow;

public class RunTimeStep {
    public RunTimeWindow rtw;
    public int step;
    public int flag;
    public int nstep;

    @Scriptable
    public RunTimeStep() {
    }

    @Scriptable
    public RunTimeStep(RunTimeStep rts) {
        this.rtw = rts.rtw;
        this.step = rts.step;
        this.nstep = rts.nstep;
    }

    @Scriptable
    public RunTimeStep(RunTimeWindow runTimeWindow) {
        this.rtw = runTimeWindow;
        this.step = 0;
        this.nstep = 1;
    }

    public boolean isPerAvgTimeStep() {
        if (this.rtw == null) {
            return false;
        }
        return this.rtw.isPerAvgTimeStep();
    }

    @Scriptable
    public void init(RunTimeStep rts) {
        this.rtw = rts.rtw;
        this.step = rts.step;
        this.nstep = rts.nstep;
    }

    @Scriptable
    public int getTotalNumSteps() {
        return this.rtw.getNumSteps();
    }

    @Scriptable
    public void setStep(int i) {
        this.step = i;
        if (this.step < 0) {
            this.step = 0;
        }
    }

    @Scriptable
    public int getStep() {
        return this.step;
    }

    @Scriptable
    public int getPrevStep() {
        return this.step - 1 < 0 ? 0 : this.step - 1;
    }

    @Scriptable
    public void increment() {
        ++this.step;
    }

    @Scriptable
    public int getTimeStepSeconds() {
        if (this.rtw == null) {
            return 1;
        }
        return this.rtw.getTimeStepSeconds();
    }

    @Scriptable
    public int getTimeStepMinutes() {
        if (this.rtw == null) {
            return 1;
        }
        return this.rtw.getTimeStepMinutes();
    }

    @Scriptable
    public String dateTimeString() {
        return this.dateTimeString(this.step);
    }

    @Scriptable
    public String dateTimeString(int theStep) {
        if (this.rtw == null) {
            return Integer.toString(theStep);
        }
        return this.rtw.getTimeStringAtStep(theStep);
    }

    @Scriptable
    public int month() {
        if (this.rtw == null) {
            return 1;
        }
        HecTime t = this.rtw.getTimeAtStep(this.step);
        int iday = t.day();
        int imonth = t.month();
        int msm = t.minutesSinceMidnight();
        if (iday == 1 && msm == 0) {
            imonth = --imonth < 1 ? 12 : imonth;
        }
        return imonth;
    }

    @Scriptable
    public int hecJulian() {
        if (this.rtw == null) {
            return 1;
        }
        HecTime t = this.rtw.getTimeAtStep(this.step);
        return t.julian();
    }

    @Scriptable
    public int hecMinutes() {
        if (this.rtw == null) {
            return 1;
        }
        HecTime t = this.rtw.getTimeAtStep(this.step);
        return t.minutesSinceMidnight();
    }

    @Scriptable
    public HecTime getHecTime() {
        if (this.rtw == null) {
            return null;
        }
        return this.rtw.getTimeAtStep(this.step);
    }

    public int getDayOfWeek() {
        HecTime t = this.rtw.getTimeAtStep(this.step);
        return RunTimeStep.getDayOfWeek(t);
    }

    public static int getDayOfWeek(HecTime htime) {
        if (htime == null) {
            return Integer.MIN_VALUE;
        }
        int day = htime.dayOfWeek() - 1;
        if (day < 0 || day > 6) {
            return Integer.MIN_VALUE;
        }
        if (htime.secondsSinceMidnight() == 0 && --day < 0) {
            day += 7;
        }
        return day;
    }

    @Scriptable
    public int valueMinutes() {
        HecTime t = this.rtw.getTimeAtStep(this.step);
        int min = t.julian() * 1440 + t.minutesSinceMidnight();
        return min;
    }

    @Scriptable
    public RunTimeWindow getRunTimeWindow() {
        return this.rtw;
    }
}

