/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.lang.annotation.Scriptable;
import hec.model.RunTimeStep;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Objects;
import java.util.StringTokenizer;

@Scriptable
public class RunTimeWindow
implements Serializable,
AsciiSerializable,
Cloneable {
    static final long serialVersionUID = 2111156059267035379L;
    public static final String[] _incrementString = new String[]{"SEC", "MIN", "HOUR", "DAY"};
    public static final int INCR_SEC = 0;
    public static final int INCR_MIN = 1;
    public static final int INCR_HOUR = 2;
    public static final int INCR_DAY = 3;
    HecTime _lookbackTime = null;
    HecTime _startTime = null;
    HecTime _endTime = null;
    HecTime _baseTime = new HecTime();
    HecTime _currentTime = new HecTime();
    int _timeStep = Integer.MIN_VALUE;
    int _timeIncrement = Integer.MIN_VALUE;
    boolean _periodAvgTimeStep = true;
    int _numSteps = Integer.MIN_VALUE;
    int _numLookbackSteps = Integer.MIN_VALUE;
    int _numForecastSteps = Integer.MIN_VALUE;
    int _numRoutingSteps = Integer.MIN_VALUE;
    int _timeBlockIndex = 0;

    @Scriptable
    public RunTimeWindow() {
    }

    @Scriptable
    public RunTimeWindow(HecTime start, HecTime end, HecTime lookback) {
        this._startTime = start;
        this._endTime = end;
        this._lookbackTime = lookback;
    }

    @Scriptable
    public RunTimeWindow(RunTimeWindow rtw) {
        if (rtw != null) {
            this._startTime = new HecTime(rtw._startTime);
            this._endTime = new HecTime(rtw._endTime);
            this._lookbackTime = new HecTime(rtw._lookbackTime);
            this._timeStep = rtw._timeStep;
            this._timeIncrement = rtw._timeIncrement;
            this._numRoutingSteps = rtw._numRoutingSteps;
        }
    }

    public void setShowTimeAsBeginningOfDay(boolean b) {
        if (this._lookbackTime != null) {
            this._lookbackTime.showTimeAsBeginningOfDay(b);
        }
        if (this._startTime != null) {
            this._startTime.showTimeAsBeginningOfDay(b);
        }
        if (this._endTime != null) {
            this._endTime.showTimeAsBeginningOfDay(b);
        }
        if (this._baseTime != null) {
            this._baseTime.showTimeAsBeginningOfDay(b);
        }
        if (this._currentTime != null) {
            this._currentTime.showTimeAsBeginningOfDay(b);
        }
    }

    public boolean isPerAvgTimeStep() {
        return this._periodAvgTimeStep;
    }

    public void setPeriodAvgTimeStep(boolean b) {
        this._periodAvgTimeStep = b;
    }

    public int getTimeBlockIndex() {
        return this._timeBlockIndex;
    }

    public void setTimeBlockIndex(int index) {
        this._timeBlockIndex = index;
    }

    @Scriptable
    public int getNumRoutingSteps() {
        return this._numRoutingSteps;
    }

    @Scriptable
    public void setNumRoutingSteps(int numSteps) {
        this._numRoutingSteps = numSteps;
    }

    @Scriptable
    public boolean isValid() {
        if (this._startTime == null) {
            return false;
        }
        if (this._endTime == null) {
            return false;
        }
        if (this._timeStep == Integer.MIN_VALUE) {
            return false;
        }
        return this._timeIncrement != Integer.MIN_VALUE;
    }

    @Scriptable
    public int getNumSteps() {
        if (!this.isValid()) {
            return Integer.MIN_VALUE;
        }
        if (this._numSteps == Integer.MIN_VALUE) {
            this.computeSteps();
        }
        return this._numSteps;
    }

    public void setNumLookbackSteps(int numSteps) {
        this._numLookbackSteps = numSteps;
    }

    @Scriptable
    public int getNumLookbackSteps() {
        if (!this.isValid()) {
            return Integer.MIN_VALUE;
        }
        if (this._numLookbackSteps == Integer.MIN_VALUE) {
            this.computeSteps();
        }
        return this._numLookbackSteps;
    }

    public int getForecastSteps() {
        if (!this.isValid()) {
            return Integer.MIN_VALUE;
        }
        if (this._numForecastSteps == Integer.MIN_VALUE) {
            this.computeSteps();
        }
        return this._numForecastSteps;
    }

    public boolean computeSteps() {
        if (!this.isValid()) {
            return false;
        }
        int timeStepMin = this._timeStep;
        if (this._timeIncrement == 0) {
            timeStepMin = this._timeStep / 60;
        } else if (this._timeIncrement == 2) {
            timeStepMin = this._timeStep * 60;
        } else if (this._timeIncrement == 3) {
            timeStepMin = this._timeStep * 60 * 24;
        }
        if (this._lookbackTime == null || !this._lookbackTime.isDefined()) {
            this._numLookbackSteps = 0;
            this._numSteps = this._numForecastSteps = HecTime.nopers(timeStepMin, this._startTime.julian(), this._startTime.minutesSinceMidnight(), this._endTime.julian(), this._endTime.minutesSinceMidnight());
            this._baseTime.set(this._startTime);
            this._baseTime.setTimeIncrement(this._timeIncrement);
            this._currentTime.setTimeIncrement(this._timeIncrement);
        } else {
            this._numLookbackSteps = HecTime.nopers(timeStepMin, this._lookbackTime.julian(), this._lookbackTime.minutesSinceMidnight(), this._startTime.julian(), this._startTime.minutesSinceMidnight());
            this._numForecastSteps = HecTime.nopers(timeStepMin, this._startTime.julian(), this._startTime.minutesSinceMidnight(), this._endTime.julian(), this._endTime.minutesSinceMidnight());
            this._numSteps = this._numLookbackSteps + this._numForecastSteps;
            this._baseTime.set(this._startTime);
            this._baseTime.setTimeIncrement(this._timeIncrement);
            this._baseTime.subtract(this._numLookbackSteps * this._timeStep);
            this._currentTime.setTimeIncrement(this._timeIncrement);
        }
        return true;
    }

    @Scriptable
    public void setTimeStep(int dt, int inc) {
        this._timeStep = dt;
        this._timeIncrement = inc;
        this._numSteps = Integer.MIN_VALUE;
        this._numLookbackSteps = Integer.MIN_VALUE;
        this._numForecastSteps = Integer.MIN_VALUE;
    }

    public void setTimeStep(String str) {
        if (str == null || str.length() < 1) {
            return;
        }
        int[] tsInfo = RunTimeWindow.getTimeStep(str);
        this._timeIncrement = tsInfo[1];
        this._timeStep = tsInfo[0];
        this._numSteps = Integer.MIN_VALUE;
        this._numLookbackSteps = Integer.MIN_VALUE;
        this._numForecastSteps = Integer.MIN_VALUE;
    }

    public static int[] getTimeStep(String str) {
        if (str == null) {
            return new int[]{-1, -1};
        }
        str = str.toUpperCase();
        int[] tsInfo = new int[]{-1, -1};
        for (int i = 0; i < _incrementString.length; ++i) {
            int idx = str.indexOf(_incrementString[i]);
            if (idx < 0) continue;
            tsInfo[1] = i;
            str = str.substring(0, idx);
            break;
        }
        if (tsInfo[1] != -1) {
            tsInfo[0] = Integer.parseInt(str.trim());
        }
        return tsInfo;
    }

    public static int getTimeStepSeconds(int timeStep, int timeStepIncrement) {
        int timeStepSec = timeStep;
        if (timeStepIncrement == 1) {
            timeStepSec = timeStep * 60;
        } else if (timeStepIncrement == 2) {
            timeStepSec = timeStep * 3600;
        } else if (timeStepIncrement == 3) {
            timeStepSec = timeStep * 3600 * 24;
        }
        return timeStepSec;
    }

    @Scriptable
    public int getTimeStep() {
        return this._timeStep;
    }

    @Scriptable
    public int getTimeStepSeconds() {
        return RunTimeWindow.getTimeStepSeconds(this._timeStep, this._timeIncrement);
    }

    @Scriptable
    public int getTimeStepMinutes() {
        int timeStepMin = this._timeStep;
        if (this._timeIncrement == 0) {
            timeStepMin = this._timeStep / 60;
        } else if (this._timeIncrement == 2) {
            timeStepMin = this._timeStep * 60;
        } else if (this._timeIncrement == 3) {
            timeStepMin = this._timeStep * 60 * 24;
        }
        return timeStepMin;
    }

    @Scriptable
    public int getTimeIncrement() {
        return this._timeIncrement;
    }

    @Scriptable
    public String getTimeIncrementString() {
        if (this._timeIncrement >= 0 && this._timeIncrement <= 3) {
            return _incrementString[this._timeIncrement];
        }
        return "";
    }

    @Scriptable
    public String getTimeStepString(int format) {
        String sep = format == 0 ? "" : (format == 1 ? " " : "");
        Object rtn = this._timeIncrement >= 0 && this._timeIncrement <= 3 ? Integer.toString(this._timeStep) + sep + _incrementString[this._timeIncrement] : Integer.toString(this._timeStep);
        return rtn;
    }

    @Scriptable
    public String getTimeWindowString() {
        if (!this.isValid()) {
            return "";
        }
        return this.getLookbackDateString() + " " + this.getLookbackHrMinString() + " " + this.getEndDateString() + " " + this.getEndHrMinString();
    }

    @Scriptable
    public void setStartTime(HecTime start) {
        this._startTime = start;
        this._numSteps = Integer.MIN_VALUE;
        this._numLookbackSteps = Integer.MIN_VALUE;
        this._numForecastSteps = Integer.MIN_VALUE;
    }

    @Scriptable
    public void setStartTime(String timestr) {
        this._startTime = new HecTime();
        this._startTime.set(timestr);
        this._numSteps = Integer.MIN_VALUE;
        this._numLookbackSteps = Integer.MIN_VALUE;
        this._numForecastSteps = Integer.MIN_VALUE;
    }

    @Scriptable
    public HecTime getStartTime() {
        return this._startTime;
    }

    @Scriptable
    public String getStartDateString() {
        if (this._startTime == null) {
            return "";
        }
        return HecTime.juldat(this._startTime.julian(), 4);
    }

    @Scriptable
    public String getStartHrMinString() {
        if (this._startTime == null) {
            return "";
        }
        return this._startTime.hourMinutes();
    }

    @Scriptable
    public String getStartTimeString() {
        if (this._startTime == null) {
            return "";
        }
        return this.getStartDateString() + " " + this.getStartHrMinString();
    }

    @Scriptable
    public void setEndTime(HecTime end) {
        this._endTime = end;
        this._numSteps = Integer.MIN_VALUE;
        this._numLookbackSteps = Integer.MIN_VALUE;
        this._numForecastSteps = Integer.MIN_VALUE;
    }

    @Scriptable
    public void setEndTime(String timestr) {
        this._endTime = new HecTime();
        this._endTime.set(timestr);
        this._numSteps = Integer.MIN_VALUE;
        this._numLookbackSteps = Integer.MIN_VALUE;
        this._numForecastSteps = Integer.MIN_VALUE;
    }

    @Scriptable
    public HecTime getEndTime() {
        return this._endTime;
    }

    @Scriptable
    public String getEndDateString() {
        if (this._endTime == null) {
            return "";
        }
        return HecTime.juldat(this._endTime.julian(), 4);
    }

    @Scriptable
    public String getEndHrMinString() {
        if (this._endTime == null) {
            return "";
        }
        return this._endTime.hourMinutes();
    }

    @Scriptable
    public String getEndTimeString() {
        if (this._endTime == null) {
            return "";
        }
        return this.getEndDateString() + " " + this.getEndHrMinString();
    }

    @Scriptable
    public void setLookbackTime(HecTime lookback) {
        this._lookbackTime = lookback;
        this._numSteps = Integer.MIN_VALUE;
        this._numLookbackSteps = Integer.MIN_VALUE;
        this._numForecastSteps = Integer.MIN_VALUE;
    }

    @Scriptable
    public void setLookbackTime(String timestr) {
        this._lookbackTime = new HecTime();
        this._lookbackTime.set(timestr);
        this._numSteps = Integer.MIN_VALUE;
        this._numLookbackSteps = Integer.MIN_VALUE;
        this._numForecastSteps = Integer.MIN_VALUE;
    }

    @Scriptable
    public HecTime getLookbackTime() {
        return this._lookbackTime;
    }

    @Scriptable
    public String getLookbackDateString() {
        if (this._lookbackTime == null) {
            return "";
        }
        return HecTime.juldat(this._lookbackTime.julian(), 4);
    }

    @Scriptable
    public String getLookbackHrMinString() {
        if (this._lookbackTime == null) {
            return "";
        }
        return this._lookbackTime.hourMinutes();
    }

    @Scriptable
    public String getLookbackTimeString() {
        if (this._lookbackTime == null) {
            return "";
        }
        return this.getLookbackDateString() + " " + this.getLookbackHrMinString();
    }

    public RunTimeStep getRunTimeStepAtTime(HecTime time) {
        if (time == null || !time.isDefined()) {
            return null;
        }
        int step = this.getStepAtTime(time);
        RunTimeStep rts = new RunTimeStep(this);
        rts.setStep(step);
        return rts;
    }

    @Scriptable
    public HecTime getTimeAtStep(int i) {
        if (!this.isValid()) {
            return null;
        }
        if (this._numSteps == Integer.MIN_VALUE) {
            this.computeSteps();
        }
        this._currentTime.set(this._baseTime);
        this._currentTime.add(i * this._timeStep);
        this._currentTime.showTimeAsBeginningOfDay(false);
        return this._currentTime;
    }

    @Scriptable
    public int getStepAtTime(HecTime time) {
        int step = -1;
        if (!this.isValid() || time == null || !time.isDefined()) {
            return step;
        }
        if (this._numSteps == Integer.MIN_VALUE) {
            this.computeSteps();
        }
        int timeStepMin = this._timeStep;
        if (this._timeIncrement == 0) {
            timeStepMin = this._timeStep / 60;
        } else if (this._timeIncrement == 2) {
            timeStepMin = this._timeStep * 60;
        } else if (this._timeIncrement == 3) {
            timeStepMin = this._timeStep * 60 * 24;
        }
        step = this._lookbackTime == null ? HecTime.nopers(timeStepMin, this._startTime.julian(), this._startTime.minutesSinceMidnight(), time.julian(), time.minutesSinceMidnight()) : HecTime.nopers(timeStepMin, this._lookbackTime.julian(), this._lookbackTime.minutesSinceMidnight(), time.julian(), time.minutesSinceMidnight());
        return step;
    }

    @Scriptable
    public String getTimeStringAtStep(int timeStep) {
        HecTime t = this.getTimeAtStep(timeStep);
        if (t == null) {
            return Integer.toString(timeStep);
        }
        return HecTime.juldat(t.julian(), 4) + " " + t.hourMinutes();
    }

    @Scriptable
    public String toString() {
        StringBuffer buf = new StringBuffer();
        HecTime time = this.getLookbackTime();
        if (time != null && time.isDefined()) {
            buf.append(time.toString());
        }
        if ((time = this.getStartTime()) != null && time.isDefined()) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append(time.toString());
        }
        if ((time = this.getEndTime()) != null && time.isDefined()) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append(time.toString());
        }
        return buf.toString();
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        RunTimeWindow rtw = new RunTimeWindow();
        HecTime time = new HecTime("10Apr2002", "0900");
        time.setTimeIncrement(0);
        rtw.setStartTime(time);
        time = new HecTime("20Apr2002", "2400");
        time.setTimeIncrement(0);
        rtw.setEndTime(time);
        rtw.setTimeStep(450, 0);
        time = new HecTime(rtw.getStartTime());
        System.out.println("have " + rtw.getNumSteps() + " steps");
        while (time.lessThan(rtw.getEndTime())) {
            System.out.println("Step at " + time + " is " + rtw.getStepAtTime(time));
            time.add(450);
        }
        rtw = new RunTimeWindow();
        HecTime start = new HecTime("01mar1000", "0000");
        rtw.setStartTime(start);
        HecTime end = new HecTime("28feb1010", "2400");
        rtw.setEndTime(end);
        rtw.setTimeStep(1, 2);
        int years = rtw.getNumberOfYears();
        System.out.println("main:years = " + years);
    }

    public static String getTimeStepString(int timeStep, int timeIncrement) {
        switch (timeIncrement) {
            case 3: {
                return String.valueOf(timeStep) + "Day";
            }
            case 1: {
                return String.valueOf(timeStep) + "Minute";
            }
        }
        return String.valueOf(timeStep) + "Hour";
    }

    public void set(String times) {
        if (times == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(times, ";");
        switch (tokenizer.countTokens()) {
            case 3: {
                String lookback = tokenizer.nextToken();
                String start = tokenizer.nextToken();
                String end = tokenizer.nextToken();
                this.setLookbackTime(lookback);
                this.setStartTime(start);
                this.setEndTime(end);
                break;
            }
            case 2: {
                String start = tokenizer.nextToken();
                String end = tokenizer.nextToken();
                this.setStartTime(start);
                this.setEndTime(end);
                break;
            }
            case 1: {
                String start = tokenizer.nextToken();
                this.setStartTime(start);
            }
        }
    }

    public int getNumberOfYears() {
        HecTime beginTime = this._lookbackTime;
        if (beginTime == null || !beginTime.isDefined()) {
            beginTime = this._startTime;
        }
        if (this._endTime == null || !this._endTime.isDefined() || beginTime == null || !beginTime.isDefined()) {
            return -1;
        }
        Calendar beginCal = Calendar.getInstance();
        beginCal.clear();
        beginCal.set(beginTime.year(), beginTime.month() - 1, beginTime.day(), beginTime.hour(), beginTime.minute());
        Calendar endCal = Calendar.getInstance();
        endCal.clear();
        endCal.set(this._endTime.year(), this._endTime.month() - 1, this._endTime.day(), this._endTime.hour(), this._endTime.minute());
        int years = endCal.get(1) - beginCal.get(1);
        beginCal.set(1, endCal.get(1));
        if (beginCal.getTimeInMillis() > endCal.getTimeInMillis()) {
            --years;
        }
        return years;
    }

    public double getNumberOfYearsWithFraction() {
        HecTime beginTime = this._lookbackTime;
        if (beginTime == null || !beginTime.isDefined()) {
            beginTime = this._startTime;
        }
        if (this._endTime == null || !this._endTime.isDefined() || beginTime == null || !beginTime.isDefined()) {
            return -1.0;
        }
        Calendar beginCal = Calendar.getInstance();
        beginCal.clear();
        beginCal.set(beginTime.year(), beginTime.month() - 1, beginTime.day(), beginTime.hour(), beginTime.minute());
        Calendar endCal = Calendar.getInstance();
        endCal.clear();
        endCal.set(this._endTime.year(), this._endTime.month() - 1, this._endTime.day(), this._endTime.hour(), this._endTime.minute());
        double years = endCal.get(1) - beginCal.get(1);
        beginCal.set(1, endCal.get(1));
        double daysInYear = 365.0;
        if (HecTime.isLeap(endCal.get(1))) {
            daysInYear = 366.0;
        }
        double fraction = (double)(endCal.getTimeInMillis() - beginCal.getTimeInMillis()) / 8.64E7 / daysInYear;
        return years + fraction;
    }

    public HecTime getExtractStartTime() {
        return null;
    }

    public RunTimeWindow clone() {
        try {
            RunTimeWindow newRTW = (RunTimeWindow)super.clone();
            newRTW._lookbackTime = new HecTime(this._lookbackTime);
            newRTW._startTime = new HecTime(this._startTime);
            newRTW._endTime = new HecTime(this._endTime);
            newRTW._baseTime = new HecTime(this._baseTime);
            newRTW._currentTime = new HecTime(this._currentTime);
            newRTW._timeStep = this._timeStep;
            newRTW._timeIncrement = this._timeIncrement;
            newRTW._periodAvgTimeStep = this._periodAvgTimeStep;
            newRTW._numSteps = this._numSteps;
            newRTW._numLookbackSteps = this._numLookbackSteps;
            newRTW._numForecastSteps = this._numForecastSteps;
            newRTW._numRoutingSteps = this._numRoutingSteps;
            newRTW._timeBlockIndex = this._timeBlockIndex;
            return newRTW;
        }
        catch (CloneNotSupportedException ce) {
            System.out.println("RunTiemWindow.clone: Error in clone " + ce);
            return null;
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this._lookbackTime);
        hash = 43 * hash + Objects.hashCode(this._startTime);
        hash = 43 * hash + Objects.hashCode(this._endTime);
        hash = 43 * hash + this._timeStep;
        hash = 43 * hash + this._timeIncrement;
        hash = 43 * hash + (this._periodAvgTimeStep ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunTimeWindow other = (RunTimeWindow)obj;
        if (this._timeStep != other._timeStep) {
            return false;
        }
        if (this._timeIncrement != other._timeIncrement) {
            return false;
        }
        if (this._periodAvgTimeStep != other._periodAvgTimeStep) {
            return false;
        }
        if (!this.timesEqual(this._lookbackTime, other._lookbackTime)) {
            return false;
        }
        if (!this.timesEqual(this._startTime, other._startTime)) {
            return false;
        }
        return this.timesEqual(this._endTime, other._endTime);
    }

    private boolean timesEqual(HecTime t1, HecTime t2) {
        return t1 == t2 || t1 != null && t1.equalTo(t2);
    }
}

