/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public abstract class SchedulableJob
extends NamedType
implements Serializable,
AsciiSerializable {
    public static final String MINUTE_INTERVAL = "Minute";
    public static final String HOUR_INTERVAL = "Hour";
    public static final String DAY_INTERVAL = "Day";
    public static final String SINGLE = "SINGLE";
    private static final int MINUTELY_INTERVAL = 60000;
    private static final int HOURLY_INTERVAL = 3600000;
    private static final int DAILY_INTERVAL = 86400000;
    private boolean _recurring = false;
    private String _startDateString;
    private transient Date _startDate;
    private int _recurringAmt = 0;
    private int _recurringInterval = 0;
    private String _user;
    private String _password;
    private int _timezoneOffset;

    public SchedulableJob() {
    }

    public SchedulableJob(String jobName) {
        super(jobName);
    }

    public void setRecurring(boolean b) {
        this._recurring = b;
    }

    public void setStartDate(String startDate) {
        this._startDateString = startDate;
        this._startDate = null;
    }

    public boolean isRecurring() {
        return this._recurring;
    }

    public String getStartDateString() {
        return this._startDateString;
    }

    public Date getStartDate() {
        if (this._startDate != null) {
            return this._startDate;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(new SimpleTimeZone(this.getTimezoneOffset() * 3600000, "foo"));
            if (this._startDateString.length() == 18) {
                sdf.applyPattern("ddMMMyyyy,HHmm zzz");
                this._startDate = sdf.parse(this._startDateString);
            } else {
                sdf.applyPattern("ddMMMyyyy,HHmm");
                this._startDate = sdf.parse(this._startDateString);
            }
        }
        catch (ParseException e) {
            System.out.println(this.getName() + " error parsing date '" + this._startDateString + "' error " + e);
        }
        return this._startDate;
    }

    public int getRecurringAmount() {
        return this._recurringAmt;
    }

    public int getRecurringInterval() {
        return this._recurringInterval;
    }

    public String getIntervalString() {
        if (this._recurringAmt <= 0) {
            return SINGLE;
        }
        String interval = "";
        switch (this._recurringInterval) {
            case 60000: {
                interval = "Minute(s)";
                break;
            }
            case 3600000: {
                interval = "Hour(s)";
                break;
            }
            case 86400000: {
                interval = "Day(s)";
            }
        }
        return this._recurringAmt + " " + interval;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public String getUser() {
        return this._user;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }

    public void setRecurringAmount(int amount) throws IllegalArgumentException {
        if (amount < 1) {
            throw new IllegalArgumentException("Recurring Amount must be more than 0");
        }
        this._recurringAmt = amount;
    }

    public void setRecurringInterval(String interval) throws IllegalArgumentException {
        if (interval.substring(0, 4).equalsIgnoreCase(HOUR_INTERVAL)) {
            this._recurringInterval = 3600000;
        } else if (interval.substring(0, 3).equalsIgnoreCase(DAY_INTERVAL)) {
            this._recurringInterval = 86400000;
        } else if (interval.startsWith(MINUTE_INTERVAL)) {
            this._recurringInterval = 60000;
        } else {
            throw new IllegalArgumentException("Recurring Interval must be  Minute, Hour or Day");
        }
    }

    public long getPeriod() {
        if (this._recurring) {
            return this._recurringInterval * this._recurringAmt;
        }
        return 0L;
    }

    public void setTimezoneOffset(int offset) {
        this._timezoneOffset = offset;
    }

    public int getTimezoneOffset() {
        return this._timezoneOffset;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public void printInfo() {
        System.out.println("*************JobInfo for " + this.getName() + " user=" + this._user + "***************");
        System.out.println("startDate=" + this._startDate + " StartDateString=" + this.getStartDateString());
        System.out.println("recurring=" + this._recurring + " recurringAmt=" + this._recurringAmt + " recurringInterval=" + this._recurringInterval);
    }

    public boolean equals(Object that) {
        if (!(that instanceof SchedulableJob)) {
            return false;
        }
        SchedulableJob thatJob = (SchedulableJob)that;
        return this.equals(thatJob);
    }

    public boolean equals(SchedulableJob thatJob) {
        if (thatJob == null) {
            return false;
        }
        return thatJob._recurring == this._recurring && thatJob._recurringAmt == this._recurringAmt && thatJob._recurringInterval == this._recurringInterval && thatJob._startDateString.equals(this._startDateString);
    }
}

