/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.data.Parameter;
import hec.data.Units;
import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.io.DSSIdentifier;
import hec.lang.annotation.Scriptable;
import hec.model.Interpolate;
import hec.model.RunTimeStep;
import hec.model.SeasonValuePair;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import java.util.Vector;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

@Scriptable
public class SeasonalRecord
implements AsciiSerializable,
Cloneable {
    public static final String INTERP_LINEAR = "Linear";
    public static final String INTERP_CUBIC = "Cubic";
    public static final String INTERP_STEP = "Step";
    public static final int INTERP_LINEAR_ID = 0;
    public static final int INTERP_CUBIC_ID = 1;
    public static final int INTERP_STEP_ID = 2;
    public static final String[] INTERP_STRINGS = new String[]{"Linear", "Cubic", "Step"};
    int[] _timeArray = null;
    double[] _dataArray = null;
    HecTime _startTime;
    int _nyears = -1;
    String _curveLabel;
    double _curveValue = Double.NEGATIVE_INFINITY;
    transient int _interpInterval = -2;
    transient double[] _y2array = null;
    transient double[] _y2arrayLeap = null;
    transient Vector _dataVector = new Vector();
    transient int[] _timeArrayLeap;
    transient boolean _isLeapYear = false;
    transient int[] _timeArrayInterp;
    int _interpolationType = 0;
    int m_parameterId = Integer.MIN_VALUE;
    int m_unitSystem = 0;
    int m_gmtOffset = 0;
    DSSIdentifier _dssId = null;

    @Scriptable
    public void scaleValues(double scl) {
        int i;
        if (this._dataArray != null) {
            int imax = this._dataArray.length;
            i = 0;
            while (i < imax) {
                int n = i++;
                this._dataArray[n] = this._dataArray[n] * scl;
            }
        }
        if (this._dataVector != null) {
            for (i = 0; i < this._dataVector.size(); ++i) {
                SeasonValuePair svp = (SeasonValuePair)this._dataVector.elementAt(i);
                svp.value *= scl;
            }
        }
    }

    @Scriptable
    public void setParameterId(int parameterId) {
        this.m_parameterId = parameterId;
    }

    @Scriptable
    public int getParameterId() {
        return this.m_parameterId;
    }

    @Scriptable
    public void setUnitSystem(int us) {
        if (!Units.isValidUnitsSystem(us)) {
            throw new IllegalArgumentException("ERROR <SeasonalRecord.setUnitSysetm()> : invalid Unit Sysetem " + us + " (2) SI (1) English");
        }
        this.m_unitSystem = us;
    }

    @Scriptable
    public void setGmtOffset(int offset) {
        this.m_gmtOffset = offset;
    }

    @Scriptable
    public int getUnitSystem() {
        return this.m_unitSystem;
    }

    @Scriptable
    public String getUnitsString() {
        try {
            return Parameter.getUnitsStringForSystem(this.m_parameterId, this.getUnitSystem());
        }
        catch (Exception e) {
            System.out.println("getUnitsString: exception " + e);
            return "";
        }
    }

    @Scriptable
    public String getParamIdString() {
        return Parameter.getParamString(this.m_parameterId);
    }

    @Scriptable
    public int getGmtOffset() {
        return this.m_gmtOffset;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        try {
            SeasonalRecord sr = (SeasonalRecord)super.clone();
            sr.m_parameterId = this.m_parameterId;
            sr.m_unitSystem = this.m_unitSystem;
            sr.m_gmtOffset = this.m_gmtOffset;
            if (this._timeArray != null) {
                sr._timeArray = new int[this._timeArray.length];
                System.arraycopy(this._timeArray, 0, sr._timeArray, 0, this._timeArray.length);
            }
            if (this._dataArray != null) {
                sr._dataArray = new double[this._dataArray.length];
                System.arraycopy(this._dataArray, 0, sr._dataArray, 0, this._dataArray.length);
            }
            if (this._y2array != null) {
                sr._y2array = new double[this._y2array.length];
                System.arraycopy(this._y2array, 0, sr._y2array, 0, this._y2array.length);
            }
            if (this._y2arrayLeap != null) {
                sr._y2arrayLeap = new double[this._y2arrayLeap.length];
                System.arraycopy(this._y2arrayLeap, 0, sr._y2arrayLeap, 0, this._y2arrayLeap.length);
            }
            if (this._startTime != null) {
                sr._startTime = new HecTime(this._startTime);
            }
            sr._nyears = this._nyears;
            sr._interpInterval = this._interpInterval;
            sr._interpolationType = this._interpolationType;
            sr._dataVector = new Vector();
            if (this._dataVector != null) {
                for (int i = 0; i < this._dataVector.size(); ++i) {
                    SeasonValuePair svp = (SeasonValuePair)this._dataVector.elementAt(i);
                    sr._dataVector.addElement(svp.clone());
                }
            }
            if (this._timeArrayLeap != null) {
                sr._timeArrayLeap = new int[this._timeArrayLeap.length];
                System.arraycopy(this._timeArrayLeap, 0, sr._timeArrayLeap, 0, this._timeArrayLeap.length);
            }
            if (this._timeArrayInterp != null) {
                sr._timeArrayInterp = new int[this._timeArrayInterp.length];
                System.arraycopy(this._timeArrayInterp, 0, sr._timeArrayInterp, 0, this._timeArrayInterp.length);
            }
            return sr;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void init() {
        int endtime;
        int npts = this._dataVector.size() + 1;
        this._timeArray = new int[npts];
        this._dataArray = new double[npts];
        for (int i = 0; i < this._dataVector.size(); ++i) {
            int tim_minutes;
            SeasonValuePair svp = (SeasonValuePair)this._dataVector.elementAt(i);
            double hecjul1 = HecTime.iymdjl(0, svp.month, svp.day);
            this._timeArray[i] = tim_minutes = (int)hecjul1 + svp.hecMin;
            this._dataArray[i] = svp.value;
        }
        for (endtime = this._timeArray[0] + 525600; endtime < this._timeArray[npts - 2]; endtime += 525600) {
        }
        this._timeArray[npts - 1] = endtime;
        this._dataArray[npts - 1] = this._dataArray[0];
        this.getYears();
        this._y2array = null;
        this._y2arrayLeap = null;
        this.makeLeapYearTimeArray();
        this._timeArrayInterp = this._timeArray;
    }

    @Scriptable
    public void setInterpolationType(int type) {
        if (type >= 0 && type <= 2) {
            this._interpolationType = type;
        }
    }

    protected void initInterpArray() {
        if (this._timeArray == null || this._timeArray.length < 2) {
            return;
        }
        this.makeLeapYearTimeArray();
        this._timeArrayInterp = this._timeArray;
        this._isLeapYear = false;
    }

    protected boolean makeLeapYearTimeArray() {
        if (this._timeArray == null || this._timeArray.length < 1) {
            return false;
        }
        int nsize = this._timeArray.length;
        this._timeArrayLeap = new int[nsize];
        for (int i = 0; i < nsize; ++i) {
            int iday = this._timeArray[i] / 1440;
            this._timeArrayLeap[i] = iday > 59 ? this._timeArray[i] + 1440 : this._timeArray[i];
        }
        return true;
    }

    @Scriptable
    public int getInterpolationType() {
        return this._interpolationType;
    }

    @Scriptable
    public int[] getTimeArray() {
        return this._timeArray;
    }

    @Scriptable
    public double[] getDataArray() {
        return this._dataArray;
    }

    @Scriptable
    public void setArrays(int[] timeArray, double[] dataArray) {
        this.clear();
        this._timeArray = timeArray;
        this._dataArray = dataArray;
        this.makeLeapYearTimeArray();
    }

    @Scriptable
    public void clear() {
        this._dataVector = null;
        this._timeArray = null;
        this._timeArrayLeap = null;
        this._timeArrayInterp = null;
        this._dataArray = null;
        this._startTime = null;
        this._interpInterval = -2;
        this._y2array = null;
        this._y2arrayLeap = null;
        this._isLeapYear = false;
    }

    @Scriptable
    public double interpolate(RunTimeStep runtime) {
        HecTime htime = runtime.getHecTime();
        return this.interpolate(htime);
    }

    @Scriptable
    public double interpolate(HecTime htime) {
        double val;
        double value = Double.NEGATIVE_INFINITY;
        if (this._timeArray == null) {
            this.init();
        }
        if (this._timeArray == null || this._timeArray.length < 2) {
            return value;
        }
        if (this._timeArrayLeap == null) {
            this.makeLeapYearTimeArray();
        }
        this._timeArrayInterp = this._timeArray;
        if (HecTime.isLeap(htime.year())) {
            this._timeArrayInterp = this._timeArrayLeap;
            this._isLeapYear = true;
        }
        int interpTime = this.intervalTime(htime);
        switch (this._interpolationType) {
            case 0: {
                val = this.interpolateValue(interpTime);
                break;
            }
            case 1: {
                val = this.interpolateValueCubicSpline(interpTime);
                break;
            }
            case 2: {
                val = this.interpolateStepValue(interpTime);
                break;
            }
            default: {
                val = this.interpolateValue(interpTime);
            }
        }
        this._timeArrayInterp = this._timeArray;
        this._isLeapYear = false;
        return val;
    }

    @Scriptable
    public double interpolateValue(int interpTime) {
        int k;
        double value = Double.NEGATIVE_INFINITY;
        if (this._timeArray == null) {
            this.init();
        }
        if (this._timeArray == null || this._timeArray.length < 2) {
            return value;
        }
        if (this._timeArrayInterp == null || this._timeArrayInterp.length < 2) {
            this.initInterpArray();
        }
        if ((k = this.findInterval(interpTime)) < 0) {
            return value;
        }
        if (k >= this._timeArrayInterp.length - 1) {
            return this._dataArray[this._timeArrayInterp.length - 1];
        }
        double fact = (double)(interpTime - this._timeArrayInterp[k]) / (double)(this._timeArrayInterp[k + 1] - this._timeArrayInterp[k]);
        value = fact * (this._dataArray[k + 1] - this._dataArray[k]) + this._dataArray[k];
        return value;
    }

    @Scriptable
    public double interpolateStepValue(int interpTime) {
        int k;
        double value = Double.NEGATIVE_INFINITY;
        if (this._timeArray == null) {
            this.init();
        }
        if (this._timeArray == null || this._timeArray.length < 2) {
            return value;
        }
        if (this._timeArrayInterp == null || this._timeArrayInterp.length < 2) {
            this.initInterpArray();
        }
        if ((k = this.findInterval(interpTime)) < 0) {
            return value;
        }
        value = this._dataArray[k];
        return value;
    }

    @Scriptable
    public double interpolateValueCubicSpline(int interpTime) {
        int k;
        double value = Double.NEGATIVE_INFINITY;
        if (this._timeArray == null) {
            this.init();
        }
        if (this._timeArray == null || this._timeArray.length < 2) {
            return value;
        }
        if (this._timeArrayInterp == null || this._timeArrayInterp.length < 2) {
            this.initInterpArray();
        }
        if ((k = this.findInterval(interpTime)) < 0) {
            return value;
        }
        if (k == this._timeArrayInterp.length - 1) {
            return this._dataArray[this._timeArrayInterp.length - 1];
        }
        if (k > this._timeArrayInterp.length - 1) {
            return value;
        }
        double yp0 = 0.0;
        double ypn = 0.0;
        if (this._y2array == null) {
            int npts = this._timeArray.length + 2;
            int[] tmpTimeArray = new int[npts];
            double[] tmpDataArray = new double[npts];
            double[] tmpY2array = new double[npts];
            System.arraycopy(this._timeArray, 0, tmpTimeArray, 1, this._timeArray.length);
            System.arraycopy(this._dataArray, 0, tmpDataArray, 1, this._timeArray.length);
            int nyears = this.getYears();
            tmpTimeArray[0] = this._timeArray[this._timeArray.length - 2] - 525600 * nyears;
            tmpDataArray[0] = this._dataArray[this._dataArray.length - 2];
            tmpTimeArray[npts - 1] = this._timeArray[1] + 525600 * nyears;
            tmpDataArray[npts - 1] = this._dataArray[1];
            tmpY2array = Interpolate.cubicSpline(tmpTimeArray, tmpDataArray, yp0, ypn, npts);
            this._y2array = new double[this._timeArray.length];
            System.arraycopy(tmpY2array, 1, this._y2array, 0, this._timeArray.length);
            if (this._timeArrayLeap == null) {
                this.makeLeapYearTimeArray();
            }
            System.arraycopy(this._timeArrayLeap, 0, tmpTimeArray, 1, this._timeArrayLeap.length);
            tmpTimeArray[0] = this._timeArrayLeap[this._timeArrayLeap.length - 2] - 525600 * nyears;
            if (tmpTimeArray[0] < 60) {
                tmpTimeArray[0] = tmpTimeArray[0] - 1;
            }
            tmpTimeArray[npts - 1] = this._timeArrayLeap[1] + 525600 * nyears;
            if (this._timeArrayLeap[1] < 60) {
                int n = npts - 1;
                tmpTimeArray[n] = tmpTimeArray[n] + 1;
            }
            tmpY2array = Interpolate.cubicSpline(tmpTimeArray, tmpDataArray, yp0, ypn, npts);
            this._y2arrayLeap = new double[this._timeArrayLeap.length];
            System.arraycopy(tmpY2array, 1, this._y2arrayLeap, 0, this._timeArrayLeap.length);
        }
        value = this._isLeapYear ? Interpolate.splineInterpolate(this._timeArrayLeap, this._dataArray, this._y2arrayLeap, interpTime, this._timeArrayLeap.length, k) : Interpolate.splineInterpolate(this._timeArray, this._dataArray, this._y2array, interpTime, this._timeArray.length, k);
        return value;
    }

    int intervalTime(RunTimeStep runtime) {
        HecTime t = runtime.getHecTime();
        return this.intervalTime(t);
    }

    int intervalTime(HecTime t) {
        if (t == null) {
            return 0;
        }
        int simYear = 0;
        int rundate = simYear * 365 * 1440 + t.dayOfYear() * 1440 + t.minutesSinceMidnight();
        if (rundate > this._timeArrayInterp[this._timeArrayInterp.length - 1]) {
            int nyears = this.getYears();
            int shift_time = 525600 * nyears;
            while (rundate > this._timeArrayInterp[this._timeArrayInterp.length - 1]) {
                rundate -= shift_time;
            }
        }
        return rundate;
    }

    public int findInterval(int rundate) {
        if (this._timeArrayInterp.length < 2) {
            return -1;
        }
        int imax = this._timeArrayInterp.length - 1;
        if (this._interpInterval == imax && rundate > this._timeArrayInterp[imax]) {
            return imax;
        }
        if (this._interpInterval < 0 || this._interpInterval >= imax || rundate < this._timeArrayInterp[this._interpInterval] || rundate > this._timeArrayInterp[this._interpInterval + 1]) {
            this._interpInterval = Interpolate.bisearch(this._timeArrayInterp, rundate, this._timeArrayInterp.length);
        }
        if (this._interpInterval < 0 && this._interpInterval > imax) {
            System.out.println(" SeasonalRecord linear interpolation outside interval ");
            System.out.println(" rundate = " + rundate + "  interpInterval = " + this._interpInterval);
            return -1;
        }
        return this._interpInterval;
    }

    @Scriptable
    public void setCurveLabel(String str) {
        this._curveLabel = str;
    }

    @Scriptable
    public String getCurvelLabel() {
        return this._curveLabel;
    }

    @Scriptable
    public double getCurveValue() {
        double curveValue;
        if (this._curveLabel.length() < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        this._curveValue = curveValue = RMAIO.parseDouble(this._curveLabel, Double.NEGATIVE_INFINITY);
        return curveValue;
    }

    @Scriptable
    public String toString() {
        String timeString = "";
        int month = Integer.MIN_VALUE;
        int day = Integer.MIN_VALUE;
        int hecMin = Integer.MIN_VALUE;
        double value = Double.NEGATIVE_INFINITY;
        Object toString = new String();
        for (int i = 0; i < this._dataVector.size(); ++i) {
            SeasonValuePair svp = (SeasonValuePair)this._dataVector.elementAt(i);
            toString = (String)toString + svp.timeString + ", " + svp.value + ", ";
        }
        if (((String)toString).length() > 2) {
            toString = ((String)toString).substring(0, ((String)toString).length() - 2);
        }
        return toString;
    }

    @Scriptable
    public int parseString(String param) {
        if (param == null || param.length() == 0) {
            return 0;
        }
        rmaTokenizer token = new rmaTokenizer(param, ",");
        int icnt = 0;
        SeasonValuePair timeval = null;
        int[] ymd = new int[3];
        int[] hecjul = new int[1];
        try {
            while (true) {
                String valstr = token.nextToken().trim();
                if (icnt % 2 == 0) {
                    timeval = new SeasonValuePair();
                    timeval.timeString = valstr;
                    String datestr = null;
                    String timestr = null;
                    rmaTokenizer datetoken = new rmaTokenizer(valstr, " ");
                    try {
                        datestr = datetoken.nextToken().trim();
                        timestr = datetoken.nextToken().trim();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    if (datestr != null) {
                        int istat = HecTime.datjul(datestr, hecjul);
                        HecTime.jliymd(hecjul[0], ymd);
                        timeval.month = ymd[1];
                        timeval.day = ymd[2];
                    }
                    timeval.hecMin = timestr != null ? HecTime.ihm2m_2(timestr) : 0;
                    if (datestr == null) {
                        break;
                    }
                } else {
                    if (timeval == null) continue;
                    timeval.value = RMAIO.parseDouble(valstr);
                    this._dataVector.addElement(timeval);
                    timeval = null;
                }
                ++icnt;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return icnt / 2;
    }

    @Scriptable
    public int size() {
        if (this._dataArray == null) {
            if (this._dataVector != null) {
                return this._dataVector.size();
            }
            return Integer.MIN_VALUE;
        }
        return this._dataArray.length;
    }

    @Scriptable
    public double getLargestValue() {
        if (this._dataArray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        int imax = this._dataArray.length;
        double mult = 0.0;
        for (int i = 0; i < imax; ++i) {
            if (this._dataArray[i] == Double.NEGATIVE_INFINITY) continue;
            mult = Math.max(mult, this._dataArray[i]);
        }
        return mult;
    }

    @Scriptable
    public double getAnnualAverage() {
        if (this._dataArray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double sum = 0.0;
        HecTime htime = new HecTime("2001-01-01", "12:00");
        for (int j = 0; j < 365; ++j) {
            sum += this.interpolate(htime);
            htime.addDays(1);
        }
        return sum / 365.0;
    }

    @Scriptable
    public double getValue(int id) {
        if (id < 0 || id >= this.size()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._dataArray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this._dataArray[id];
    }

    @Scriptable
    public int getTime(int id) {
        if (id < 0 || id >= this.size()) {
            return Integer.MIN_VALUE;
        }
        if (this._timeArray == null) {
            return Integer.MIN_VALUE;
        }
        return this._timeArray[id];
    }

    @Scriptable
    public int getYears() {
        if (this._timeArray == null || this._timeArray.length < 1) {
            return -1;
        }
        int npts = this._timeArray.length;
        int timdur = this._timeArray[npts - 1] - this._timeArray[0];
        int nyears = timdur / 525600;
        if (timdur % 525600 > 0) {
            ++nyears;
        }
        this._nyears = nyears;
        return this._nyears;
    }

    @Scriptable
    public void setDSSIdentifier(DSSIdentifier dssId) {
        this._dssId = dssId;
    }

    @Scriptable
    public DSSIdentifier getDSSIdentifier() {
        return this._dssId;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

