/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.data.Parameter;
import hec.data.Units;
import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.io.DSSIdentifier;
import hec.lang.annotation.Scriptable;
import hec.model.Interpolate;
import hec.model.RunTimeStep;
import hec.model.SeasonValuePair;
import hec.model.SeasonalRecord;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import rma.util.RMAIO;
import rma.util.RMASort;
import rma.util.rmaTokenizer;

public class SeasonalRecordExt
implements AsciiSerializable,
Cloneable {
    ArrayList<SeasonalRecord> _seasonalRecords = new ArrayList();
    transient int[] _timeArray = null;
    transient double[][] _dataArray = null;
    HecTime _startTime;
    int _nyears = -1;
    transient int _interpInterval = -2;
    transient double[] _y2array = null;
    int _interpolationType = 0;
    int m_parameterId = Integer.MIN_VALUE;
    int m_unitSystem = 0;
    int m_gmtOffset = 0;
    DSSIdentifier _dssId = null;

    @Scriptable
    public SeasonalRecordExt() {
    }

    @Scriptable
    public void setParameterId(int parameterId) {
        this.m_parameterId = parameterId;
    }

    @Scriptable
    public int getParameterId() {
        return this.m_parameterId;
    }

    @Scriptable
    public void setUnitSystem(int us) {
        if (!Units.isValidUnitsSystem(us)) {
            throw new IllegalArgumentException("ERROR <MultipleSeasonalRecords.setUnitSysetm()> : invalid Unit Sysetem " + us + " (2) SI (1) English");
        }
        this.m_unitSystem = us;
    }

    @Scriptable
    public void setGmtOffset(int offset) {
        this.m_gmtOffset = offset;
    }

    @Scriptable
    public int getUnitSystem() {
        return this.m_unitSystem;
    }

    @Scriptable
    public String getUnitsString() {
        try {
            return Parameter.getUnitsStringForSystem(this.m_parameterId, this.getUnitSystem());
        }
        catch (Exception e) {
            System.out.println("getUnitsString: exception " + e);
            return "";
        }
    }

    @Scriptable
    public String getParamIdString() {
        return Parameter.getParamString(this.m_parameterId);
    }

    @Scriptable
    public int getGmtOffset() {
        return this.m_gmtOffset;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        try {
            SeasonalRecordExt msr = (SeasonalRecordExt)super.clone();
            msr.m_parameterId = this.m_parameterId;
            msr.m_unitSystem = this.m_unitSystem;
            msr.m_gmtOffset = this.m_gmtOffset;
            msr._interpolationType = this._interpolationType;
            int nsize = this._seasonalRecords.size();
            for (int i = 0; i < nsize; ++i) {
                SeasonalRecord sr = this._seasonalRecords.get(i);
                if (sr == null) continue;
                SeasonalRecord newSr = (SeasonalRecord)sr.clone();
                msr._seasonalRecords.add(newSr);
            }
            return msr;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void init() {
    }

    @Scriptable
    public void setInterpolationType(int type) {
        if (type >= 0 && type <= 2) {
            this._interpolationType = type;
        }
    }

    @Scriptable
    public int getInterpolationType() {
        return this._interpolationType;
    }

    @Scriptable
    public int[] getTimeArray() {
        if (this._timeArray == null || this._timeArray.length < 1) {
            if (this._seasonalRecords.size() > 0) {
                SeasonalRecord sr = this._seasonalRecords.get(0);
                this._timeArray = (int[])sr._timeArray.clone();
            } else {
                return null;
            }
        }
        return this._timeArray;
    }

    @Scriptable
    public double[][] getDataArray() {
        if (this._dataArray == null || this._dataArray.length < this._seasonalRecords.size()) {
            if (this._seasonalRecords.size() > 0) {
                SeasonalRecord sr;
                int i;
                int nsize = this._seasonalRecords.size();
                int npts = -1;
                for (i = 0; i < nsize; ++i) {
                    sr = this._seasonalRecords.get(i);
                    if (sr == null || npts >= 0 || (npts = sr.size()) <= 0) continue;
                    this._dataArray = new double[nsize][npts];
                    break;
                }
                if (this._dataArray == null) {
                    return null;
                }
                for (i = 0; i < nsize; ++i) {
                    sr = this._seasonalRecords.get(i);
                    if (sr == null) continue;
                    this._dataArray[i] = sr.getDataArray();
                }
            } else {
                return null;
            }
        }
        return this._dataArray;
    }

    public List<SeasonalRecord> getSeasonalRecordsList() {
        return this._seasonalRecords;
    }

    @Scriptable
    public void setCurveLabels(String[] labels) {
        if (labels == null || labels.length == 0) {
            return;
        }
        for (int i = 0; i < this._seasonalRecords.size(); ++i) {
            if (i >= labels.length) {
                return;
            }
            this._seasonalRecords.get(i).setCurveLabel(labels[i]);
        }
    }

    @Scriptable
    public void setCurveLabels(double[] curveValues) {
        if (curveValues == null || curveValues.length == 0) {
            return;
        }
        String[] curveLabels = new String[curveValues.length];
        int ncurves = this._dataArray.length;
        for (int i = 0; i < ncurves; ++i) {
            String curveLabel;
            curveLabels[i] = curveLabel = RMAIO.toString(curveValues[i]);
        }
        this.setCurveLabels(curveLabels);
    }

    @Scriptable
    public void setArrays(Object[][] values) {
        this.clear();
        if (values == null || values.length == 0) {
            return;
        }
        double[][] dataArray = new double[values.length][];
        int[] timeArray = new int[values.length];
        HecTime time = new HecTime();
        for (int i = 0; i < values.length; ++i) {
            Object[] srEntry;
            if (values[i] == null || (srEntry = values[i]).length < 2) continue;
            Object timeObj = srEntry[0];
            if (timeObj instanceof String) {
                time.set((String)timeObj);
                timeArray[i] = time.value();
            }
            dataArray[i] = new double[srEntry.length - 1];
            for (int d = 1; d < srEntry.length; ++d) {
                dataArray[i][d - 1] = RMAIO.parseDouble(srEntry[d]);
            }
        }
        this._timeArray = timeArray;
        this._dataArray = dataArray;
        int ncurves = this._dataArray.length;
        for (int i = 0; i < ncurves; ++i) {
            SeasonalRecord sr = new SeasonalRecord();
            sr.setArrays((int[])this._timeArray.clone(), this._dataArray[i]);
            this._seasonalRecords.add(sr);
        }
    }

    @Scriptable
    public void setArrays(int[] timeArray, double[][] dataArray, double[] curveValues) {
        if (timeArray == null || dataArray == null || curveValues == null) {
            return;
        }
        String[] curveLabels = new String[curveValues.length];
        int ncurves = this._dataArray.length;
        for (int i = 0; i < ncurves; ++i) {
            String curveLabel;
            curveLabels[i] = curveLabel = RMAIO.toString(curveValues[i]);
        }
        this.setArrays(timeArray, dataArray, curveLabels);
    }

    @Scriptable
    public void setArrays(int[] timeArray, double[][] dataArray, String[] curveLabels) {
        this.clear();
        this._timeArray = timeArray;
        this._dataArray = dataArray;
        if (this._timeArray == null || this._dataArray == null || curveLabels == null) {
            return;
        }
        this._seasonalRecords.clear();
        int ncurves = this._dataArray.length;
        int npts = this._timeArray.length;
        for (int i = 0; i < ncurves; ++i) {
            SeasonalRecord sr = new SeasonalRecord();
            sr.setArrays((int[])this._timeArray.clone(), this._dataArray[i]);
            if (i < curveLabels.length) {
                sr.setCurveLabel(curveLabels[i]);
            }
            this._seasonalRecords.add(sr);
        }
    }

    @Scriptable
    public void setArrays(int[] timeArray, double[] dataArray, String curveLabel) {
        this.clear();
        this._timeArray = timeArray;
        this._dataArray = new double[1][dataArray.length];
        this._dataArray[0] = dataArray;
        if (this._timeArray == null || this._dataArray == null || curveLabel == null) {
            return;
        }
        this._seasonalRecords.clear();
        boolean ncurves = true;
        int npts = this._timeArray.length;
        SeasonalRecord sr = new SeasonalRecord();
        sr.setArrays((int[])this._timeArray.clone(), dataArray);
        sr.setCurveLabel(curveLabel);
        this._seasonalRecords.add(sr);
    }

    @Scriptable
    public void setArrays(String[] dateTimeArray, double[][] dataArray, double[] curveValues) {
        if (dateTimeArray == null || dataArray == null || curveValues == null) {
            return;
        }
        String[] curveLabels = new String[curveValues.length];
        int ncurves = this._dataArray.length;
        for (int i = 0; i < ncurves; ++i) {
            String string = RMAIO.toString(curveValues[i]);
        }
        int[] timeArray = this.buildTimeArray(dateTimeArray);
        this._timeArray = timeArray;
        this._dataArray = this._dataArray;
        this.setArrays(timeArray, dataArray, curveValues);
    }

    private int[] buildTimeArray(String[] dateTimeArray) {
        HecTime time = new HecTime();
        int[] timeArray = new int[dateTimeArray.length];
        for (int i = 0; i < dateTimeArray.length; ++i) {
            time.set(dateTimeArray[i]);
            timeArray[i] = time.value();
        }
        return timeArray;
    }

    @Scriptable
    public void setArrays(String[] dateTimeArray, double[][] dataArray, String[] curveLabels) {
        this.clear();
        this._dataArray = dataArray;
        if (this._timeArray == null || this._dataArray == null || curveLabels == null) {
            return;
        }
        this._seasonalRecords.clear();
        int ncurves = this._dataArray.length;
        int npts = this._timeArray.length;
        int[] timeArray = this.buildTimeArray(dateTimeArray);
        this._timeArray = timeArray;
        for (int i = 0; i < ncurves; ++i) {
            SeasonalRecord sr = new SeasonalRecord();
            sr.setArrays((int[])this._timeArray.clone(), this._dataArray[i]);
            sr.setCurveLabel(curveLabels[i]);
        }
    }

    public void setArrays(String[] dateTimeArray, double[] dataArray, String curveLabel) {
        this.clear();
        this._dataArray = new double[1][dataArray.length];
        this._dataArray[0] = dataArray;
        if (dateTimeArray == null || this._dataArray == null || curveLabel == null) {
            return;
        }
        this._seasonalRecords.clear();
        boolean ncurves = true;
        int npts = this._timeArray.length;
        int[] timeArray = this.buildTimeArray(dateTimeArray);
        this._timeArray = timeArray;
        SeasonalRecord sr = new SeasonalRecord();
        sr.setArrays((int[])this._timeArray.clone(), dataArray);
        sr.setCurveLabel(curveLabel);
    }

    @Scriptable
    public void clear() {
        this._timeArray = null;
        this._dataArray = null;
        this._startTime = null;
        this._interpInterval = -2;
        this._y2array = null;
        this._seasonalRecords.clear();
    }

    @Scriptable
    public double interpolate(RunTimeStep runtime, double zvalue) {
        HecTime htime = runtime.getHecTime();
        return this.interpolate(htime, zvalue);
    }

    int intervalTime(RunTimeStep runtime) {
        HecTime t = runtime.getHecTime();
        return this.intervalTime(t);
    }

    int intervalTime(HecTime t) {
        if (t == null) {
            return 0;
        }
        int simYear = 0;
        int rundate = simYear * 365 * 1440 + t.dayOfYear() * 1440 + t.minutesSinceMidnight();
        if (rundate > this._timeArray[this._timeArray.length - 1]) {
            int nyears = this.getYears();
            int shift_time = 525600 * nyears;
            while (rundate > this._timeArray[this._timeArray.length - 1]) {
                rundate -= shift_time;
            }
        }
        return rundate;
    }

    int intervalTime(int rundate) {
        if (rundate > this._timeArray[this._timeArray.length - 1]) {
            int nyears = this.getYears();
            int shift_time = 525600 * nyears;
            while (rundate > this._timeArray[this._timeArray.length - 1]) {
                rundate -= shift_time;
            }
        }
        return rundate;
    }

    public int findInterval(int rundate) {
        if (this._timeArray.length < 2) {
            return -1;
        }
        int imax = this._timeArray.length - 1;
        if (this._interpInterval == imax && rundate > this._timeArray[imax]) {
            return imax;
        }
        if (this._interpInterval < 0 || this._interpInterval >= imax || rundate < this._timeArray[this._interpInterval] || rundate > this._timeArray[this._interpInterval + 1]) {
            this._interpInterval = Interpolate.bisearch(this._timeArray, rundate, this._timeArray.length);
        }
        if (this._interpInterval < 0 && this._interpInterval > imax) {
            System.out.println(" SeasonalRecord linear interpolation outside interval ");
            System.out.println(" rundate = " + rundate + "  interpInterval = " + this._interpInterval);
            return -1;
        }
        return this._interpInterval;
    }

    public String toString() {
        String timeString = "";
        int month = Integer.MIN_VALUE;
        int day = Integer.MIN_VALUE;
        int hecMin = Integer.MIN_VALUE;
        double value = Double.NEGATIVE_INFINITY;
        String toString = new String();
        if (toString.length() > 2) {
            toString = toString.substring(0, toString.length() - 2);
        }
        return toString;
    }

    public int parseString(String param) {
        if (param == null || param.length() == 0) {
            return 0;
        }
        rmaTokenizer token = new rmaTokenizer(param, ",");
        int icnt = 0;
        SeasonValuePair timeval = null;
        int[] ymd = new int[3];
        int[] hecjul = new int[1];
        try {
            while (true) {
                String valstr = token.nextToken().trim();
                if (icnt % 2 == 0) {
                    timeval = new SeasonValuePair();
                    timeval.timeString = valstr;
                    String datestr = null;
                    String timestr = null;
                    rmaTokenizer datetoken = new rmaTokenizer(valstr, " ");
                    try {
                        datestr = datetoken.nextToken().trim();
                        timestr = datetoken.nextToken().trim();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    if (datestr != null) {
                        int istat = HecTime.datjul(datestr, hecjul);
                        HecTime.jliymd(hecjul[0], ymd);
                        timeval.month = ymd[1];
                        timeval.day = ymd[2];
                    }
                    timeval.hecMin = timestr != null ? HecTime.ihm2m_2(timestr) : 0;
                    if (datestr == null) {
                        break;
                    }
                } else {
                    if (timeval == null) continue;
                    timeval.value = RMAIO.parseDouble(valstr);
                    timeval = null;
                }
                ++icnt;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return icnt / 2;
    }

    @Scriptable
    public int size() {
        if (this._timeArray == null) {
            if (this._seasonalRecords != null && this._seasonalRecords.size() > 0) {
                SeasonalRecord sr = this._seasonalRecords.get(0);
                return sr.size();
            }
            return Integer.MIN_VALUE;
        }
        return this._timeArray.length;
    }

    @Scriptable
    public int getTime(int id) {
        if (id < 0 || id >= this.size()) {
            return Integer.MIN_VALUE;
        }
        if (this._timeArray == null) {
            return Integer.MIN_VALUE;
        }
        return this._timeArray[id];
    }

    @Scriptable
    public int getYears() {
        if (this._timeArray == null || this._timeArray.length < 1) {
            return -1;
        }
        int npts = this._timeArray.length;
        int timdur = this._timeArray[npts - 1] - this._timeArray[0];
        int nyears = timdur / 525600;
        if (timdur % 525600 > 0) {
            ++nyears;
        }
        this._nyears = nyears;
        return this._nyears;
    }

    @Scriptable
    public double interpolate(HecTime htime, double zvalue) {
        int nsize = this._seasonalRecords.size();
        double[] curveLabelValues = this.getCurveLabelValues();
        int icurve = -1;
        double yvalue = Double.NEGATIVE_INFINITY;
        if (zvalue < curveLabelValues[0]) {
            icurve = 0;
            SeasonalRecord sr = this._seasonalRecords.get(0);
            double interpValue0 = sr.interpolate(htime);
            return interpValue0;
        }
        if (zvalue >= curveLabelValues[nsize - 1]) {
            icurve = nsize - 1;
            SeasonalRecord sr = this._seasonalRecords.get(icurve);
            double interpValue0 = sr.interpolate(htime);
            return interpValue0;
        }
        for (int i = 1; i < nsize; ++i) {
            if (!(zvalue < curveLabelValues[i])) continue;
            icurve = i - 1;
            break;
        }
        SeasonalRecord sr = this._seasonalRecords.get(icurve);
        double interpValue0 = sr.interpolate(htime);
        if (this._interpolationType == 2) {
            yvalue = interpValue0;
        } else {
            if (this._interpolationType == 0) {
                sr = this._seasonalRecords.get(icurve + 1);
                double interpValue1 = sr.interpolate(htime);
                double fact = (zvalue - curveLabelValues[icurve]) / (curveLabelValues[icurve + 1] - curveLabelValues[icurve]);
                yvalue = fact * (interpValue1 - interpValue0) + interpValue0;
                return yvalue;
            }
            if (this._interpolationType == 1) {
                double[] curveValuesArray = new double[nsize];
                for (int isr = 0; isr < nsize - 1; ++isr) {
                    sr = this._seasonalRecords.get(isr);
                    curveValuesArray[isr] = sr.interpolate(htime);
                }
                double yp0 = 0.0;
                double ypn = 0.0;
                this._y2array = Interpolate.cubicSpline(curveLabelValues, curveValuesArray, yp0, ypn, nsize);
                yvalue = Interpolate.splineInterpolate(curveLabelValues, curveValuesArray, this._y2array, zvalue, nsize);
            }
        }
        return yvalue;
    }

    @Scriptable
    public int getNumberCurves() {
        if (this._seasonalRecords != null) {
            return this._seasonalRecords.size();
        }
        return 0;
    }

    @Scriptable
    public String[] getCurveLabels() {
        int nsize = this._seasonalRecords.size();
        String[] curveLabels = new String[nsize];
        for (int i = 0; i < nsize; ++i) {
            SeasonalRecord sr = this._seasonalRecords.get(i);
            if (sr == null) continue;
            curveLabels[i] = sr.getCurvelLabel();
        }
        return curveLabels;
    }

    @Scriptable
    public double[] getCurveLabelValues() {
        int nsize = this._seasonalRecords.size();
        double[] curveValues = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            SeasonalRecord sr = this._seasonalRecords.get(i);
            if (sr == null) continue;
            curveValues[i] = sr.getCurveValue();
        }
        return curveValues;
    }

    @Scriptable
    public void addSeasonalRecord(SeasonalRecord sr) {
        int nsize = this._seasonalRecords.size();
        double curveLabelValue = sr.getCurveValue();
        boolean addToEnd = true;
        for (int i = 0; i < nsize; ++i) {
            double curveLabelValue0 = Double.NEGATIVE_INFINITY;
            SeasonalRecord sr0 = this._seasonalRecords.get(i);
            if (sr0 == null || !((curveLabelValue0 = sr0.getCurveValue()) >= curveLabelValue)) continue;
            this._seasonalRecords.add(i, sr);
            addToEnd = false;
            break;
        }
        if (addToEnd) {
            this._seasonalRecords.add(sr);
        }
    }

    @Scriptable
    public void removeCurve(int index) {
        if (this._seasonalRecords != null && this._seasonalRecords.size() > index && index >= 0) {
            this._seasonalRecords.remove(index);
        }
    }

    protected void sortSeasonalRecords() {
        int nsize = this._seasonalRecords.size();
        double[] curveValues = new double[nsize];
        Integer[] idx = new Integer[nsize];
        for (int i = 0; i < nsize; ++i) {
            double curveValue = Double.NEGATIVE_INFINITY;
            SeasonalRecord sr = this._seasonalRecords.get(i);
            if (sr != null) {
                curveValue = sr.getCurveValue();
            }
            curveValues[i] = curveValue;
            idx[i] = new Integer(i);
        }
        boolean needToSort = false;
        for (int i = 1; i < nsize; ++i) {
            if (!(curveValues[i] < curveValues[i - 1])) continue;
            needToSort = true;
            break;
        }
        if (needToSort) {
            Object[] objArray = this._seasonalRecords.toArray();
            RMASort.quickSort(curveValues, objArray);
            this._seasonalRecords.clear();
            for (int i = 0; i < nsize; ++i) {
                this._seasonalRecords.add((SeasonalRecord)objArray[i]);
            }
        }
    }

    public void setDSSIdentifier(DSSIdentifier dssId) {
        this._dssId = dssId;
    }

    public DSSIdentifier getDSSIdentifier() {
        return this._dssId;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

