/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.model.RunTime;
import hec.model.RunTimeStep;
import hec.model.SeasonValuePair;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import java.util.Vector;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

public class SeasonalValue
implements AsciiSerializable {
    Vector _dataVector = new Vector();

    public void clearData() {
        this._dataVector.clear();
    }

    public void addValue(String datestr, double val) {
    }

    public double interpolateValue(RunTimeStep rts) {
        int hecJul = rts.hecJulian();
        int hecMin = rts.hecMinutes();
        int year = rts.getHecTime().year();
        return this.interpolateValue(hecMin, hecJul, year);
    }

    public double interpolateValue(RunTime runtime) {
        return this.interpolateValue(runtime.hecMin, runtime.hecJul, runtime.year);
    }

    private double interpolateValue(int hecMin, int hecJul, int year) {
        int hecjul1;
        double value = Double.NEGATIVE_INFINITY;
        if (this._dataVector.size() < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        SeasonValuePair rec0 = null;
        SeasonValuePair rec1 = null;
        int imax = this._dataVector.size();
        if (imax == 1) {
            rec1 = (SeasonValuePair)this._dataVector.elementAt(0);
            if (rec1 != null) {
                value = rec1.value;
            }
            return value;
        }
        int[] ymd = new int[3];
        double date0 = 0.0;
        double date1 = 0.0;
        double rundate = (double)hecJul + (double)hecMin / 1440.0;
        for (int i = 0; i < imax && (rec1 = (SeasonValuePair)this._dataVector.elementAt(i)) != null; ++i) {
            int hecjul0;
            hecjul1 = HecTime.iymdjl(year, rec1.month, rec1.day);
            date1 = (double)hecjul1 + (double)rec1.hecMin / 1440.0;
            if (date1 >= rundate) {
                if (i == 0) {
                    rec0 = (SeasonValuePair)this._dataVector.elementAt(imax - 1);
                    hecjul0 = HecTime.iymdjl(year - 1, rec0.month, rec0.day);
                    date0 = (double)hecjul0 + (double)rec0.hecMin / 1440.0;
                }
                value = rec0.value + (rec1.value - rec0.value) * (rundate - date0) / (date1 - date0);
                return value;
            }
            rec0 = rec1;
            hecjul0 = hecjul1;
            date0 = date1;
        }
        rec1 = (SeasonValuePair)this._dataVector.elementAt(0);
        hecjul1 = HecTime.iymdjl(year + 1, rec1.month, rec1.day);
        date1 = (double)hecjul1 + (double)rec1.hecMin / 1440.0;
        value = rec0.value + (rec1.value - rec0.value) * (rundate - date0) / (date1 - date0);
        return value;
    }

    public double interpolateStepValue(RunTimeStep rts) {
        int hecJul = rts.hecJulian();
        int hecMin = rts.hecMinutes();
        int year = rts.getHecTime().year();
        return this.interpolateStepValue(hecMin, hecJul, year);
    }

    public double interpolateStepValue(RunTime runtime) {
        return this.interpolateStepValue(runtime.hecMin, runtime.hecJul, runtime.year);
    }

    private double interpolateStepValue(int hecMin, int hecJul, int year) {
        double value = Double.NEGATIVE_INFINITY;
        if (this._dataVector.size() < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        SeasonValuePair rec0 = null;
        SeasonValuePair rec1 = null;
        int imax = this._dataVector.size();
        if (imax == 1) {
            rec1 = (SeasonValuePair)this._dataVector.elementAt(0);
            if (rec1 != null) {
                value = rec1.value;
            }
            return value;
        }
        int[] ymd = new int[3];
        double date0 = 0.0;
        double date1 = 0.0;
        double rundate = (double)hecJul + (double)hecMin / 1440.0;
        for (int i = 0; i < imax && (rec1 = (SeasonValuePair)this._dataVector.elementAt(i)) != null; ++i) {
            int hecjul0;
            int hecjul1;
            if (rec1.month == 12 && rec1.day == 31 && rec1.hecMin == 1440) {
                rec1.month = 1;
                rec1.day = 1;
                rec1.hecMin = 0;
            }
            if ((date1 = (double)(hecjul1 = HecTime.iymdjl(year, rec1.month, rec1.day)) + (double)rec1.hecMin / 1440.0) >= rundate) {
                if (i == 0) {
                    rec0 = (SeasonValuePair)this._dataVector.elementAt(imax - 1);
                    hecjul0 = HecTime.iymdjl(year - 1, rec0.month, rec0.day);
                    date0 = (double)hecjul0 + (double)rec0.hecMin / 1440.0;
                }
                return rec0.value;
            }
            rec0 = rec1;
            hecjul0 = hecjul1;
            date0 = date1;
        }
        return rec0.value;
    }

    public String toString() {
        String timeString = "";
        int month = Integer.MIN_VALUE;
        int day = Integer.MIN_VALUE;
        int hecMin = Integer.MIN_VALUE;
        double value = Double.NEGATIVE_INFINITY;
        Object toString = new String();
        for (int i = 0; i < this._dataVector.size(); ++i) {
            SeasonValuePair svp = (SeasonValuePair)this._dataVector.elementAt(i);
            toString = (String)toString + svp.timeString + ", " + svp.value + ", ";
        }
        if (((String)toString).length() > 2) {
            toString = ((String)toString).substring(0, ((String)toString).length() - 2);
        }
        return toString;
    }

    public int parseString(String param) {
        if (param == null || param.length() == 0) {
            return 0;
        }
        rmaTokenizer token = new rmaTokenizer(param, ",");
        int icnt = 0;
        SeasonValuePair timeval = null;
        int[] ymd = new int[3];
        int[] hecjul = new int[1];
        try {
            while (true) {
                String valstr = token.nextToken().trim();
                if (icnt % 2 == 0) {
                    timeval = new SeasonValuePair();
                    timeval.timeString = valstr;
                    String datestr = null;
                    String timestr = null;
                    rmaTokenizer datetoken = new rmaTokenizer(valstr, " ");
                    try {
                        datestr = datetoken.nextToken().trim();
                        timestr = datetoken.nextToken().trim();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    if (datestr != null) {
                        int istat = HecTime.datjul(datestr, hecjul);
                        HecTime.jliymd(hecjul[0], ymd);
                        timeval.month = ymd[1];
                        timeval.day = ymd[2];
                    }
                    timeval.hecMin = timestr != null ? HecTime.ihm2m_2(timestr) : 0;
                    if (datestr == null) {
                        break;
                    }
                } else {
                    if (timeval == null) continue;
                    timeval.value = RMAIO.parseDouble(valstr);
                    this._dataVector.addElement(timeval);
                    timeval = null;
                }
                ++icnt;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return icnt / 2;
    }

    private boolean parseDateString(String valstr, SeasonValuePair timeval) {
        int[] ymd = new int[3];
        int[] hecjul = new int[1];
        timeval.timeString = valstr;
        String datestr = null;
        String timestr = null;
        rmaTokenizer datetoken = new rmaTokenizer(valstr, " ");
        try {
            datestr = datetoken.nextToken().trim();
            timestr = datetoken.nextToken().trim();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (datestr != null) {
            int istat = HecTime.datjul(datestr, hecjul);
            HecTime.jliymd(hecjul[0], ymd);
            timeval.month = ymd[1];
            timeval.day = ymd[2];
        }
        timeval.hecMin = timestr != null ? HecTime.ihm2m_2(timestr) : 0;
        return datestr != null;
    }

    public int size() {
        return this._dataVector.size();
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

