/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.event.LockEvent;
import hec.lang.NamedType;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.map.streamAlignment.StreamAlignmentNodeIfc;
import hec.model.StreamNode;
import hec.model.StreamPolyLine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Vector;
import rma.lang.RmaMath;
import rma.util.RMAIO;

public class StreamElement
extends NamedType
implements Serializable {
    transient StreamAlignmentNodeIfc _alignment = null;
    WorldPt _referencePt = new WorldPt();
    StreamPolyLine _line = new StreamPolyLine();
    Vector<StreamNode> _nodeVector = new Vector();
    transient boolean _isSorted = false;

    public StreamElement() {
    }

    public StreamElement(StreamAlignmentNodeIfc sys, int idx) {
        this._alignment = sys;
        this._index = idx;
    }

    public void reverseDirection() {
        this._line.reverseDirection();
        int imax = this._nodeVector.size();
        for (int i = 0; i < imax; ++i) {
            StreamNode n = this._nodeVector.elementAt(i);
            if (n == null) continue;
            double c2 = n.getStreamCoord();
            n.setStreamCoord(1.0 - c2);
        }
        this._isSorted = false;
        this.getNodeVectorSorted();
        this.setModified(true);
    }

    public StreamAlignmentIfc getAlignment() {
        if (this._alignment instanceof StreamAlignmentIfc) {
            return (StreamAlignmentIfc)this._alignment;
        }
        return null;
    }

    public void setAlignment(StreamAlignmentNodeIfc alignment) {
        this._alignment = alignment;
    }

    public WorldLine getLine() {
        return this._line;
    }

    public Vector<StreamNode> getNodeVector() {
        return this._nodeVector;
    }

    public Vector<StreamNode> getNodeVectorSorted() {
        Vector<StreamNode> nodeVecSorted = this.getNodeVector();
        if (this._isSorted) {
            return nodeVecSorted;
        }
        nodeVecSorted.sort(new NodeComparator());
        this._isSorted = true;
        return nodeVecSorted;
    }

    public WorldPt getReferencePt() {
        return this._referencePt;
    }

    public void setReferencePt(WorldPt pt) {
        this._referencePt = pt;
    }

    public void setLine(StreamPolyLine reg) {
        if (reg == null) {
            return;
        }
        this._line = reg;
        this._referencePt = (WorldPt)this._line.pts.elementAt(0);
    }

    public WorldPt getLocationByCoord(double coord) {
        return this._line.getLocationByCoord(coord);
    }

    public double getCoordByLocation(WorldPt wpt) {
        return this._line.getCoordAtLocation(wpt);
    }

    public WorldPt getLocationByStation(double station) {
        double c2 = this.getCoordByStation(station);
        return this._line.getLocationByCoord(c2);
    }

    public double getStationByLocation(WorldPt wpt) {
        double c2 = this.getCoordByLocation(wpt);
        return this.getStationByCoord(c2);
    }

    public double getStationByCoord(double coord) {
        if (coord == Double.NEGATIVE_INFINITY || coord < 0.0) {
            coord = 0.0;
        }
        if (coord > 1.0) {
            coord = 1.0;
        }
        double st0 = 0.0;
        double c0 = 0.0;
        double st1 = Double.NEGATIVE_INFINITY;
        double c1 = 1.0;
        double len = this._line.getLength();
        int i = 0;
        StreamNode n0 = null;
        StreamNode n1 = null;
        Vector<StreamNode> nodeSorted = this.getNodeVectorSorted();
        for (i = 0; i < nodeSorted.size(); ++i) {
            StreamNode n = nodeSorted.elementAt(i);
            if (n.isDefaultStation()) continue;
            n0 = n1;
            n1 = n;
            if (n.getStreamCoord() >= coord && n0 != null) break;
        }
        if (n0 == null && n1 == null) {
            return coord * len;
        }
        if (n0 == null || n1 == null) {
            if (n0 == null) {
                c0 = n1.getStreamCoord();
                st0 = n1.getStation();
            } else {
                c0 = n0.getStreamCoord();
                st0 = n0.getStation();
            }
            return st0 + (coord - c0) * len;
        }
        c0 = n0.getStreamCoord();
        st0 = n0.getStation();
        c1 = n1.getStreamCoord();
        st1 = n1.getStation();
        return st0 + (st1 - st0) * (coord - c0) / (c1 - c0);
    }

    public double getCoordByStation(double station) {
        double newcoord;
        double st0 = 0.0;
        double c0 = 0.0;
        double st1 = Double.NEGATIVE_INFINITY;
        double c1 = 1.0;
        double len = this._line.getLength();
        int i = 0;
        StreamNode n0 = null;
        StreamNode n1 = null;
        Vector<StreamNode> nodeSorted = this.getNodeVectorSorted();
        for (i = 0; i < nodeSorted.size(); ++i) {
            StreamNode n = nodeSorted.elementAt(i);
            if (n.isDefaultStation()) continue;
            n0 = n1;
            n1 = n;
            if (n.getStation() >= station && n0 != null) break;
        }
        if (n0 == null && n1 == null) {
            if (len == 0.0) {
                return 0.0;
            }
            newcoord = station / len;
        } else if (n0 == null || n1 == null) {
            if (n0 == null) {
                c0 = n1.getStreamCoord();
                st0 = n1.getStation();
            } else {
                c0 = n0.getStreamCoord();
                st0 = n0.getStation();
            }
            newcoord = c0 + (station - st0) / len;
        } else {
            c0 = n0.getStreamCoord();
            st0 = n0.getStation();
            c1 = n1.getStreamCoord();
            st1 = n1.getStation();
            newcoord = c0 + (station - st0) * (c1 - c0) / (st1 - st0);
        }
        if (newcoord < 0.0) {
            newcoord = 0.0;
        }
        if (newcoord > 1.0) {
            newcoord = 1.0;
        }
        return newcoord;
    }

    public void addNode(StreamNode node) {
        this._isSorted = false;
        double coord = node.getStreamCoord();
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode n = this._nodeVector.elementAt(i);
            if (!(coord < n.getStreamCoord())) continue;
            this._nodeVector.insertElementAt(node, i);
            return;
        }
        this._nodeVector.addElement(node);
    }

    public void deleteStreamNode(StreamNode node) {
        this._isSorted = false;
        this._nodeVector.removeElement(node);
    }

    public StreamNode getUpstreamNode() {
        if (this._nodeVector.size() < 1) {
            return null;
        }
        return this._nodeVector.lastElement();
    }

    public StreamNode getDownstreamNode() {
        if (this._nodeVector.size() < 2) {
            return null;
        }
        return this._nodeVector.firstElement();
    }

    public boolean readData(BufferedReader input) {
        try {
            String line = input.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = input.readLine();
                    continue;
                }
                String type = RMAIO.getType(line, "=");
                String param = RMAIO.getParam(line, "=");
                if ("Stream Name".equals(type) || "StreamElement Name".equals(type)) {
                    this.setName(param);
                } else if ("Stream Desc".equals(type) || "StreamElement Description".equals(type)) {
                    this.setDescription(param);
                } else if ("Stream RefPt".equals(type) || "StreamElement ReferencePt".equals(type)) {
                    this._referencePt.parseString(param);
                } else if ("Stream Region".equals(type) || "StreamElement Region".equals(type)) {
                    this._line.parseString(param);
                } else if ("Stream Node".equals(type) || "StreamElement Node".equals(type)) {
                    int id = RMAIO.parseInt(param);
                    StreamNode n = this._alignment.getNode(id);
                    if (n != null) {
                        this._nodeVector.addElement(n);
                        n.setStream(this);
                    }
                } else if ("Stream End".equals(type) || "StreamElement End".equals(type)) break;
                line = input.readLine();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean writeData(BufferedWriter out) {
        String strout = new String();
        RMAIO.fout(out, "Stream=" + this.getIndex());
        RMAIO.fout(out, "Stream Name= " + this.getName());
        RMAIO.fout(out, "Stream Desc= " + this.getDescription());
        RMAIO.fout(out, "Stream RefPt= " + this._referencePt.toString());
        RMAIO.fout(out, "");
        RMAIO.fout(out, "Stream Region= " + this._line.toString());
        RMAIO.fout(out, "");
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode n = this._nodeVector.elementAt(i);
            if (n == null) continue;
            RMAIO.fout(out, "Stream Node=" + n.getIndex());
        }
        RMAIO.fout(out, "Stream End");
        RMAIO.fout(out, "");
        return true;
    }

    public StreamPolyLine getLineSegment(double downStreamCoord, double upStreamCoord) {
        return this._line.getLineSegment(downStreamCoord, upStreamCoord);
    }

    public void resetNodeCoord() {
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode n = this._nodeVector.elementAt(i);
            if (i > 0 && i < this._nodeVector.size() - 1) {
                n.setStreamCoord(this.getCoordByLocation(n.getLastLocation()));
            }
            n.setLocation(new WorldPt());
        }
        this.setModified(true);
    }

    public double getNameCoord() {
        double coord = 0.0;
        double c0 = 0.0;
        double len = 0.0;
        for (int i = 1; i < this._nodeVector.size(); ++i) {
            StreamNode n = this._nodeVector.elementAt(i);
            if (n == null) continue;
            if (n.getStreamCoord() - c0 > len) {
                coord = (c0 + n.getStreamCoord()) / 2.0;
            }
            c0 = n.getStreamCoord();
        }
        return coord;
    }

    public void setLinePoint(double coord, WorldPt wpt) {
        this._line.setLinePoint(coord, wpt);
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public boolean loadId() {
        return true;
    }

    public void locked(LockEvent event) {
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StreamElement)) {
            return false;
        }
        return this.getName().equals(((StreamElement)obj).getName());
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this._line.isModified();
    }

    static class NodeComparator
    implements Comparator<StreamNode> {
        NodeComparator() {
        }

        @Override
        public int compare(StreamNode sn1, StreamNode sn2) {
            double c2;
            int mod = 1;
            double c1 = sn1.getStreamCoord();
            if (RmaMath.equals(c1, c2 = sn2.getStreamCoord(), 1.0E-13)) {
                return 0;
            }
            if (c1 < c2) {
                return mod * -1;
            }
            if (c1 > c2) {
                return mod * 1;
            }
            return -2;
        }
    }
}

