/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.event.LockEvent;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.map.WorldPt;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.map.streamAlignment.StreamAlignmentNodeIfc;
import hec.model.StreamElement;
import hec.model.StreamNode;
import hec.model.StreamSegment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import rma.util.RMAIO;

public class StreamJunction
extends NamedType
implements AsciiSerializable,
Serializable {
    transient StreamAlignmentNodeIfc _alignment = null;
    Vector _nodeVector = new Vector();
    int _index = Integer.MIN_VALUE;

    public StreamJunction() {
    }

    public StreamJunction(StreamAlignmentIfc a) {
        this._alignment = a;
    }

    public int getOutflowingStreamSegments(Vector vec) {
        if (vec == null) {
            return 0;
        }
        int imax = this._nodeVector.size();
        int icnt = 0;
        for (int i = 0; i < imax; ++i) {
            StreamNode node = (StreamNode)this._nodeVector.elementAt(i);
            if (node.getStreamCoord() == 0.0) continue;
            StreamSegment sseg = new StreamSegment();
            sseg.stream = node.getStream();
            sseg.streamIndex = sseg.stream.getIndex();
            sseg.upstreamCoord = node.getStreamCoord();
            sseg.downstreamCoord = 0.0;
            vec.add(sseg);
            ++icnt;
        }
        return icnt;
    }

    public int getOutflowingStreams(Vector vec) {
        if (vec == null) {
            return 0;
        }
        int imax = this._nodeVector.size();
        int icnt = 0;
        for (int i = 0; i < imax; ++i) {
            StreamNode node = (StreamNode)this._nodeVector.elementAt(i);
            if (node.getStreamCoord() == 0.0) continue;
            vec.add(node.getStream());
            ++icnt;
        }
        return icnt;
    }

    public int getInflowingStreams(Vector vec) {
        if (vec == null) {
            return 0;
        }
        int imax = this._nodeVector.size();
        int icnt = 0;
        for (int i = 0; i < imax; ++i) {
            StreamNode node = (StreamNode)this._nodeVector.elementAt(i);
            if (node.getStreamCoord() != 0.0) continue;
            vec.add(node.getStream());
            ++icnt;
        }
        return icnt;
    }

    public void setAlignment(StreamAlignmentNodeIfc a) {
        this._alignment = a;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public void setIndex(int id) {
        this._index = id;
        this.setModified(true);
    }

    public boolean contains(StreamElement reach) {
        for (int ii = 0; ii < this._nodeVector.size(); ++ii) {
            StreamNode node = (StreamNode)this._nodeVector.get(ii);
            if (node == null || node.getStream() == null || !node.getStream().equals(reach)) continue;
            return true;
        }
        return false;
    }

    public Vector getNodeVector() {
        return this._nodeVector;
    }

    public List getOutflowingNodes() {
        ArrayList<StreamNode> l = new ArrayList<StreamNode>(this._nodeVector.size());
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode node = (StreamNode)this._nodeVector.get(i);
            if (node == null || node.getStreamCoord() == 0.0) continue;
            l.add(node);
        }
        return l;
    }

    public void addNode(StreamNode n) {
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            if (n != this._nodeVector.elementAt(i)) continue;
            return;
        }
        this._nodeVector.addElement(n);
        n.setJunction(this);
        this.setModified(true);
    }

    public void removeNode(StreamNode n) {
        if (this._nodeVector.removeElement(n)) {
            n.setJunction(null);
            this.setModified(true);
        }
    }

    public void removeAllNodes() {
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode n = (StreamNode)this._nodeVector.elementAt(i);
            if (n == null) continue;
            n.setJunction(null);
        }
        this._nodeVector.removeAllElements();
        this.setModified(true);
    }

    public boolean readData(BufferedReader input) {
        try {
            String line = input.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = input.readLine();
                    continue;
                }
                String type = RMAIO.getType(line, "=");
                String param = RMAIO.getParam(line, "=");
                if ("Junction Node".equals(type) || "StreamJunction Node".equals(type)) {
                    int id = RMAIO.parseInt(param);
                    StreamNode n = this._alignment.getNode(id);
                    if (n != null) {
                        this.addNode(n);
                    }
                } else if ("Junction End".equals(type) || "StreamJunction End".equals(type)) break;
                line = input.readLine();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean writeData(BufferedWriter out) {
        String strout = new String();
        RMAIO.fout(out, "Junction=" + this.getIndex());
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode n = (StreamNode)this._nodeVector.elementAt(i);
            if (n == null) continue;
            RMAIO.fout(out, "Junction Node=" + n.getIndex());
        }
        RMAIO.fout(out, "Junction End");
        RMAIO.fout(out, "");
        return true;
    }

    public WorldPt getLocation() {
        if (this._nodeVector.size() > 0) {
            for (int i = 0; i < this._nodeVector.size(); ++i) {
                StreamNode node = (StreamNode)this._nodeVector.get(i);
                if (node == null) continue;
                return node.getLocation();
            }
        }
        return new WorldPt();
    }

    public StreamNode getNodeOnStream(StreamElement elem) {
        if (elem == null) {
            return null;
        }
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode node = (StreamNode)this._nodeVector.get(i);
            if (node == null || elem != node.getStream()) continue;
            return node;
        }
        return null;
    }

    public void updateLocation() {
        double coord;
        StreamNode n;
        int i;
        if (this._nodeVector.size() < 2) {
            return;
        }
        StreamNode refnode = null;
        for (i = 0; i < this._nodeVector.size(); ++i) {
            n = (StreamNode)this._nodeVector.elementAt(i);
            if (n == null) {
                return;
            }
            coord = n.getStreamCoord();
            if (coord == 1.0 || coord == 0.0) continue;
            refnode = n;
            break;
        }
        if (refnode == null) {
            for (i = 0; i < this._nodeVector.size(); ++i) {
                n = (StreamNode)this._nodeVector.elementAt(i);
                if (n == null) {
                    return;
                }
                coord = n.getStreamCoord();
                if (coord != 1.0) continue;
                refnode = n;
                break;
            }
        }
        if (refnode == null) {
            return;
        }
        WorldPt wpt = refnode.getLocation();
        for (int i2 = 0; i2 < this._nodeVector.size(); ++i2) {
            StreamNode n2 = (StreamNode)this._nodeVector.elementAt(i2);
            if (n2 == null || n2 == refnode) continue;
            StreamElement stream = n2.getStream();
            double coord2 = n2.getStreamCoord();
            stream.setLinePoint(coord2, wpt);
        }
        this.setModified(true);
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean loadId() {
        return true;
    }

    public void locked(LockEvent event) {
    }
}

