/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.event.LockEvent;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.map.WorldPt;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import rma.util.RMAIO;

public class StreamNode
extends NamedType
implements AsciiSerializable,
Serializable,
Cloneable {
    transient StreamAlignmentIfc _alignment = null;
    StreamElement _stream = null;
    StreamJunction _junction = null;
    WorldPt _location = new WorldPt();
    double _station = Double.NEGATIVE_INFINITY;
    boolean _defaultStation = true;
    double _streamCoord = Double.NEGATIVE_INFINITY;
    int _index = Integer.MIN_VALUE;

    public StreamNode() {
    }

    public StreamNode(StreamAlignmentIfc a) {
        this._alignment = a;
    }

    public StreamNode(StreamAlignmentIfc a, StreamElement strm) {
        this._alignment = a;
        this._stream = strm;
    }

    public void setAlignment(StreamAlignmentIfc a) {
        this._alignment = a;
    }

    @Override
    public String toString() {
        return RMAIO.setPrecision2(this.getStreamCoord(), 6);
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public void setIndex(int id) {
        this._index = id;
    }

    public boolean isDefaultStation() {
        return this._defaultStation;
    }

    public void setDefaultStation(boolean b) {
        this._defaultStation = b;
        this.setModified(true);
    }

    public StreamElement getStream() {
        return this._stream;
    }

    public void setStream(StreamElement s) {
        this._stream = s;
        this.setModified(true);
    }

    public StreamJunction getJunction() {
        return this._junction;
    }

    public void setJunction(StreamJunction j) {
        this._junction = j;
        this.setModified(true);
    }

    public void setStation(double st) {
        this._station = st;
        this._defaultStation = false;
        this.setModified(true);
    }

    public double getStation() {
        if (this._defaultStation) {
            return this._stream.getStationByCoord(this._streamCoord);
        }
        return this._station;
    }

    public void setStreamCoord(double coord) {
        this._streamCoord = coord;
        if (this._stream != null) {
            this._location = this._stream.getLocationByCoord(this._streamCoord);
            if (this._defaultStation) {
                this._station = this._stream.getStationByCoord(this._streamCoord);
            }
        } else {
            this._location = null;
        }
        this.setModified(true);
    }

    public double getStreamCoord() {
        return this._streamCoord;
    }

    public void setLocation(WorldPt loc) {
        this._location = loc;
        this.setModified(true);
    }

    public WorldPt getLocation() {
        if (this._location != null && this._location.isValid()) {
            return this._location;
        }
        if (this._streamCoord != Double.NEGATIVE_INFINITY) {
            if (this._stream == null) {
                System.out.println("no Stream for node " + this._index);
                this._location = null;
            } else {
                this._location = this._stream.getLocationByCoord(this._streamCoord);
                if (this._defaultStation) {
                    this._station = this._stream.getStationByCoord(this._streamCoord);
                }
            }
        }
        return this._location;
    }

    public WorldPt getLastLocation() {
        return this._location;
    }

    public boolean readData(BufferedReader input) {
        try {
            String line = input.readLine();
            while (line != null) {
                int id;
                if (line.length() == 0) {
                    line = input.readLine();
                    continue;
                }
                String type = RMAIO.getType(line, "=");
                String param = RMAIO.getParam(line, "=");
                if ("Node StreamIdx".equals(type) || "StreamNode StreamIdx".equals(type)) {
                    id = RMAIO.parseInt(param);
                    if (this._alignment != null) {
                        this._stream = this._alignment.getReach(id);
                    }
                } else if ("Node JunctionIdx".equals(type) || "StreamNode JunctionIdx".equals(type)) {
                    id = RMAIO.parseInt(param);
                    if (this._alignment != null) {
                        this._junction = this._alignment.getJunction(id);
                    }
                } else if ("Node Location".equals(type) || "StreamNode Location".equals(type)) {
                    this._location.parseString(param);
                } else if ("Node Station".equals(type) || "StreamNode Station".equals(type)) {
                    this._station = RMAIO.parseDouble(param);
                } else if ("Node defaultStation".equals(type) || "StreamNode _defaultStation".equals(type)) {
                    this._defaultStation = param.equals("true");
                } else if ("Node Coord".equals(type) || "StreamNode StreamCoord".equals(type)) {
                    this._streamCoord = RMAIO.parseDouble(param);
                } else if ("Node End".equals(type) || "StreamNode End".equals(type)) break;
                line = input.readLine();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean writeData(BufferedWriter out) {
        String strout = new String();
        RMAIO.fout(out, "Node=" + this.getIndex());
        if (this._stream != null) {
            RMAIO.fout(out, "Node StreamIdx=" + this._stream.getIndex());
        }
        if (this._junction != null) {
            RMAIO.fout(out, "Node JunctionIdx=" + this._junction.getIndex());
        }
        if (this._location != null && this._location.isValid()) {
            RMAIO.fout(out, "Node Location=" + this._location.toString());
        }
        if (this._station != Double.NEGATIVE_INFINITY) {
            RMAIO.fout(out, "Node Station=" + RMAIO.toString(this._station));
        }
        if (this._defaultStation) {
            RMAIO.fout(out, "Node defaultStation=true");
        } else {
            RMAIO.fout(out, "Node defaultStation=false");
        }
        if (this._streamCoord != Double.NEGATIVE_INFINITY) {
            RMAIO.fout(out, "Node Coord=" + RMAIO.toString(this._streamCoord));
        }
        RMAIO.fout(out, "Node End");
        RMAIO.fout(out, "");
        this.setModified(false);
        return true;
    }

    public void saveAsGml(Element root, Namespace gmlNs) {
        Element ppElem = new Element("pointProperty");
        ppElem.setNamespace(gmlNs);
        root.addContent((Content)ppElem);
        Element nodeElem = new Element("Node");
        nodeElem.setNamespace(gmlNs);
        nodeElem.setAttribute("id", "n" + this.getIndex(), gmlNs);
        ppElem.addContent((Content)nodeElem);
        Element streamNode = new Element("streamIdx");
        if (this._stream != null) {
            streamNode.setAttribute("href", "s" + this._stream.getIndex());
        }
        if (this._station != Double.NEGATIVE_INFINITY) {
            Element stationElem = new Element("Station");
            stationElem.setText(String.valueOf(this._station));
            nodeElem.addContent((Content)stationElem);
        }
        if (this._streamCoord != Double.NEGATIVE_INFINITY) {
            Element coordElem = new Element("Coord");
            coordElem.setText(String.valueOf(this._streamCoord));
            nodeElem.addContent((Content)coordElem);
        }
        if (this._location != null && this._location.isValid()) {
            Element locElem = new Element("Point", gmlNs);
            nodeElem.addContent((Content)locElem);
            Element posElem = new Element("pos", gmlNs);
            locElem.addContent((Content)posElem);
            locElem.setText(this._location.toString());
        }
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean loadId() {
        return true;
    }

    public void locked(LockEvent event) {
    }

    @Override
    public Object clone() {
        try {
            StreamNode copy = (StreamNode)super.clone();
            copy._stream = this._stream;
            copy._alignment = this._alignment;
            copy._location = new WorldPt(this._location);
            return copy;
        }
        catch (CloneNotSupportedException ce) {
            System.out.println("StreamNode.clone: clone not supported " + ce);
            return null;
        }
    }

    public boolean isUpstreamNode() {
        if (this._stream == null) {
            return false;
        }
        return this._stream.getUpstreamNode() == this;
    }

    public boolean isDownstreamNode() {
        if (this._stream == null) {
            return false;
        }
        return this._stream.getDownstreamNode() == this;
    }
}

