/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.map.WorldLine3d;
import hec.map.WorldPt;
import hec.model.StreamPt;
import java.util.Vector;
import rma.lang.Modifiable;

public class StreamPolyLine
extends WorldLine3d
implements Modifiable {
    public boolean _modified = false;

    @Override
    public WorldPt newPt() {
        return new StreamPt();
    }

    public void validate() {
        Vector<WorldPt> tmp = new Vector<WorldPt>(this.pts.size());
        for (int ii = 0; ii < this.pts.size(); ++ii) {
            WorldPt pt = (WorldPt)this.pts.get(ii);
            if (pt instanceof StreamPt) {
                tmp.add(pt);
                continue;
            }
            StreamPt streamPt = new StreamPt(pt);
            tmp.add(streamPt);
        }
        this.pts = tmp;
    }

    public StreamPolyLine getLineSegment(double c0, double c1) {
        StreamPolyLine newline = new StreamPolyLine();
        newline.pts.addElement(this.getLocationByCoord(c0));
        double length = this.getLength();
        double cumdist = 0.0;
        if (c0 < c1) {
            WorldPt spt0 = (WorldPt)this.pts.elementAt(0);
            for (int i = 1; i < this.pts.size(); ++i) {
                WorldPt spt = (WorldPt)this.pts.elementAt(i);
                double seglen = spt0.distToPoint(spt);
                if (c0 < (cumdist += seglen) / length && cumdist / length < c1 && (newline.pts.isEmpty() || !((WorldPt)newline.pts.lastElement()).equals(spt))) {
                    newline.pts.addElement(spt);
                }
                spt0 = spt;
            }
        } else {
            WorldPt spt0 = (WorldPt)this.pts.elementAt(this.pts.size() - 1);
            for (int i = this.pts.size() - 2; i >= 0; --i) {
                WorldPt spt = (WorldPt)this.pts.elementAt(i);
                double seglen = spt0.distToPoint(spt);
                if (c0 < (cumdist += seglen) / length && cumdist / length < c1 && (newline.pts.isEmpty() || !((WorldPt)newline.pts.lastElement()).equals(spt))) {
                    newline.pts.addElement(spt);
                }
                spt0 = spt;
            }
        }
        newline.pts.addElement(this.getLocationByCoord(c1));
        return newline;
    }

    @Override
    public void setLinePoint(double coord, WorldPt wpt) {
        super.setLinePoint(coord, wpt);
        this.setModified(true);
    }

    @Override
    public boolean removePt(WorldPt wpt, double tol) {
        boolean b = super.removePt(wpt, tol);
        if (b) {
            this.setModified(true);
        }
        return b;
    }

    @Override
    public boolean insertPt(WorldPt wpt, double tol) {
        boolean b = super.insertPt(wpt, tol);
        if (b) {
            this.setModified(true);
        }
        return b;
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
        if (b) {
            this.invalidate();
        }
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    public StreamPolyLine getFirstSegment() {
        if (this.pts.size() < 2) {
            return null;
        }
        double c1 = this.getCoordAtLocation((StreamPt)this.pts.get(0));
        double c2 = this.getCoordAtLocation((StreamPt)this.pts.get(1));
        return this.getLineSegment(c1, c2);
    }

    public StreamPolyLine getLastSegment() {
        if (this.pts.size() < 2) {
            return null;
        }
        double c1 = this.getCoordAtLocation((StreamPt)this.pts.get(this.pts.size() - 1));
        double c2 = this.getCoordAtLocation((StreamPt)this.pts.get(this.pts.size() - 2));
        return this.getLineSegment(c1, c2);
    }
}

