/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.io.AsciiSerializable;
import hec.model.StreamElement;
import hec.model.StreamReferenceHolder;
import java.lang.reflect.Field;

public class StreamSegment
implements AsciiSerializable,
StreamReferenceHolder {
    static final long serialVersionUID = -2196810193424927522L;
    public int streamIndex = Integer.MIN_VALUE;
    public double upstreamStation = Double.NEGATIVE_INFINITY;
    public double downstreamStation = Double.NEGATIVE_INFINITY;
    public double upstreamCoord = Double.NEGATIVE_INFINITY;
    public double downstreamCoord = Double.NEGATIVE_INFINITY;
    public String streamName;
    public transient StreamElement stream;
    public int numberOfSegments = Integer.MIN_VALUE;

    public StreamSegment() {
    }

    public StreamSegment(StreamElement elem) {
        this();
        this.setStream(elem);
    }

    public void setStream(StreamElement elem) {
        this.stream = elem;
        if (this.stream != null) {
            this.streamName = this.stream.getName();
            this.streamIndex = this.stream.getIndex();
        } else {
            this.streamName = null;
            this.streamIndex = Integer.MIN_VALUE;
        }
    }

    public boolean equals(StreamSegment s) {
        if (this.streamIndex != s.streamIndex) {
            return false;
        }
        if (this.upstreamStation != s.upstreamStation) {
            return false;
        }
        if (this.upstreamCoord != s.upstreamCoord) {
            return false;
        }
        if (this.downstreamStation != s.downstreamStation) {
            return false;
        }
        if (this.downstreamCoord != s.downstreamCoord) {
            return false;
        }
        return this.streamIndex == s.streamIndex;
    }

    public String toString() {
        return "StreamSegment: Stream Index=" + this.streamIndex + (String)(this.stream != null ? " Stream=" + this.stream.getName() : "") + (String)(this.upstreamStation != Double.NEGATIVE_INFINITY ? " UpStation=" + this.upstreamStation : "") + (String)(this.downstreamStation != Double.NEGATIVE_INFINITY ? " DownStation=" + this.downstreamStation : "") + (String)(this.upstreamCoord != Double.NEGATIVE_INFINITY ? " UpCoord=" + this.upstreamCoord : "") + (String)(this.downstreamCoord != Double.NEGATIVE_INFINITY ? " DownCoord=" + this.downstreamCoord : "") + (String)(this.numberOfSegments != Integer.MIN_VALUE ? " Segments=" + this.numberOfSegments : "");
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public int getStreamIndex() {
        return this.streamIndex;
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public void setStreamIndex(int idx) {
        this.streamIndex = idx;
    }

    @Override
    public void setStreamName(String name) {
        this.streamName = name;
    }
}

