/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.io.AsciiSerializable;
import hec.model.StreamReferenceHolder;
import java.lang.reflect.Field;

public class StreamSegmentIdentifier
implements AsciiSerializable,
StreamReferenceHolder {
    static final long serialVersionUID = -3391002080439948525L;
    public String streamName;
    public int streamId = Integer.MIN_VALUE;
    public double startStation = Double.NEGATIVE_INFINITY;
    public double endStation = Double.NEGATIVE_INFINITY;
    private double startElevation = Double.NEGATIVE_INFINITY;
    private double endElevation = Double.NEGATIVE_INFINITY;

    public StreamSegmentIdentifier() {
    }

    public StreamSegmentIdentifier(String sName, int id, double sStation, double eStation) {
        this.streamId = id;
        this.streamName = sName;
        if (sStation > eStation) {
            this.startStation = eStation;
            this.endStation = sStation;
        } else {
            this.startStation = sStation;
            this.endStation = eStation;
        }
    }

    public boolean isValid() {
        return this.streamId != Integer.MIN_VALUE && this.startStation != Double.NEGATIVE_INFINITY && this.endStation != Double.NEGATIVE_INFINITY;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public int getStreamIndex() {
        return this.streamId;
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public void setStreamIndex(int idx) {
        this.streamId = idx;
    }

    @Override
    public void setStreamName(String name) {
        this.streamName = name;
    }

    public double getEndElevation() {
        return this.endElevation;
    }

    public void setEndElevation(double endElevation) {
        this.endElevation = endElevation;
    }

    public double getStartElevation() {
        return this.startElevation;
    }

    public void setStartElevation(double startElevation) {
        this.startElevation = startElevation;
    }
}

