/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.heclib.dss.DSSPathAndFilename;
import hec.heclib.util.HecDouble;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TsDataSetName
extends DSSPathAndFilename
implements Cloneable,
Serializable {
    protected boolean _fromOracle = false;
    protected boolean _set = false;
    protected String _oracleName = "";
    public Vector layers = new Vector();
    public Vector modules = new Vector();
    public Vector iconTypes = new Vector();
    public String thresholdColors = null;
    public String cumulativeThresholdColors = null;
    public String thresholdName = null;
    public String cumulativeThresholdName = null;
    protected String _displayName;
    protected String _location;
    protected String _parameter;
    protected String _version;
    protected HecDouble _thumbnailMin = new HecDouble();
    protected HecDouble _thumbnailMax = new HecDouble();

    public TsDataSetName() {
        this._set = false;
        this._displayName = "";
    }

    public TsDataSetName(String name) {
        boolean fromOracle = name.indexOf("/") == -1;
        this.init(fromOracle, name);
    }

    public TsDataSetName(boolean oracle, String name) {
        this.init(oracle, name);
    }

    protected void init(boolean oracle, String name) {
        this._fromOracle = oracle;
        this._set = true;
        super.setPathname(name);
        if (oracle) {
            this._oracleName = name;
            this._location = this.aPart();
            this._parameter = this.bPart();
        } else {
            this._oracleName = "";
            this._location = this.bPart();
            this._parameter = this.cPart();
        }
        this._version = this.fPart();
        this._displayName = name;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getLocation() {
        return this._location;
    }

    public String getParameter() {
        return this._parameter;
    }

    public String getVersion() {
        return this._version;
    }

    @Override
    public Object clone() {
        TsDataSetName clonedDataSet = new TsDataSetName(this._fromOracle, this.dataSetName());
        clonedDataSet.layers = (Vector)this.layers.clone();
        clonedDataSet.modules = (Vector)this.modules.clone();
        clonedDataSet.iconTypes = (Vector)this.iconTypes.clone();
        clonedDataSet.thresholdColors = this.thresholdColors;
        clonedDataSet.cumulativeThresholdColors = this.cumulativeThresholdColors;
        clonedDataSet.thresholdName = this.thresholdName;
        clonedDataSet.cumulativeThresholdName = this.cumulativeThresholdName;
        clonedDataSet._thumbnailMin.set(this._thumbnailMin);
        clonedDataSet._thumbnailMax.set(this._thumbnailMax);
        return clonedDataSet;
    }

    public boolean fromOracle() {
        return this._fromOracle;
    }

    public void setFromOracle(boolean fromOracle) {
        this._fromOracle = fromOracle;
    }

    public String oracleName() {
        return this._oracleName;
    }

    public String name() {
        if (this._fromOracle) {
            return this._oracleName;
        }
        return this.pathname();
    }

    public String dataSetName() {
        if (this._fromOracle) {
            return this._oracleName;
        }
        return this.combinedPathAndFilename();
    }

    @Override
    public boolean hasBeenSet() {
        return this._set;
    }

    @Override
    public int setPathname(String path) {
        this.init(false, path);
        return 0;
    }

    public void setOracleName(String name) {
        this.init(true, name);
    }

    public void set(boolean set) {
        if (set) {
            this._set = true;
        } else {
            this._set = false;
            this._oracleName = "";
            this._fromOracle = false;
        }
    }

    public boolean isActive(Vector activeLayers) {
        for (int i = 0; i < this.layers.size(); ++i) {
            String layerName = (String)this.layers.elementAt(i);
            if (!activeLayers.contains(layerName)) continue;
            return true;
        }
        return false;
    }

    public void addLayer(String layerName) {
        if (!this.layers.contains(layerName)) {
            this.layers.addElement(layerName);
        }
    }

    public void setLayers(Vector layerNames) {
        this.layers = layerNames;
    }

    public Vector getLayers() {
        return this.layers;
    }

    public void addModule(String moduleName, Integer type) {
        if (!this.modules.contains(moduleName)) {
            this.modules.addElement(moduleName);
            this.iconTypes.addElement(type);
        }
    }

    public void setModules(Vector moduleNames) {
        this.modules = moduleNames;
        if (this.modules.size() != this.iconTypes.size()) {
            this.iconTypes.removeAllElements();
            for (int i = 0; i < this.modules.size(); ++i) {
                this.iconTypes.add(new Integer(0));
            }
        }
    }

    public int getIconType(String moduleName) {
        int index = this.modules.indexOf(moduleName);
        if (index == -1) {
            return -1;
        }
        Integer type = (Integer)this.iconTypes.elementAt(index);
        return type;
    }

    public String getLocationName() {
        if (this.fromOracle()) {
            int period = this._oracleName.indexOf(".");
            if (period > 0) {
                return this._oracleName.substring(0, period);
            }
            return "";
        }
        return this.bPart();
    }

    public void setLocationName(String name) {
        if (this.fromOracle()) {
            int period = this._oracleName.indexOf(".");
            if (period > -1) {
                String newName = name + this._oracleName.substring(period);
                this._oracleName = newName;
            }
        } else {
            this.setBPart(name);
        }
    }

    public void setThumbnailMinMax(HecDouble min, HecDouble max) {
        this._thumbnailMin.set(min);
        this._thumbnailMax.set(max);
    }

    public void getThumbnailMinMax(HecDouble min, HecDouble max) {
        min.set(this._thumbnailMin);
        max.set(this._thumbnailMax);
    }

    public void setThumbnailScale(String vals) {
        String[] s = vals.split(",");
        if (s.length > 0) {
            if (s[0].startsWith("u")) {
                this._thumbnailMin.setUndefined();
            } else {
                this._thumbnailMin.set(s[0]);
            }
        }
        if (s.length > 1) {
            if (s[1].startsWith("u")) {
                this._thumbnailMax.setUndefined();
            } else {
                this._thumbnailMax.set(s[1]);
            }
        }
    }

    public void setThresholdColors(String colors) {
        this.thresholdColors = colors;
    }

    public void setCumulativeThresholdColors(String colors) {
        this.cumulativeThresholdColors = colors;
    }

    public void setThresholdName(String name) {
        this.thresholdName = name;
    }

    public void setCumulativeThresholdName(String name) {
        this.cumulativeThresholdName = name;
    }

    public void setThresholdColorInfo(Hashtable<String, String> colors, boolean cumulative) {
        if (cumulative && this.cumulativeThresholdColors != null) {
            return;
        }
        if (!cumulative && this.thresholdColors != null) {
            return;
        }
        if (cumulative) {
            this.setCumColors(colors);
        } else {
            this.setThreshColors(colors);
        }
    }

    protected void setThreshColors(Hashtable<String, String> thresholdColorHash) {
        if (this.thresholdName != null) {
            String colors = thresholdColorHash.get(this.thresholdName);
            if (colors != null && colors.length() > 0) {
                this.setThresholdColors(colors);
            }
        } else {
            Enumeration<String> keys = thresholdColorHash.keys();
            while (keys.hasMoreElements()) {
                String name = keys.nextElement();
                String colors = thresholdColorHash.get(name);
                if (!name.startsWith("p=")) continue;
                String param = name.substring(2, name.length());
                if (this._fromOracle) {
                    if (this._oracleName.indexOf("." + param + ".") <= -1) continue;
                    this.setThresholdColors(colors);
                    this.thresholdName = name;
                    return;
                }
                if (!param.toUpperCase().equals(this.cPart())) continue;
                this.setThresholdColors(colors);
                this.thresholdName = name;
                return;
            }
            String colors = thresholdColorHash.get("default");
            if (colors != null) {
                this.thresholdColors = colors;
                this.thresholdName = "default";
            }
        }
    }

    protected void setCumColors(Hashtable<String, String> cumColors) {
        if (this.cumulativeThresholdName != null) {
            String colors = cumColors.get(this.cumulativeThresholdName);
            if (colors != null && colors.length() > 0) {
                this.setCumulativeThresholdColors(colors);
            }
        } else {
            Enumeration<String> keys = cumColors.keys();
            while (keys.hasMoreElements()) {
                String name = keys.nextElement();
                String colors = cumColors.get(name);
                if (!name.startsWith("p=")) continue;
                String param = name.substring(2, name.length());
                if (this._fromOracle) {
                    if (this._oracleName.indexOf("." + param + ".") <= -1) continue;
                    this.setCumulativeThresholdColors(colors);
                    return;
                }
                if (!param.toUpperCase().equals(this.cPart())) continue;
                this.setCumulativeThresholdColors(colors);
                return;
            }
            String colors = cumColors.get("default");
            if (colors != null) {
                this.setCumulativeThresholdColors(colors);
            }
        }
    }
}

