/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.lang.NamedType;
import hec.model.UserLoginInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class UserInfo
extends NamedType {
    public static final String ID_SEPARATOR = "-";
    Vector<UserLoginInfo> _users = new Vector();
    transient int cnt = 0;
    transient String[] _userList;
    private String _hostId = "";

    public UserInfo(String hostId) {
        if (hostId != null) {
            this._hostId = hostId;
        }
    }

    public String addUser(String userName, String app, long edipi, String clientHost) {
        ++this.cnt;
        String userId = new String(userName + ID_SEPARATOR + this._hostId + "$" + this.cnt);
        for (int i = 0; i < this._users.size(); ++i) {
            if (!this._users.elementAt(i).getUserId().equals(userId)) continue;
            ++this.cnt;
            userId = new String(userName + ID_SEPARATOR + this.cnt);
            i = -1;
        }
        UserLoginInfo u = new UserLoginInfo(userName, userId, edipi, clientHost);
        u.setLoginTime();
        u.setLastCheckInTime();
        u.setApplication(app);
        this._users.addElement(u);
        return userId;
    }

    public boolean removeUser(String userId) {
        for (int i = 0; i < this._users.size(); ++i) {
            UserLoginInfo elementAt = this._users.elementAt(i);
            if (!elementAt.getUserId().equals(userId)) continue;
            this._users.removeElementAt(i);
            return true;
        }
        return false;
    }

    public String findUserName(String userId) {
        for (int i = 0; i < this._users.size(); ++i) {
            UserLoginInfo elementAt = this._users.elementAt(i);
            if (!elementAt.getUserId().equals(userId)) continue;
            return elementAt.getUserName();
        }
        return null;
    }

    public String[] findUserIds(String userName) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this._users.size(); ++i) {
            UserLoginInfo uli = this._users.get(i);
            if (!uli.getUserName().equals(userName)) continue;
            v.add(uli.getUserId());
        }
        Object[] userIds = new String[v.size()];
        v.copyInto(userIds);
        return userIds;
    }

    public boolean setKeyForUser(String userId, long key) {
        for (int i = 0; i < this._users.size(); ++i) {
            UserLoginInfo info = this._users.elementAt(i);
            if (!info.getUserId().equals(userId)) continue;
            info.setKey(key);
            return true;
        }
        return false;
    }

    public boolean isLoggedIn(String userId) {
        int minutes = Integer.getInteger("LoginServer.UserALiveMinutes", 2);
        for (int i = 0; i < this._users.size(); ++i) {
            long lastCheckIn;
            long currTime;
            UserLoginInfo info = this._users.get(i);
            if (!info.getUserId().equals(userId) || (currTime = System.currentTimeMillis()) - (lastCheckIn = info.getLastCheckInTime()) >= (long)(minutes * 60 * 1000)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "UserInfo";
    }

    public String[] getLoggedInUsers() {
        this._userList = new String[this._users.size()];
        for (int i = 0; i < this._users.size(); ++i) {
            this._userList[i] = this._users.elementAt(i).getUserId();
        }
        return this._userList;
    }

    public Vector<UserLoginInfo> getUserList() {
        return this._users;
    }

    public int size() {
        return this._users.size();
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public List getClientsForUser(String userName) {
        ArrayList<UserLoginInfo> clients = new ArrayList<UserLoginInfo>();
        for (int i = 0; i < this._users.size(); ++i) {
            UserLoginInfo info = this._users.get(i);
            if (!info.getUserName().equals(userName)) continue;
            clients.add(info);
        }
        return clients;
    }

    public UserLoginInfo getUserLoginInfo(String userId) {
        UserLoginInfo retval = null;
        for (int i = 0; i < this._users.size(); ++i) {
            UserLoginInfo info = this._users.get(i);
            if (!info.getUserId().equals(userId)) continue;
            retval = info;
            break;
        }
        return retval;
    }
}

