/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import java.io.Serializable;

public class ValueSet
implements Serializable,
Cloneable {
    public double xval = Double.NEGATIVE_INFINITY;
    public double[] yval = null;

    public ValueSet() {
    }

    public ValueSet(double x, double y) {
        this.xval = x;
        this.yval = new double[1];
        this.yval[0] = y;
    }

    public ValueSet(double x, double[] y) {
        this.xval = x;
        if (y != null) {
            this.yval = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                this.yval[i] = y[i];
            }
        } else {
            this.yval = null;
        }
    }

    public ValueSet(int numy) {
        this.yval = new double[numy];
        for (int i = 0; i < numy; ++i) {
            this.yval[i] = Double.NEGATIVE_INFINITY;
        }
    }

    public void insertValue(int index) {
        this.insertValue(index, Double.NEGATIVE_INFINITY);
    }

    public void insertValue(int index, double value) {
        int size = this.yval != null ? this.yval.length : 0;
        int newSize = size + 1;
        if (index < 0) {
            return;
        }
        if (index >= size + 1) {
            return;
        }
        this.ensureCapacity(newSize);
        System.arraycopy(this.yval, index, this.yval, index + 1, size - index);
        this.yval[index] = value;
    }

    public void removeValue(int index) {
        if (this.yval == null) {
            return;
        }
        int elementCount = this.yval.length;
        if (index >= elementCount) {
            return;
        }
        if (index < 0) {
            return;
        }
        int j = elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.yval, index + 1, this.yval, index, j);
        }
        double[] yvalTemp = this.yval;
        this.yval = new double[--elementCount];
        System.arraycopy(yvalTemp, 0, this.yval, 0, elementCount);
    }

    public void ensureCapacity(int minCapacity) {
        if (this.yval == null) {
            this.yval = new double[minCapacity];
            return;
        }
        int oldCapacity = this.yval.length;
        if (minCapacity > oldCapacity) {
            double[] yvalTemp = this.yval;
            this.yval = new double[minCapacity];
            System.arraycopy(yvalTemp, 0, this.yval, 0, oldCapacity);
        }
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        try {
            ValueSet vs = (ValueSet)super.clone();
            return vs;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

