/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import java.util.BitSet;
import java.util.Vector;

public class WarningTreeNode
implements Cloneable {
    String name = new String();
    String message = new String();
    Vector childNodes = new Vector();
    BitSet valid = new BitSet(3);

    public WarningTreeNode() {
        this.valid.clear(2);
        this.valid.clear(1);
        this.valid.clear(0);
    }

    public Object clone() throws CloneNotSupportedException {
        WarningTreeNode wtn = (WarningTreeNode)super.clone();
        wtn.name = this.name;
        wtn.message = this.message;
        wtn.childNodes = (Vector)this.childNodes.clone();
        return wtn;
    }

    public void setName(String str) {
        if (str == null) {
            return;
        }
        this.name = str;
    }

    public void setMessage(String msg) {
        if (msg == null) {
            return;
        }
        this.message = msg;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public void addNode(WarningTreeNode wtn) {
        if (wtn == null) {
            return;
        }
        if (!wtn.isValid()) {
            this.setInValid();
        }
        this.childNodes.addElement(wtn);
    }

    public boolean isValid() {
        return this.valid.get(2);
    }

    public void setValidBits(BitSet bs) {
        this.valid = bs;
    }

    public void setValid() {
        this.valid.clear(0);
        this.valid.clear(1);
        this.valid.set(2);
    }

    public void setInValid() {
        this.valid.clear(2);
        this.valid.clear(1);
        this.valid.set(0);
    }

    public void printout() {
        System.out.println("Node->" + this.name + " Message->" + this.message);
        for (int i = 0; i < this.childNodes.size(); ++i) {
            WarningTreeNode wtn = (WarningTreeNode)this.childNodes.elementAt(i);
            wtn.printout();
        }
    }

    public static WarningTreeNode generateNewValidNode(String name) {
        WarningTreeNode wtn = new WarningTreeNode();
        wtn.setValid();
        wtn.setName(name);
        wtn.setMessage("Valid");
        return wtn;
    }
}

