/*
 * Decompiled with CFR 0.152.
 */
package hec.properties;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import rma.util.RMAIO;

public abstract class HECProperties
extends Properties
implements Serializable {
    protected Properties properties = this.createProperties(new Properties());
    private File _file;
    private String _header = "HEC Properties";
    protected boolean _loaded;
    private boolean _modified;
    public static final String PROPERTIES_PATH = "properties.path";
    public static final String DEFAULT_LOG_DIRECTORY = "dated/logs";

    public HECProperties() {
    }

    public HECProperties(String filename) {
        this();
        filename = RMAIO.getPropertyFilePath(filename);
        this._file = new File(filename);
        File parent = this._file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        if (this._file.isFile()) {
            this.loadProperties();
        } else {
            this.saveProperties();
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public boolean isModified() {
        return this._modified;
    }

    public void setModified(boolean b) {
        this._modified = b;
    }

    public String getProp(String key) {
        return this.properties.getProperty(key);
    }

    public String getProp(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public abstract Properties createProperties(Properties var1);

    public void loadProperties() {
        try {
            this.properties.load(new BufferedInputStream(new FileInputStream(this._file)));
            this._loaded = true;
        }
        catch (IOException ioe) {
            System.out.println("Properties file " + this._file.toString() + " not found");
            System.out.println("using default properties");
        }
    }

    public void saveProperties() {
        try {
            FileOutputStream fos = new FileOutputStream(this._file);
            this.properties.save(fos, this.getHeader());
            fos.close();
        }
        catch (IOException ioe) {
            System.out.println("Properties file " + this._file.toString() + " not found");
            System.out.println("using default properties");
        }
    }

    public String getHeader() {
        return this._header;
    }

    public void setHeader(String header) {
        this._header = header;
    }

    public Enumeration getKeys() {
        return this.properties.keys();
    }

    public int getSize() {
        return this.properties.size();
    }

    public void listProperties() {
        Enumeration<Object> enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            System.out.println(key + " value is " + this.properties.getProperty(key));
        }
    }

    public String deleteProp(String key) {
        if (key == null) {
            return null;
        }
        return (String)this.properties.remove(key);
    }

    public void setProp(String key, String value) {
        this.properties.put(key, value);
        this.saveProperties();
    }

    public void clearProperties() {
        this.properties.clear();
        this._modified = true;
    }
}

