/*
 * Decompiled with CFR 0.152.
 */
package hec.refresh;

import hec.refresh.RefreshEvent;
import hec.refresh.RefreshListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public abstract class RefreshManager {
    Map<Object, Collection<RefreshListener>> mRefreshListeners = new HashMap<Object, Collection<RefreshListener>>();
    private static RefreshManager REFRESH_MANAGER = null;

    private RefreshManager() {
    }

    public static RefreshManager getDefault() {
        if (REFRESH_MANAGER != null) {
            return REFRESH_MANAGER;
        }
        ServiceLoader<RefreshManager> services = ServiceLoader.load(RefreshManager.class);
        Iterator<RefreshManager> iterator = services.iterator();
        if (iterator.hasNext()) {
            REFRESH_MANAGER = iterator.next();
        }
        if (REFRESH_MANAGER == null) {
            REFRESH_MANAGER = new DefaultRefreshManager();
        }
        return REFRESH_MANAGER;
    }

    public void addRefreshListener(Object eventType, RefreshListener listener) {
        Collection<RefreshListener> listeners = this.mRefreshListeners.get(eventType);
        if (listeners == null) {
            listeners = new ArrayList<RefreshListener>();
        }
        if (listener != null && !listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public void removeRefreshListener(Object eventType, RefreshListener listener) {
        Collection<RefreshListener> listeners = this.mRefreshListeners.get(eventType);
        if (listeners == null) {
            return;
        }
        if (listener != null) {
            listeners.remove(listener);
        }
    }

    public abstract void fireRefreshEvent(Object var1, Object var2, String var3);

    private static class DefaultRefreshManager
    extends RefreshManager {
        @Override
        public void fireRefreshEvent(Object src, Object eventType, String msg) {
            Collection listeners = (Collection)this.mRefreshListeners.get(eventType);
            if (listeners == null) {
                return;
            }
            RefreshEvent event = new RefreshEvent(src, msg);
            for (RefreshListener refreshListener : listeners) {
                refreshListener.refresh(event);
            }
        }
    }
}

