/*
 * Decompiled with CFR 0.152.
 */
package hec.script;

import hec.event.ConfigChangeListener;
import hec.event.ConfigFileChangeEvent;
import hec.event.ScriptEvent;
import hec.event.ScriptEventListener;
import hec.gui.MoverDialog;
import hec.lang.ClientAppCheck;
import hec.script.Script;
import hec.script.ScriptConstants;
import hec.script.ScriptEngine;
import hec.script.ScriptIdentifier;
import hec.script.ScriptJButton;
import hec.script.ScriptManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.ScriptingLoggingMarker;

public abstract class AbstractScriptButtonFrame
extends RmaJFrame
implements ScriptConstants,
ConfigChangeListener,
ScriptEventListener {
    private static final MarkingClassLogger SCRIPTING_LOGGER = MarkingClassLogger.forMarkingClass(ScriptingLoggingMarker.class);
    JPanel buttonPanel;
    int cnt = 1;
    ActionListener _buttonAl;
    MouseListener _buttonMl;
    int _maxButtonsPerColumn;
    protected JButton _activeButton;
    boolean fComponentsAdjusted = false;
    private String _groupName;

    public AbstractScriptButtonFrame(Frame parent) {
        this(parent, null);
    }

    public AbstractScriptButtonFrame(Frame parent, String groupName) {
        int iy;
        JScrollBar vsb;
        this._groupName = groupName;
        this._maxButtonsPerColumn = RMAIO.parseInt(System.getProperty("scriptFrame.buttonsPerColumn", "10"), 10);
        ((MarkingClassLogger.Api)SCRIPTING_LOGGER.atFine()).log("buttons per column is %s", this._maxButtonsPerColumn);
        this.setTitle("Available Scripts " + (String)(this._groupName != null ? "-" + this._groupName : ""));
        this.setSize(300, 300);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Color.blue);
        this.buildMenus();
        this.buttonPanel = new JPanel(new GridBagLayout());
        JScrollPane sp = new JScrollPane(this.buttonPanel);
        JScrollBar hsb = sp.getHorizontalScrollBar();
        if (hsb != null) {
            hsb.setUnitIncrement(10);
        }
        if ((vsb = sp.getVerticalScrollBar()) != null) {
            vsb.setUnitIncrement(10);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.ipadx = 290;
        gbc.ipady = 290;
        gbc.insets = RmaInsets.insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)sp, gbc);
        Rectangle bounds = parent.getBounds();
        Rectangle abounds = this.getBounds();
        int ix = bounds.x + (bounds.width - abounds.width - 10);
        if (ix < 10) {
            ix = 10;
        }
        if ((iy = bounds.y + (bounds.height - abounds.height - 10)) < 10) {
            iy = 10;
        }
        this.setLocation(ix, iy);
        this._buttonAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (!(obj instanceof ScriptJButton)) {
                    return;
                }
                ScriptIdentifier id = ((ScriptJButton)obj).getScriptIdentifier();
                if (id == null) {
                    System.out.println("sb:Null ScriptIdentifier for button labeled " + ((ScriptJButton)obj).getText());
                    return;
                }
                AbstractScriptButtonFrame.this.runScript(id);
            }
        };
        this._buttonMl = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    JMenuItem item;
                    Component c2 = e.getComponent();
                    if (!(c2 instanceof JButton)) {
                        return;
                    }
                    JButton button = (JButton)c2;
                    AbstractScriptButtonFrame.this.getRootPane().setDefaultButton(button);
                    AbstractScriptButtonFrame.this.setActiveButton(button);
                    button.requestFocusInWindow();
                    JPopupMenu menu = new JPopupMenu();
                    if (ClientAppCheck.haveClientApp()) {
                        item = new JMenuItem("Edit");
                        menu.add(item);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                AbstractScriptButtonFrame.this.editScript();
                            }
                        });
                        item = new JMenuItem("Delete");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                AbstractScriptButtonFrame.this.deleteScripts();
                            }
                        });
                        menu.add(item);
                        menu.addSeparator();
                        item = new JMenuItem("Schedule Script Job...");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                AbstractScriptButtonFrame.this.scheduleJob(true);
                            }
                        });
                        menu.add(item);
                    }
                    if (((MarkingClassLogger.Api)SCRIPTING_LOGGER.atInfo()).isEnabled()) {
                        item = new JMenuItem("Info");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                AbstractScriptButtonFrame.this.scriptInfo();
                            }
                        });
                        menu.add(item);
                    }
                    if (menu.getComponentCount() > 0) {
                        menu.show(button, e.getX(), e.getY());
                    }
                }
            }
        };
    }

    protected boolean runScript(ScriptIdentifier id) {
        Script s = this.getScriptManager().getScript(id);
        if (s == null) {
            return false;
        }
        int rv = ScriptEngine.engine().execute(s, id.getUserDisplayedName(), id.getName());
        return rv == 0;
    }

    private void buildMenus() {
        JMenuItem menuItem;
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Script");
        menu.setMnemonic('s');
        if (ClientAppCheck.haveClientApp()) {
            menuItem = new JMenuItem("Script Editor...", 69);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2, false));
            menu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractScriptButtonFrame.this.newScript();
                }
            });
            menuItem = new JMenuItem("Delete", 100);
            menuItem.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
            menu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractScriptButtonFrame.this.deleteScripts();
                }
            });
            menuItem = new JMenuItem("Add to Panel...");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractScriptButtonFrame.this.addScriptMenu();
                }
            });
            menu.add(menuItem);
            menu.addSeparator();
            menuItem = new JMenuItem("Schedule Script Job...", 106);
            menu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractScriptButtonFrame.this.scheduleJob(false);
                }
            });
            menuItem = new JMenuItem("Status...", 115);
            menu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractScriptButtonFrame.this.jobStatus();
                }
            });
            menu.addSeparator();
        }
        menuItem = new JMenuItem("Close", 99);
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptButtonFrame.this.closeFrame();
            }
        });
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    protected abstract void newScript();

    protected void addScriptMenu() {
    }

    private void deleteScripts() {
        int i;
        Component[] comps = this.buttonPanel.getComponents();
        ArrayList<ScriptIdentifier> ids = new ArrayList<ScriptIdentifier>(comps.length);
        for (int i2 = 0; i2 < comps.length; ++i2) {
            if (!(comps[i2] instanceof ScriptJButton)) continue;
            ids.add(((ScriptJButton)comps[i2]).getScriptIdentifier());
        }
        if (ids.size() == 0) {
            return;
        }
        MoverDialog mover = new MoverDialog((Frame)this, true);
        mover.setTitle("Select Scripts to Delete");
        mover.setDescVisible(false);
        mover.setData(ids, new ArrayList(0));
        mover.setVisible(true);
        if (mover.isCanceled()) {
            return;
        }
        Object[] selectedIds = mover.getSelectedObjects();
        if (selectedIds == null || selectedIds.length == 0) {
            return;
        }
        ArrayList<Component> deletedButtons = new ArrayList<Component>();
        Object msg = "The following scripts will be deleted:\n";
        for (int i3 = 0; i3 < selectedIds.length; ++i3) {
            msg = (String)msg + selectedIds[i3].toString();
            msg = (String)msg + "\n";
        }
        int opt = JOptionPane.showConfirmDialog(this, msg, "Confirm Delete", 0);
        if (opt != 0) {
            return;
        }
        block2: for (i = 0; i < selectedIds.length; ++i) {
            ScriptIdentifier id = (ScriptIdentifier)selectedIds[i];
            this.getScriptManager().deleteScript(id);
            for (int j = 0; j < comps.length; ++j) {
                if (!(comps[i] instanceof ScriptJButton) || !((ScriptJButton)comps[j]).getScriptIdentifier().equals(id)) continue;
                deletedButtons.add(comps[j]);
                continue block2;
            }
        }
        for (i = 0; i < deletedButtons.size(); ++i) {
            this.buttonPanel.remove((Component)deletedButtons.get(i));
        }
        this.buttonPanel.revalidate();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private void deleteScript() {
        ScriptJButton button = (ScriptJButton)this.getActiveButton();
        if (button == null && (button = (ScriptJButton)this.getRootPane().getDefaultButton()) == null) {
            System.out.println("deleteScript: no script button selected");
            return;
        }
        int ok = JOptionPane.showConfirmDialog(this, "Ok to delete button " + button.getText());
        if (ok == 0) {
            ScriptManager sm = this.getScriptManager();
            if (sm.deleteScript(button.getScriptIdentifier())) {
                this.buttonPanel.remove(button);
                this.buttonPanel.revalidate();
                this.invalidate();
                this.validate();
                this.repaint();
            }
        } else {
            this.buttonPanel.repaint();
        }
    }

    protected abstract void editScript();

    private void closeFrame() {
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.updateScriptButtons();
            this.getScriptManager().addConfigChangeListener(this);
        } else {
            this.getScriptManager().removeConfigChangeListener(this);
        }
        super.setVisible(b);
    }

    public void updateScriptButtons() {
        int size;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.buttonPanel.removeAll();
        this.buttonPanel.revalidate();
        String s = this.getScriptableName();
        this.setTitle(s + (String)(this._groupName != null ? " " + this._groupName : "") + " Scripts ");
        Vector v = this.getScriptManager().getScriptIdsForMode(s);
        if (v == null || (size = v.size()) < 1) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        int row = 0;
        int col = 0;
        Insets insets = RmaInsets.insets(5, 5, 0, 0);
        for (int i = 0; i < size; ++i) {
            ScriptIdentifier sid;
            if (v.elementAt(i) == null || !(sid = (ScriptIdentifier)v.elementAt(i)).isDisplayedInSelector() || (this._groupName != null && !this._groupName.isEmpty() ? !this._groupName.equals(sid.getGroupName()) : sid.getGroupName() != null)) continue;
            ScriptJButton button = new ScriptJButton(sid);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = col;
            gbc.gridy = -1;
            ++row;
            gbc.insets = insets;
            gbc.anchor = 10;
            gbc.fill = 2;
            gbc.weighty = 1.0;
            if (i == size - 1) {
                gbc.weighty = 1.0;
            }
            this.buttonPanel.add((Component)button, gbc);
            button.addActionListener(this._buttonAl);
            button.addMouseListener(this._buttonMl);
            if (row < this._maxButtonsPerColumn) continue;
            ++col;
            row = 0;
        }
        this.buttonPanel.revalidate();
        this.setCursor(Cursor.getDefaultCursor());
        this.invalidate();
        this.validate();
        this.repaint();
    }

    protected abstract String getScriptableName();

    protected abstract ScriptManager getScriptManager();

    protected String getGroupName() {
        return this._groupName;
    }

    @Override
    public void configFileChanged(ConfigFileChangeEvent event) {
        if (event.getChangeType() == 1) {
            this.updateScriptButtons();
        }
    }

    protected void scriptInfo() {
        ScriptJButton button = (ScriptJButton)this.getRootPane().getDefaultButton();
        if (button == null) {
            return;
        }
        ScriptIdentifier sid = button.getScriptIdentifier();
        if (sid == null) {
            return;
        }
        System.out.println("Info for button for " + sid.getUserDisplayedName());
        System.out.println("\tname=" + sid.getName());
        System.out.println("\tDescription=" + sid.getDescription());
        System.out.println("\tscriptID=" + sid.getScriptId());
        System.out.println("\tfileName=" + sid.getFileName());
        System.out.println("\tfileName overridden=" + sid.getFileNameOverridden());
        System.out.println("\tmodulePath=" + sid.getModulePath());
    }

    public void scheduleJob(boolean fromButton) {
        JButton button;
        if (fromButton && (button = this.getRootPane().getDefaultButton()) != null) {
            ScriptJButton sb = (ScriptJButton)button;
            ScriptIdentifier scriptIdentifier = sb.getScriptIdentifier();
        }
        this.repaint();
    }

    public void jobStatus() {
        this.repaint();
    }

    protected abstract boolean isNetworked();

    @Override
    public void scriptEventPerformed(ScriptEvent se) {
        ScriptIdentifier sid = se.getScriptIdentifier();
        this.updateScriptButtons();
    }

    public void setActiveButton(JButton button) {
        this._activeButton = button;
    }

    public JButton getActiveButton() {
        return this._activeButton;
    }
}

