/*
 * Decompiled with CFR 0.152.
 */
package hec.script;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class LineNumberPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
DocumentListener,
PropertyChangeListener {
    private static final int MARGIN_WIDTH = 20;
    private static final int INSET_WIDTH = 2;
    private JTextArea editorPane;
    private boolean lineNumbersEnabled = true;
    private int lineCount;

    public LineNumberPanel(JTextArea editorpane) throws IllegalStateException {
        this.editorPane = editorpane;
        this.setAutoscrolls(true);
        this.setFont(editorpane.getFont());
        Caret caret = editorpane.getCaret();
        if (!(caret instanceof DefaultCaret)) {
            throw new IllegalStateException("editorPane's caret is not a DefaultCaret");
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.lineCount = editorpane.getLineCount() + 1;
        editorpane.addPropertyChangeListener(this);
        editorpane.getDocument().addDocumentListener(this);
    }

    @Override
    public void changedUpdate(DocumentEvent documentevent) {
        this.docChanged();
    }

    private void docChanged() {
        int i = this.editorPane.getLineCount() + 1;
        if (i != this.lineCount) {
            this.lineCount = i;
            this.repaint();
        }
    }

    private DefaultCaret getCaret() {
        Caret caret = this.editorPane.getCaret();
        return caret instanceof DefaultCaret ? (DefaultCaret)caret : null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getPreferredWidth(), this.editorPane.getHeight());
    }

    public int getPreferredWidth() {
        Font font = this.getFont();
        FontMetrics fontmetrics = this.getFontMetrics(font);
        int i = this.getHeight();
        int i_0_ = i / fontmetrics.getHeight();
        int width = Math.max(fontmetrics.stringWidth(Integer.toString(i_0_)), fontmetrics.stringWidth("000")) + 4;
        return width;
    }

    @Override
    public void insertUpdate(DocumentEvent documentevent) {
        this.docChanged();
    }

    @Override
    public void mouseClicked(MouseEvent mouseevent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseevent) {
        if (SwingUtilities.isLeftMouseButton(mouseevent)) {
            this.select(mouseevent.getPoint(), true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseevent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseevent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseevent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseevent) {
        if (SwingUtilities.isLeftMouseButton(mouseevent)) {
            if ((mouseevent.getModifiers() & 2) != 0) {
                this.editorPane.selectAll();
            } else {
                this.select(mouseevent.getPoint(), (mouseevent.getModifiers() & 1) != 0);
            }
            if (this.editorPane.isEnabled()) {
                this.editorPane.requestFocus();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseevent) {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Font font = this.getFont();
        FontMetrics fontmetrics = this.getFontMetrics(font);
        int i = fontmetrics.getHeight();
        Rectangle rectangle = graphics.getClipBounds();
        int i_1_ = rectangle.y / i;
        int i_2_ = fontmetrics.getAscent() + i_1_ * i;
        int i_3_ = rectangle.y + rectangle.height + i;
        int i_4_ = this.getWidth() - 2;
        for (int i_5_ = i_1_ + 1; i_2_ < i_3_ && i_5_ <= this.lineCount; ++i_5_, i_2_ += i) {
            String string = Integer.toString(i_5_);
            graphics.drawString(string, i_4_ - fontmetrics.stringWidth(string), i_2_);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertychangeevent) {
        if (propertychangeevent.getSource() == this.editorPane) {
            if ("font".equals(propertychangeevent.getPropertyName())) {
                this.setFont((Font)propertychangeevent.getNewValue());
                this.revalidate();
                this.repaint();
            } else if ("document".equals(propertychangeevent.getPropertyName())) {
                if (propertychangeevent.getOldValue() != null) {
                    ((Document)propertychangeevent.getOldValue()).removeDocumentListener(this);
                }
                if (propertychangeevent.getNewValue() != null) {
                    ((Document)propertychangeevent.getNewValue()).addDocumentListener(this);
                    this.docChanged();
                }
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentevent) {
        this.docChanged();
    }

    private void select(Point point, boolean bool) {
        DefaultCaret defaultcaret = this.getCaret();
        if (defaultcaret != null) {
            int i = this.editorPane.viewToModel(point);
            Element element = this.editorPane.getDocument().getDefaultRootElement();
            int i_6_ = element.getElementIndex(i);
            Element element_7_ = element.getElement(i_6_);
            if (!bool) {
                defaultcaret.setDot(element_7_.getStartOffset());
                defaultcaret.moveDot(element_7_.getEndOffset());
            } else {
                int i_8_ = defaultcaret.getMark();
                int i_9_ = defaultcaret.getDot();
                int i_10_ = element.getElementIndex(i_8_);
                int i_11_ = element.getElementIndex(i_9_);
                if (i >= i_8_) {
                    Element element_12_;
                    if (i_10_ - 1 == i_11_ && (element_12_ = element.getElement(i_11_)).getStartOffset() == i_9_ && element_12_.getEndOffset() == i_8_) {
                        defaultcaret.setDot(i_9_);
                    }
                    defaultcaret.moveDot(element_7_.getEndOffset());
                } else {
                    Element element_13_;
                    if ((i_10_ == i_11_ - 1 || i_10_ == i_11_) && (element_13_ = element.getElement(i_10_)).getStartOffset() == i_8_ && element_13_.getEndOffset() == i_9_) {
                        defaultcaret.setDot(i_9_);
                    }
                    defaultcaret.moveDot(element_7_.getStartOffset());
                }
            }
        }
    }
}

