/*
 * Decompiled with CFR 0.152.
 */
package hec.script;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import javax.swing.JOptionPane;

public class MessageBox {
    private MessageBox() {
    }

    public static void showError(String msg, String title) {
        MessageBox.showMessageBox(msg, title, 0);
    }

    public static void showWarning(String msg, String title) {
        MessageBox.showMessageBox(msg, title, 2);
    }

    public static void showInformation(String msg, String title) {
        MessageBox.showMessageBox(msg, title, 1);
    }

    public static void showPlain(String msg, String title) {
        MessageBox.showMessageBox(msg, title, -1);
    }

    public static void showMessageBox(String msg, String title, int type) {
        if (GraphicsEnvironment.isHeadless()) {
            System.out.println(title + ":" + msg);
        } else {
            JOptionPane.showMessageDialog(MessageBox.getFocusFrame(), msg, title, type);
        }
    }

    public static String showOkCancel(String msg, String title) {
        return MessageBox.showConfirm(msg, title, 2);
    }

    public static String showYesNo(String msg, String title) {
        return MessageBox.showConfirm(msg, title, 0);
    }

    public static String showYesNoCancel(String msg, String title) {
        return MessageBox.showConfirm(msg, title, 1);
    }

    public static String showConfirm(String msg, String title, int type) {
        if (GraphicsEnvironment.isHeadless()) {
            System.out.println(title + ":" + msg);
            return MessageBox.getStringFromRv(1, 0);
        }
        int rv = JOptionPane.showConfirmDialog(MessageBox.getFocusFrame(), msg, title, type);
        return MessageBox.getStringFromRv(rv, type);
    }

    private static String getStringFromRv(int rv, int type) {
        switch (rv) {
            case 0: {
                if (type == 0 || type == 1) {
                    return "yes";
                }
                return "ok";
            }
            case 2: {
                return "cancel";
            }
            case 1: {
                return "no";
            }
            case -1: {
                return "closed";
            }
        }
        return "";
    }

    private static boolean hasFocus(Container item) {
        boolean hasFocus = item.isFocusOwner();
        if (!hasFocus) {
            Component component;
            Component[] componentArray = item.getComponents();
            int n = componentArray.length;
            for (int i = 0; !(i >= n || !(hasFocus = (component = componentArray[i]).isFocusOwner()) && component instanceof Container && (hasFocus = MessageBox.hasFocus((Container)component))); ++i) {
            }
        }
        return hasFocus;
    }

    private static Frame getFocusFrame() {
        for (Frame frame : Frame.getFrames()) {
            if (!MessageBox.hasFocus(frame)) continue;
            return frame;
        }
        return null;
    }
}

