/*
 * Decompiled with CFR 0.152.
 */
package hec.script;

import hec.gfx2d.G2dDialog;
import hec.gfx2d.PlotLayout;
import hec.model.TsDataSetName;
import java.awt.Color;
import java.util.Vector;

public class Plot {
    protected String _title = "Plot";
    protected G2dDialog _dialog = null;
    protected Vector _dataSetList = null;
    protected Vector _colorVec = null;
    protected int _x = Integer.MIN_VALUE;
    protected int _y = Integer.MIN_VALUE;
    protected int _width = Integer.MIN_VALUE;
    protected int _height = Integer.MIN_VALUE;
    protected Color _currentColor = null;
    protected String _timeWindow = null;

    public Plot() {
    }

    public Plot(String title) {
        this._title = title;
    }

    public static G2dDialog newPlot() {
        return new G2dDialog();
    }

    public static G2dDialog newPlot(String title) {
        G2dDialog dialog = new G2dDialog();
        dialog.setTitle(title);
        return dialog;
    }

    public static PlotLayout newPlotLayout() {
        PlotLayout layout = new PlotLayout();
        return layout;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setTimeWindow(String startTime, String endTime) {
        this._timeWindow = startTime != null && endTime != null ? startTime + ";" + endTime : null;
    }

    public void setLineColor(String color) {
        this._currentColor = this.getColor(color);
    }

    public void getData(String source, String path) {
        TsDataSetName dataSet = null;
        if (source.equalsIgnoreCase("dss")) {
            dataSet = new TsDataSetName(false, path);
        } else if (source.equalsIgnoreCase("oracle")) {
            dataSet = new TsDataSetName(true, path);
        } else {
            System.out.println("Plot.getData: unknown source " + source);
            return;
        }
        if (this._dataSetList == null) {
            this._dataSetList = new Vector();
        }
        if (dataSet != null) {
            this._dataSetList.addElement(dataSet);
        }
        if (this._currentColor != null) {
            if (this._colorVec == null) {
                this._colorVec = new Vector();
            }
            this._colorVec.addElement(this._currentColor);
        }
    }

    public void hide() {
        if (this._dialog == null) {
            return;
        }
        this._dialog.setVisible(false);
    }

    public void show() {
        if (this._dialog == null) {
            return;
        }
        this._dialog.setVisible(true);
    }

    public void close() {
        this.hide();
        this._dialog = null;
    }

    public void setLocation(int x, int y) {
        this._x = x;
        this._y = y;
        if (this._dialog != null) {
            this._dialog.setLocation(x, y);
        }
    }

    public void setSize(int width, int height) {
        this._width = width;
        this._height = height;
        if (this._dialog != null) {
            this._dialog.setSize(width, height);
            this._dialog.invalidate();
            this._dialog.validate();
            this._dialog.repaint();
        }
    }

    protected void setSizeAndLoc() {
        if (this._dialog == null) {
            return;
        }
        if (this._x != Integer.MIN_VALUE && this._y != Integer.MIN_VALUE) {
            this._dialog.setLocation(this._x, this._y);
        }
        if (this._width != Integer.MIN_VALUE && this._height != Integer.MIN_VALUE) {
            this._dialog.setSize(this._width, this._height);
            this._dialog.invalidate();
            this._dialog.validate();
            this._dialog.repaint();
        }
    }

    Color getColor(String c2) {
        if (c2 == null || c2.length() < 1) {
            return null;
        }
        Color color = null;
        if (c2.equalsIgnoreCase("blue")) {
            color = Color.blue;
        } else if (c2.equalsIgnoreCase("black")) {
            color = Color.black;
        } else if (c2.equalsIgnoreCase("cyan")) {
            color = Color.cyan;
        } else if (c2.equalsIgnoreCase("darkGray")) {
            color = Color.darkGray;
        } else if (c2.equalsIgnoreCase("gray")) {
            color = Color.gray;
        } else if (c2.equalsIgnoreCase("green")) {
            color = Color.green;
        } else if (c2.equalsIgnoreCase("lightGray")) {
            color = Color.lightGray;
        } else if (c2.equalsIgnoreCase("magenta")) {
            color = Color.magenta;
        } else if (c2.equalsIgnoreCase("pink")) {
            color = Color.pink;
        } else if (c2.equalsIgnoreCase("red")) {
            color = Color.red;
        } else if (c2.equalsIgnoreCase("white")) {
            color = Color.white;
        } else if (c2.equalsIgnoreCase("yellow")) {
            color = Color.yellow;
        } else if (c2.equalsIgnoreCase("orange")) {
            color = Color.orange;
        }
        return color;
    }

    public G2dDialog getWindow() {
        return this._dialog;
    }
}

