/*
 * Decompiled with CFR 0.152.
 */
package hec.script;

import hec.script.ScriptIdentifierData;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.ScriptingLoggingMarker;

public class ScriptIdentifierSelection
implements Transferable {
    private static final MarkingClassLogger SCRIPTING_LOGGER = MarkingClassLogger.forMarkingClass(ScriptingLoggingMarker.class);
    public static final DataFlavor plainTextFlavor = DataFlavor.plainTextFlavor;
    public static final DataFlavor localStringFlavor = DataFlavor.stringFlavor;
    public static DataFlavor SCRIPTID_FLAVOR = null;
    public static DataFlavor[] flavors = null;
    private static final List flavorList;
    private ScriptIdentifierData _sid = new ScriptIdentifierData();

    public ScriptIdentifierSelection(ScriptIdentifierData sid) {
        this._sid = new ScriptIdentifierData(sid);
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        ((MarkingClassLogger.Api)SCRIPTING_LOGGER.atFine()).log("checking flavor %s", flavor);
        return flavorList.contains(flavor);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(SCRIPTID_FLAVOR)) {
            return this._sid;
        }
        if (flavor.equals(plainTextFlavor)) {
            return this._sid.toString();
        }
        if (flavor.equals(localStringFlavor)) {
            return this._sid.toString();
        }
        if (flavor.equals("application/x-java-jvm-local-objectref")) {
            return this._sid;
        }
        System.out.println("getTransferData: unsupported flavor " + flavor);
        throw new UnsupportedFlavorException(flavor);
    }

    public String toString() {
        return "ScriptIdentifierSelection";
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    static {
        try {
            SCRIPTID_FLAVOR = new DataFlavor(ScriptIdentifierSelection.class, "Script");
            flavors = new DataFlavor[]{SCRIPTID_FLAVOR};
        }
        catch (Exception e) {
            System.out.println("error creating DataFlavors " + e);
        }
        flavorList = Arrays.asList(flavors);
    }
}

