/*
 * Decompiled with CFR 0.152.
 */
package hec.script;

import hec.script.ScriptIdentifier;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import rma.swing.RmaImage;

public class ScriptMenuItem
extends JMenuItem {
    ScriptIdentifier _id;
    private String _iconName;

    public ScriptMenuItem(ScriptIdentifier sid) {
        super(sid.getUserDisplayedName() == null || sid.getUserDisplayedName().length() < 1 ? sid.getName() : sid.getUserDisplayedName());
        this._id = sid;
        if (sid == null) {
            return;
        }
        if (sid.getDescription() != null && sid.getDescription().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(sid.getDescription(), "\n");
            StringBuffer buffer = new StringBuffer(sid.getDescription().length() + 20);
            buffer.append("<html>");
            while (tokenizer.hasMoreTokens()) {
                buffer.append(tokenizer.nextToken());
                if (!tokenizer.hasMoreTokens()) continue;
                buffer.append("<BR>");
            }
            buffer.append("</html>");
            this.setToolTipText(buffer.toString());
        } else {
            this.setToolTipText(null);
        }
        String iconName = sid.getIconName();
        if (iconName != null) {
            this.setIconName(iconName);
        }
    }

    public ScriptIdentifier getScriptIdentifier() {
        return this._id;
    }

    @Override
    public String getText() {
        if (this._id != null && this.getIcon() == null) {
            return this._id.getUserDisplayedName() == null || this._id.getUserDisplayedName().length() < 1 ? this._id.getName() : this._id.getUserDisplayedName();
        }
        return super.getText();
    }

    public void setIconName(String iconName) {
        if (iconName == null) {
            this.setIcon(null);
            return;
        }
        ImageIcon icon = RmaImage.getImageIcon(iconName);
        this.setIcon(icon);
        if (icon != null) {
            this.setText(null);
        }
        this._iconName = iconName;
    }

    public String getIconName() {
        return this._iconName;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if ((event.getModifiers() & 2) != 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("<html>");
            buf.append("Name=");
            buf.append(this._id.getUserDisplayedName());
            buf.append("<BR>");
            buf.append("File=");
            buf.append(this._id.getFileName());
            buf.append("<BR>");
            buf.append("TreePath=");
            buf.append(this._id.getModulePath());
            if (this._id.getDescription() != null && this._id.getDescription().length() > 0) {
                buf.append("<BR>");
                buf.append("Description=");
                buf.append(this._id.getDescription());
            }
            buf.append("</html>");
            return buf.toString();
        }
        return super.getToolTipText(event);
    }
}

