/*
 * Decompiled with CFR 0.152.
 */
package hec.script;

import hec.model.JobTask;
import hec.model.SchedulableJob;
import hec.script.ScriptJob;
import hec.script.ServerScriptJobTask;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;

public class ScriptTaskInfoJDialog
extends RmaJDialog {
    JobTask _task = null;
    private JLabel nameLabel;
    private JLabel scriptNameLabel;
    private JLabel userNameLabel;
    private JLabel lastStatusLabel;
    private JLabel intervalLabel;
    private JLabel locationLabel;
    private JLabel startDateLabel;
    private JLabel nextJobDateLabel;
    private RmaJTable statusList;

    public ScriptTaskInfoJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setSize(300, 325);
        this.setLocation();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)new JLabel("Name:"), gbc);
        this.nameLabel = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.nameLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)new JLabel("Script Name:"), gbc);
        this.scriptNameLabel = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.scriptNameLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)new JLabel("User Name:"), gbc);
        this.userNameLabel = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.userNameLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)new JLabel("Last Status:"), gbc);
        this.lastStatusLabel = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.lastStatusLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)new JLabel("Start Date:"), gbc);
        this.startDateLabel = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.startDateLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)new JLabel("Interval:"), gbc);
        this.intervalLabel = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.intervalLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)new JLabel("Location:"), gbc);
        this.locationLabel = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.locationLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)new JLabel("Next Run Date:"), gbc);
        this.nextJobDateLabel = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.nextJobDateLabel, gbc);
        this.statusList = new RmaJTable((Component)this, (Object[])new String[]{"Status"});
        this.statusList.setTextAreaCellEditor(0);
        this.statusList.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 2.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.statusList.getScrollPane(), gbc);
        JButton button = new JButton("Close");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 9;
        gbc.anchor = 14;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this.getContentPane().add((Component)button, gbc);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptTaskInfoJDialog.this.setVisible(false);
            }
        });
        this.getContentPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ScriptTaskInfoJDialog.this._task != null) {
                    ScriptTaskInfoJDialog.this._task.printInfo();
                }
            }
        });
    }

    public void fillForm(JobTask task) {
        this.clearForm();
        if (task == null) {
            return;
        }
        this._task = task;
        this.setTitle(task.getName());
        this.nameLabel.setText(task.getName());
        this.lastStatusLabel.setText(task.getStatus());
        Vector v = task.getJobMessages();
        for (int i = 0; i < v.size(); ++i) {
            this.statusList.setValueAt(v.get(i), i, 0);
        }
        if (task instanceof ServerScriptJobTask) {
            this.locationLabel.setText("Server");
        } else {
            this.locationLabel.setText("Client");
        }
        SchedulableJob job = task.getJob();
        if (job == null) {
            return;
        }
        this.userNameLabel.setText(job.getUser());
        this.intervalLabel.setText(job.getIntervalString());
        if (job instanceof ScriptJob) {
            this.scriptNameLabel.setText(((ScriptJob)job).getScriptName());
        }
        this.startDateLabel.setText(job.getStartDate().toString());
        if (!job.isRecurring() && task.getLastRunTime() > 0L) {
            this.nextJobDateLabel.setText("N/A");
        } else if (task.getLastRunTime() <= 0L) {
            this.nextJobDateLabel.setText(new Date(job.getStartDate().getTime()).toString());
        } else {
            this.nextJobDateLabel.setText(new Date(task.getLastRunTime() + job.getPeriod()).toString());
        }
    }

    @Override
    public void clearForm() {
        super.clearForm();
        this.setTitle("");
        this.nameLabel.setText("");
        this.scriptNameLabel.setText("");
        this.userNameLabel.setText("");
        this.lastStatusLabel.setText("");
        this.intervalLabel.setText("");
        this.locationLabel.setText("");
        this.startDateLabel.setText("");
        this.nextJobDateLabel.setText("");
    }
}

