/*
 * Decompiled with CFR 0.152.
 */
package hec.script;

import hec.io.AsciiSerializable;
import hec.model.JobTask;
import hec.script.ScriptJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import rma.util.RMAIO;

public class ServerScriptJobTask
extends JobTask
implements Serializable,
AsciiSerializable {
    private static final long serialVersionUID = -4169350707962180954L;
    protected String _serverUrl;

    public ServerScriptJobTask() {
    }

    public ServerScriptJobTask(ScriptJob job, String serverUrl) {
        super(job);
        this._serverUrl = serverUrl;
    }

    @Override
    public void run() {
        if (this.isPaused()) {
            return;
        }
        final ScriptJob job = (ScriptJob)this.getJob();
        if (job == null) {
            return;
        }
        this.setIsRunning(true);
        this.setJobStatus("Running script " + this.getName(), "In Progress");
        Thread t = new Thread(job.getName() + " Script Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block13: {
                    try {
                        String exe;
                        String scriptPath = job.getScriptPath();
                        if (job.getScript() != null) {
                            String[] localScriptPath = new String[1];
                            if (!ServerScriptJobTask.this.writeScript(job, localScriptPath)) {
                                ServerScriptJobTask.this.setJobStatus("Failed to save script file " + localScriptPath[0] + " locally", "Error");
                                return;
                            }
                            scriptPath = localScriptPath[0];
                        }
                        if ((exe = ServerScriptJobTask.this.getExecutable()) == null) {
                            ServerScriptJobTask.this.setJobStatus("No executable found", "Error");
                            return;
                        }
                        ServerScriptJobTask.this.setLastRunTime();
                        String wkspPath = job.getWorkspacePath();
                        String output = System.getProperty("CWMS_HOME");
                        output = RMAIO.concatPath(output, "dated/logs/scripts/");
                        String scriptFileName = RMAIO.getFileNameNoExtension(scriptPath);
                        output = RMAIO.concatPath(output, scriptFileName);
                        output = output.concat(".");
                        String wkspName = RMAIO.getFileFromPath(wkspPath);
                        output = output.concat(wkspName);
                        output = output.concat(".out");
                        Object[] args = new String[]{exe, scriptPath};
                        File outputFile = new File(output);
                        try {
                            System.out.println("run:launching " + Arrays.toString(args));
                            System.out.println("run:output sent to " + outputFile.getAbsolutePath());
                            ServerScriptJobTask.this.setJobStatus("Running...", "In Progress");
                            ProcessBuilder pb = new ProcessBuilder((String[])args);
                            pb.redirectOutput(outputFile);
                            pb.redirectError(outputFile);
                            Process proc = pb.start();
                            int rv = proc.waitFor();
                            ServerScriptJobTask.this.setJobStatus("Running...", "Done");
                            if (rv != 0) {
                                ServerScriptJobTask.this.setJobStatus("Scripting client returned " + rv, "Error");
                            }
                            if (!job.isRecurring()) {
                                ServerScriptJobTask.this.setJobStatus("", "Done");
                                break block13;
                            }
                            ServerScriptJobTask.this.setJobStatus("", "Successful");
                        }
                        catch (Throwable e) {
                            String err = ServerScriptJobTask.this.getStackTraceString(e);
                            ServerScriptJobTask.this.setJobStatus(err, "Error");
                            if (ServerScriptJobTask.this.getParent() != null) {
                                ServerScriptJobTask.this.getParent().logException(e);
                            }
                        }
                    }
                    finally {
                        ServerScriptJobTask.this.setIsRunning(false);
                        ServerScriptJobTask.this.setNextRunTime(ServerScriptJobTask.this.scheduledExecutionTime());
                    }
                }
            }
        };
        t.setName(job.getName() + ".job");
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeScript(ScriptJob job, String[] localScriptPath) {
        String cwmsHome;
        String wkspPath = job.getWorkspacePath();
        String wkspName = RMAIO.getFileFromPath(wkspPath);
        String scriptPath = job.getScriptPath();
        String scriptFileName = RMAIO.getFileFromPath(scriptPath);
        String lsp = cwmsHome = System.getProperty("CWMS_HOME");
        lsp = RMAIO.concatPath(lsp, "scripts");
        File f = new File(lsp = RMAIO.concatPath(lsp, wkspName));
        if (!f.exists() && !f.mkdirs()) {
            System.out.println("writeScript:failed to make folder " + lsp);
        }
        localScriptPath[0] = lsp = RMAIO.concatPath(lsp, scriptFileName);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(lsp));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        String script = job.getScript();
        try {
            writer.write(script);
            writer.newLine();
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            System.out.println("writeScript:error writing script " + lsp + " Error:" + ioe);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    protected String getExecutable() {
        String exe = System.getProperty("CWMS_EXE");
        if (exe == null) {
            this.setJobStatus("No CWMS_EXE property defined", "Error");
            System.out.println("ERROR: no CWMS_EXE property defined");
            return null;
        }
        exe = RMAIO.concatPath(exe, "bin");
        exe = RMAIO.concatPath(exe, "jython");
        return exe;
    }

    public void setServerUrl(String serverUrl) {
        this._serverUrl = serverUrl;
    }

    public String getServerUrl() {
        return this._serverUrl;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    @Override
    public void printInfo() {
        super.printInfo();
        System.out.println("ServerScriptJobTask info");
        System.out.println("serverURL=" + this._serverUrl);
    }
}

