/*
 * Decompiled with CFR 0.152.
 */
package hec.security;

import hec.security.PermissionConstants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;

public class ApplicationPermission
extends Permission
implements Serializable,
PermissionConstants {
    static final long serialVersionUID = 5334798421627714261L;
    public static final ApplicationPermission ALL_PERMISSION = new ApplicationPermission("*");
    private transient boolean wildcard;
    private transient String path;
    private int _mask;
    private String _actionString;
    private static boolean _debug = false;

    public ApplicationPermission(String name) {
        super(name);
        this.init(name);
    }

    public ApplicationPermission(String name, String action) {
        super(name);
        this.setAction(action);
    }

    public ApplicationPermission(String name, int action) {
        super(name);
        this._actionString = "" + action;
        this.init(name);
        this.init(action);
    }

    public void setAction(String action) {
        this._actionString = action;
        this.init(this.getName());
        this.init(ApplicationPermission.getMask(action));
    }

    @Override
    public String getActions() {
        return this._actionString;
    }

    private void init(String name) {
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("name can't be empty");
        }
        if (name.endsWith(".*") || name.equals("*")) {
            this.wildcard = true;
            this.path = name.length() == 1 ? "" : name.substring(0, name.length() - 1);
        } else {
            this.path = name;
        }
    }

    private void init(int mask) {
        if ((mask & 7) != mask) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (mask == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (this.getName() == null) {
            throw new NullPointerException("name can't be null");
        }
        this._mask = mask;
    }

    public boolean impliesPrivate(Permission p) {
        if (p == null || !p.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        ApplicationPermission that = (ApplicationPermission)p;
        if (this.wildcard) {
            if (that.wildcard) {
                return that.path.startsWith(this.path);
            }
            return that.path.length() <= this.path.length() && this.path.startsWith(that.path + ".");
        }
        if (that.wildcard) {
            return false;
        }
        if (this.path.equals(that.path)) {
            if (_debug) {
                System.out.println(this.toString() + " paths match");
            }
            return true;
        }
        if (_debug) {
            System.out.println(this.toString() + " paths not an exact match");
        }
        if (that.path.length() <= this.path.length() && this.path.startsWith(that.path + ".")) {
            if (_debug) {
                System.out.println(this.toString() + " I imply " + that);
            }
            return true;
        }
        return false;
    }

    public int implies(ApplicationPermission ap) {
        if (_debug) {
            System.out.println(this.toString() + ".implies " + ap + "?");
        }
        if (this.impliesPrivate(ap)) {
            if (_debug) {
                System.out.println(this.getName() + " paths match");
            }
            if (ap.getAction() <= this._mask) {
                return ap.getAction();
            }
        }
        return 0;
    }

    @Override
    public boolean implies(Permission ap) {
        if (_debug) {
            System.out.println(ap + ".implies Permission " + ap);
        }
        return false;
    }

    public int getAction(String permName) {
        if (permName == null) {
            return 0;
        }
        boolean isWildcard = false;
        if (permName.endsWith(".*") || permName.equals("*")) {
            isWildcard = true;
        }
        if (this.wildcard) {
            if (isWildcard ? permName.startsWith(this.path) : permName.length() <= this.path.length() && this.path.startsWith(permName + ".")) {
                return this.getAction();
            }
        } else {
            if (isWildcard) {
                return 0;
            }
            if (this.path.equals(permName)) {
                if (_debug) {
                    System.out.println(this.toString() + " paths match");
                }
                return this.getAction();
            }
            if (_debug) {
                System.out.println(this.toString() + " paths not an exact match");
            }
            if (permName.length() <= this.path.length() && this.path.startsWith(permName + ".")) {
                if (_debug) {
                    System.out.println(this.toString() + " I imply " + permName);
                }
                return this.getAction();
            }
        }
        return 0;
    }

    public int getAction() {
        return this._mask;
    }

    public static int getMask(String actions) {
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        char[] a = actions.toCharArray();
        int i = a.length - 1;
        if (i < 0) {
            return mask;
        }
        while (i != -1) {
            int matchlen;
            char c2;
            while (i != -1 && ((c2 = a[i]) == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\t')) {
                --i;
            }
            if (!(i < 3 || a[i - 3] != 'r' && a[i - 3] != 'R' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 'a' && a[i - 1] != 'A' || a[i] != 'd' && a[i] != 'D')) {
                matchlen = 4;
                mask |= 1;
            } else if (!(i < 4 || a[i - 4] != 'w' && a[i - 4] != 'W' || a[i - 3] != 'r' && a[i - 3] != 'R' || a[i - 2] != 'i' && a[i - 2] != 'I' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 5;
                mask |= 3;
            } else if (!(i < 8 || a[i - 8] != 'c' && a[i - 8] != 'C' || a[i - 7] != 'o' && a[i - 7] != 'O' || a[i - 6] != 'n' && a[i - 6] != 'N' || a[i - 5] != 'f' && a[i - 5] != 'F' || a[i - 4] != 'i' && a[i - 4] != 'I' || a[i - 3] != 'g' && a[i - 3] != 'G' || a[i - 2] != 'u' && a[i - 2] != 'U' || a[i - 1] != 'r' && a[i - 1] != 'R' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 9;
                mask |= 4;
            } else {
                throw new IllegalArgumentException("invalid permission: " + actions);
            }
            boolean seencomma = false;
            while (i >= matchlen && !seencomma) {
                switch (a[i - matchlen]) {
                    case ',': {
                        seencomma = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + actions);
                    }
                }
                --i;
            }
            i -= matchlen;
        }
        return mask;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this._actionString + "(" + this._mask + ")";
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(this.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ApplicationPermission ap = (ApplicationPermission)obj;
        return this.getName().equals(ap.getName()) && this._mask == ap._mask;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    static {
        _debug = Boolean.getBoolean("hec.security.debug");
    }
}

