/*
 * Decompiled with CFR 0.152.
 */
package hec.security;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class PasswordEntry
implements Serializable {
    private static final String FIELD_SEP = "|";
    private static final String USERTYPE_SEP = ",";
    private static final String COMMENT = "#";
    private static final String LOCKED = "LOCKED";
    private boolean _commentedOut = false;
    private String _userName;
    private String _password;
    private Vector<String> _userTypeNames = new Vector();
    private String _userFullName;
    private String _userDir;
    private String _createdBy;
    private String _dbUser;
    private String _dbPassword;
    private long _edipi;
    private Map<Serializable, Serializable> _pluginData;
    private int _loginFailureCnt = 0;
    private boolean _locked = false;

    public PasswordEntry(String userName, boolean commentedOut) {
        this._userName = userName;
        this._commentedOut = commentedOut;
    }

    public Map<Serializable, Serializable> getPluginData() {
        if (this._pluginData == null) {
            this._pluginData = new HashMap<Serializable, Serializable>();
        }
        return this._pluginData;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getDbUser() {
        return this._dbUser;
    }

    public String getDbPassword() {
        return this._dbPassword;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public void setDbUser(String dbUser) {
        this._dbUser = dbUser;
    }

    public void setDbPassword(String dbPassword) {
        this._dbPassword = dbPassword;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String newPassword) {
        this._password = newPassword;
    }

    public Vector<String> getUserTypeNames() {
        return this._userTypeNames;
    }

    public void setUserTypeNames(Vector<String> userTypes) {
        this.clearUserTypes();
        this._userTypeNames.addAll(userTypes);
    }

    public void addUserType(String userTypeName) {
        if (userTypeName == null || userTypeName.length() < 1) {
            return;
        }
        if (!this._userTypeNames.contains(userTypeName)) {
            this._userTypeNames.add(userTypeName);
        }
    }

    public void removeUserType(String userTypeName) {
        this._userTypeNames.remove(userTypeName);
    }

    public void clearUserTypes() {
        this._userTypeNames.clear();
    }

    public String getUserFullName() {
        return this._userFullName;
    }

    public void setUserFullName(String fullName) {
        this._userFullName = fullName;
    }

    public void setCreatedBy(String createdBy) {
        this._createdBy = createdBy;
    }

    public String getCreatedBy() {
        return this._createdBy;
    }

    public String getUserDir() {
        return this._userDir;
    }

    public void setUserDir(String userDir) {
        this._userDir = userDir;
    }

    public void incrementLoginFailureCnt() {
        ++this._loginFailureCnt;
    }

    public int getLoginFailureCnt() {
        return this._loginFailureCnt;
    }

    public void resetLoginFailureCnt() {
        this._loginFailureCnt = 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PasswordEntry) {
            return this.equals((PasswordEntry)obj);
        }
        return false;
    }

    public boolean equals(PasswordEntry that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        return this._userName.equals(that._userName);
    }

    public int hashCode() {
        return this._userName.hashCode();
    }

    public boolean isLocked() {
        return this._locked;
    }

    public void setLocked(boolean locked) {
        this._locked = locked;
    }

    public String toString() {
        return this._userName + (this.isLocked() ? " (Locked)" : "");
    }

    public void set(PasswordEntry pe) {
        this._userName = pe._userName;
        this._password = pe._password;
        this._userTypeNames = (Vector)pe._userTypeNames.clone();
        this._userFullName = pe._userFullName;
        this._userDir = pe._userDir;
        this._locked = pe._locked;
        this._createdBy = pe._createdBy;
    }

    public void writeLine(Writer writer) throws IOException {
        if (writer == null) {
            return;
        }
        if (this._commentedOut) {
            writer.write(COMMENT);
        }
        writer.write(this._userName);
        writer.write(FIELD_SEP);
        writer.write(this._password);
        writer.write(FIELD_SEP);
        this.writeUserTypes(writer);
        writer.write(FIELD_SEP);
        if (this._userFullName.length() < 1) {
            writer.write(" ");
        } else {
            writer.write(this._userFullName);
        }
        writer.write(FIELD_SEP);
        if (this._userDir != null) {
            writer.write(this._userDir);
            writer.write(FIELD_SEP);
        }
        if (this._locked) {
            writer.write(FIELD_SEP);
            writer.write(LOCKED);
        }
    }

    public void writeUserTypes(Writer writer) throws IOException {
        int size = this._userTypeNames.size();
        if (size == 0) {
            writer.write(" ");
            return;
        }
        for (int i = 0; i < size; ++i) {
            writer.write(this._userTypeNames.get(i));
            if (i >= size - 1) continue;
            writer.write(USERTYPE_SEP);
        }
    }

    public static PasswordEntry parseLine(String line) {
        String token;
        if (line == null || line.isEmpty()) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(line, FIELD_SEP);
        boolean isComment = false;
        if (tokenizer.countTokens() < 4) {
            System.out.println("invalid password file line [" + line + "]");
            return null;
        }
        String userName = tokenizer.nextToken();
        if (userName.startsWith(COMMENT)) {
            userName = userName.substring(1).trim();
            isComment = true;
        } else {
            isComment = false;
        }
        PasswordEntry pe = new PasswordEntry(userName, isComment);
        pe.setPassword(tokenizer.nextToken());
        Vector groups = PasswordEntry.getUserTypes(tokenizer.nextToken());
        pe.setUserTypeNames(groups);
        pe.setUserFullName(tokenizer.nextToken());
        String edipi_str = tokenizer.nextToken();
        if (edipi_str != null && edipi_str.length() != 0) {
            pe.setEdipi(Long.parseLong(edipi_str));
        } else {
            pe.setEdipi(0L);
        }
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.equals(LOCKED)) {
                pe.setLocked(true);
            } else {
                pe.setUserDir(token);
            }
        }
        if (tokenizer.hasMoreTokens() && (token = tokenizer.nextToken()).equals(LOCKED)) {
            pe.setLocked(true);
        }
        return pe;
    }

    private static Vector getUserTypes(String userTypeList) {
        StringTokenizer tokenizer = new StringTokenizer(userTypeList.trim(), USERTYPE_SEP);
        int cnt = tokenizer.countTokens();
        Vector<String> userTypes = new Vector<String>(cnt);
        for (int i = 0; i < cnt; ++i) {
            userTypes.add(tokenizer.nextToken());
        }
        return userTypes;
    }

    public long getEdipi() {
        return this._edipi;
    }

    public void setEdipi(long edipi) {
        this._edipi = edipi;
    }
}

