/*
 * Decompiled with CFR 0.152.
 */
package hec.security;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import hec.security.PasswordEntry;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Vector;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class UserProfile
implements Serializable {
    private static final long serialVersionUID = -1467242428998924839L;
    @JsonProperty(value="userId")
    private String _userId;
    @JsonProperty(value="password")
    private String _password;
    @JsonProperty(value="userName")
    private String _userName;
    @JsonProperty(value="userFullName")
    private String _userFullName;
    @JsonProperty(value="userDir")
    private String _userDir;
    @JsonProperty(value="userTypes")
    private List<String> _userTypes;
    @JsonProperty(value="dbSessionKey")
    private String _dbSessionKey;
    @JsonProperty(value="serverSessionKey")
    private long _serverSessionKey;
    @JsonProperty(value="invalidLoginAttempts")
    private int _invalidLoginAttempts = 0;
    @JsonProperty(value="lastLoginTime")
    private ZonedDateTime _lastLoginTime;
    @JsonProperty(value="uuid")
    private String _uuid;

    public UserProfile() {
    }

    public UserProfile(String userId, String userName) {
        this._userId = userId;
        this._userName = userName;
        this._userFullName = userName;
        this._userDir = null;
        this._userTypes = new Vector<String>();
        this._userTypes.add("None");
    }

    public UserProfile(PasswordEntry pe, String userId) {
        this.loadPe(pe, userId);
    }

    public UserProfile(UserProfile copy) {
        this._userId = copy._userId;
        this._password = copy._password;
        this._userName = copy._userName;
        this._userFullName = copy._userFullName;
        this._userDir = copy._userDir;
        this._userTypes = copy._userTypes;
        this._dbSessionKey = copy._dbSessionKey;
        this._serverSessionKey = copy._serverSessionKey;
        this._invalidLoginAttempts = copy._invalidLoginAttempts;
        this._lastLoginTime = copy._lastLoginTime;
        this._uuid = copy._uuid;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getUserId() {
        return this._userId;
    }

    public String getPassword() {
        return this._password;
    }

    public int getInvalidLoginAttempts() {
        return this._invalidLoginAttempts;
    }

    public String getDbSessionKey() {
        return this._dbSessionKey;
    }

    public long getServerSessionKey() {
        return this._serverSessionKey;
    }

    public void setLastLoginTime(ZonedDateTime lastLoginTime) {
        this._lastLoginTime = lastLoginTime;
    }

    public Optional<ZonedDateTime> getLastLoginTime() {
        return Optional.ofNullable(this._lastLoginTime);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UserProfile: UserId=").append(this._userId).append("\nUserName=").append(this._userName).append("\nUserFullName=").append(this._userFullName).append("\nUserDirectory=").append(this._userDir).append("\nInvalidLoginAttempts=").append(this._invalidLoginAttempts);
        if (this._lastLoginTime != null) {
            stringBuilder.append("\nLast Login Time=").append(this._lastLoginTime);
        }
        stringBuilder.append("\nKey=...").append(this._serverSessionKey >> 16).append("\nUser Types:");
        if (this._userTypes != null) {
            for (String userType : this._userTypes) {
                stringBuilder.append("\n\t").append((Object)userType);
            }
        }
        return stringBuilder.toString();
    }

    public String getUuid() {
        return this._uuid;
    }

    public void setUuid(String uuid) {
        this._uuid = uuid;
    }

    private void loadPe(PasswordEntry pe, String userId) {
        Objects.requireNonNull(pe, "UserProfile.init: PasswordEntry can not be null");
        this._userName = pe.getUserName();
        this._password = pe.getPassword();
        this._userFullName = pe.getUserFullName();
        this._userDir = pe.getUserDir();
        this._userId = userId;
        this._userTypes = pe.getUserTypeNames();
        this._invalidLoginAttempts = pe.getLoginFailureCnt();
        this._serverSessionKey = System.currentTimeMillis();
        this._dbSessionKey = pe.getPassword();
    }
}

