/*
 * Decompiled with CFR 0.152.
 */
package hec.server;

import java.util.logging.Logger;
import rma.util.RMAIO;

public class AppVersion {
    private static Logger LOGGER = Logger.getLogger(AppVersion.class.getName());
    private static final String NO_APP_VERSION_CHECK_FLAG = "NoAppVersionCheck";
    private static final int MAX_VERSION_CHECK_IDX = Integer.getInteger("AppVersionCheckIndex", 2);
    private static String _appVersion;
    private static int[] _appVersionArray;

    private AppVersion() {
    }

    public static String checkAppVersion(String wkspVersion, String wkspName) {
        if (AppVersion.shouldCheckAppVersion()) {
            if (_appVersionArray == null || wkspVersion == null) {
                return null;
            }
            int[] wkspVersionArray = AppVersion.getVersionArray(wkspVersion);
            if (wkspVersionArray != null && wkspVersionArray.length >= MAX_VERSION_CHECK_IDX) {
                for (int i = 0; i < MAX_VERSION_CHECK_IDX && _appVersionArray[i] <= wkspVersionArray[i]; ++i) {
                    if (_appVersionArray[i] >= wkspVersionArray[i]) continue;
                    if (wkspName == null) {
                        wkspName = "";
                    }
                    String msg = "Can''t open a newer {0} with older version of software. \n{1} " + wkspName + " was last written with version " + wkspVersion + ". \nCurrent version of the application is " + _appVersion;
                    LOGGER.info(msg);
                    return msg;
                }
                return null;
            }
        }
        return null;
    }

    public static void setAppVersion(String appVersion) {
        _appVersion = appVersion;
        if (_appVersion != null && (_appVersionArray = AppVersion.getVersionArray(_appVersion)) != null && _appVersionArray.length < MAX_VERSION_CHECK_IDX) {
            _appVersionArray = null;
        }
    }

    private static int[] getVersionArray(String versionString) {
        if (versionString == null) {
            return null;
        }
        String[] versionArray = versionString.split("\\.");
        if (versionArray == null) {
            return null;
        }
        int[] intVersionArray = new int[versionArray.length];
        for (int i = 0; i < versionArray.length; ++i) {
            intVersionArray[i] = RMAIO.parseInt(versionArray[i], -1);
        }
        return intVersionArray;
    }

    public static String getAppVersion() {
        return _appVersion;
    }

    public static boolean shouldCheckAppVersion() {
        return !Boolean.getBoolean(NO_APP_VERSION_CHECK_FLAG);
    }
}

