/*
 * Decompiled with CFR 0.152.
 */
package hec.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public abstract class HECProperties {
    private Properties _properties = new Properties();
    private File _file;
    private String _header = "HEC Properties";

    public HECProperties() {
    }

    public HECProperties(String filename) {
        this();
        this._file = new File(filename);
        if (this._file.isFile()) {
            this.loadProperties();
        } else {
            this._properties = this.createProperties(this._properties);
            this.saveProperties();
        }
    }

    public abstract Properties createProperties(Properties var1);

    public void loadProperties() {
        try {
            this._properties.load(new BufferedInputStream(new FileInputStream(this._file)));
        }
        catch (IOException ioe) {
            System.out.println("Properties file " + this._file.toString() + " not found");
            System.out.println("using default properties");
        }
    }

    public void saveProperties() {
        try {
            FileOutputStream fos = new FileOutputStream(this._file);
            this._properties.save(fos, this.getHeader());
            fos.close();
        }
        catch (IOException ioe) {
            System.out.println("Properties file " + this._file.toString() + " not found");
            System.out.println("using default properties");
        }
    }

    public String getHeader() {
        return this._header;
    }

    public void setHeader(String header) {
        this._header = header;
    }

    public Enumeration getKeys() {
        return this._properties.keys();
    }

    public int getSize() {
        return this._properties.size();
    }

    public void listProperties() {
        Enumeration<Object> enumeration = this._properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            System.out.println(key + " value is " + this._properties.getProperty(key));
        }
    }
}

