/*
 * Decompiled with CFR 0.152.
 */
package hec.server;

import java.io.Serializable;
import java.util.Vector;

public class Profile
implements Serializable {
    String _uid = null;
    Vector _groups = null;
    String _password = null;

    public Profile() {
        this(new String(), new Vector(), new String());
    }

    public Profile(String newuid) {
        this(newuid, new Vector(), new String());
    }

    public Profile(String newuid, int gid) {
        this(newuid, new Vector(gid), new String());
    }

    public Profile(String newuid, int gid, String newpassword) {
        this(newuid, new Vector(gid), newpassword);
    }

    public Profile(String newuid, Vector newgroups) {
        this(newuid, newgroups, new String());
    }

    public Profile(String newuid, String newpassword) {
        this(newuid, new Vector(), newpassword);
    }

    public Profile(String newuid, Vector newgroups, String newpassword) {
        this._uid = newuid;
        this._groups = newgroups;
        this._password = newpassword;
    }

    public void setuid(String newuid) {
        this._uid = newuid;
    }

    public void addGroup(int group) {
        this._groups.addElement(new Integer(group));
    }

    public String getuid() {
        return this._uid;
    }

    public String getpassword() {
        return this._password;
    }

    public Vector getGroups() {
        return this._groups;
    }

    public boolean inGroup(int group) {
        for (int i = 0; i < this._groups.size(); ++i) {
            if ((Integer)this._groups.elementAt(i) != group) continue;
            return true;
        }
        return false;
    }

    public void changePassword(String currentPassword, String newPassword) {
        if (this._password == null) {
            if (this.isPassword(currentPassword)) {
                this._password = newPassword;
            }
        } else if (currentPassword == null || newPassword == null) {
            return;
        }
    }

    public boolean isUid(String uid) {
        return this._uid.compareTo(uid) == 0;
    }

    public boolean isPassword(String password) {
        return this._password.compareTo(password) == 0;
    }

    public boolean isUser(String uid, String password) {
        return this.isUid(uid) && this.isPassword(password);
    }

    public void print() {
        System.out.print(this._uid + ";");
        for (int i = 0; i < this._groups.size(); ++i) {
            System.out.print(this._groups.elementAt(i));
            if (i >= this._groups.size()) break;
            System.out.print(",");
        }
        System.out.println(this._password);
    }
}

