/*
 * Decompiled with CFR 0.152.
 */
package hec.server;

import hec.server.Profile;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class ProfileTable {
    String filename = new String("users.dat");
    Vector users = null;
    FileInputStream istream = null;
    FileOutputStream ostream = null;
    ObjectInputStream objInStream = null;
    ObjectOutputStream objOutStream = null;

    public ProfileTable() {
        if (this.getTableData() == -1) {
            this.users = new Vector(0);
        }
    }

    int getTableData() {
        try {
            this.istream = new FileInputStream(this.filename);
            this.objInStream = new ObjectInputStream(this.istream);
            this.users = (Vector)this.objInStream.readObject();
            this.istream.close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(fnfe.toString());
            return -1;
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println(cnfe.toString());
            return -1;
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            return -1;
        }
        return 0;
    }

    public int save() {
        try {
            this.ostream = new FileOutputStream(this.filename);
            this.objOutStream = new ObjectOutputStream(this.ostream);
            this.objOutStream.writeObject(this.users);
            this.objOutStream.flush();
            this.ostream.close();
        }
        catch (IOException ioe) {
            return -1;
        }
        return 0;
    }

    public int addUser(Profile p) {
        if (this.isUID(p.getuid())) {
            return -1;
        }
        this.users.addElement(p);
        return 0;
    }

    public int addUser() {
        System.err.println("Cannot create empty user entry.");
        return -1;
    }

    public int countUsers() {
        return this.users.size();
    }

    public Profile getUserUID(String uid) {
        for (int i = 0; i < this.users.size(); ++i) {
            if (((Profile)this.users.elementAt(i)).getuid().compareTo(uid) != 0) continue;
            return (Profile)this.users.elementAt(i);
        }
        return null;
    }

    public boolean isUID(String uid) {
        for (int i = 0; i < this.users.size(); ++i) {
            if (((Profile)this.users.elementAt(i)).getuid().compareTo(uid) != 0) continue;
            return true;
        }
        return false;
    }

    public Vector getAdmins() {
        return null;
    }

    public Vector getUsersGID(int gid) {
        return null;
    }

    public void print() {
        if (this.users != null) {
            for (int i = 0; i < this.users.size(); ++i) {
                ((Profile)this.users.elementAt(i)).print();
            }
        }
    }

    public Profile validateUser(String uid, String password) {
        if (this.users != null) {
            for (int i = 0; i < this.users.size(); ++i) {
                if (!((Profile)this.users.elementAt(i)).isUser(uid, password)) continue;
                return (Profile)this.users.elementAt(i);
            }
        }
        return null;
    }
}

