/*
 * Decompiled with CFR 0.152.
 */
package hec.server;

import java.io.PrintStream;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.UserIDLoggingMarker;

public class RmiUserPrintStream
extends PrintStream {
    private static final MarkingClassLogger USERID_LOGGER = MarkingClassLogger.forMarkingClass(UserIDLoggingMarker.class);
    private static final String DO_NOT_SHOW_CALLER_FLAG = "hec.rmi.server.doNotShowCaller";
    private PrintStream _out;
    private boolean _showDebug = true;

    public RmiUserPrintStream(PrintStream out) {
        super(out);
        if (Boolean.getBoolean(DO_NOT_SHOW_CALLER_FLAG) || ((MarkingClassLogger.Api)USERID_LOGGER.atFine()).isEnabled()) {
            this._showDebug = false;
        }
    }

    @Override
    public void print(String s) {
        if (this._showDebug) {
            try {
                s = RemoteServer.getClientHost() + ":" + (String)s;
            }
            catch (ServerNotActiveException e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)USERID_LOGGER.atFine()).withCause(e)).log("Cannot prepend client host to the logger");
            }
        }
        super.print((String)s);
    }

    @Override
    public void println() {
        if (this._showDebug) {
            super.println("");
        } else {
            super.println();
        }
    }
}

