/*
 * Decompiled with CFR 0.152.
 */
package hec.server;

import hec.model.FileChangeInfo;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;

public class ServerFileListener
implements FileListener {
    private Map<String, Set<Path>> _listeners = new HashMap<String, Set<Path>>();
    private Map<String, List<FileChangeInfo>> _waitingNotificationMap = new HashMap<String, List<FileChangeInfo>>();
    private DefaultFileMonitor _fileMonitor = new DefaultFileMonitor((FileListener)this);
    private boolean _startedFileMonitor;

    public ServerFileListener() {
        this._fileMonitor.setRecursive(true);
    }

    public void clearAllListenersForUser(String userId) {
        this._listeners.remove(userId);
        this._waitingNotificationMap.remove(userId);
    }

    public synchronized boolean addListener(String userId, String folderPath) {
        FileObject listendir = ServerFileListener.getFileObject(folderPath);
        this._fileMonitor.addFile(listendir);
        System.out.println("addListener:monitoring path " + listendir);
        Path path = Paths.get(folderPath, new String[0]);
        Set<Path> paths = this._listeners.get(userId);
        if (paths == null) {
            paths = new HashSet<Path>();
            this._listeners.put(userId, paths);
        }
        paths.add(path);
        if (!this._startedFileMonitor) {
            System.out.println("addListener:starting file monitor");
            this._startedFileMonitor = true;
            this._fileMonitor.start();
            System.out.println("addListener:starting file monitor...done");
        }
        return true;
    }

    public static FileObject getFileObject(String folderPath) {
        FileObject listendir;
        FileSystemManager fsManager;
        try {
            fsManager = VFS.getManager();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return null;
        }
        File f = new File(folderPath);
        if (!f.exists() && !f.mkdirs()) {
            return null;
        }
        try {
            listendir = fsManager.resolveFile(folderPath);
        }
        catch (FileSystemException e) {
            System.out.println("getFileObject:can't resolve folder " + folderPath + "Error:" + e);
            return null;
        }
        return listendir;
    }

    public boolean removeListener(String userId, String folderPath) {
        List<String> users;
        if (folderPath == null || userId == null) {
            return false;
        }
        Path path = Paths.get(folderPath, new String[0]);
        Set<Path> paths = this._listeners.get(userId);
        if (paths != null) {
            paths.remove(path);
        }
        if ((users = this.getUsersForPath(path)) == null || users.isEmpty()) {
            FileObject listendir = ServerFileListener.getFileObject(folderPath);
            this._fileMonitor.removeFile(listendir);
        }
        return true;
    }

    public List<FileChangeInfo> checkForFileChanges(String userId) {
        List<FileChangeInfo> changedFiles;
        if (this._waitingNotificationMap.size() > 0) {
            System.out.println("checkForFileChanges:checking for changes for " + userId);
        }
        if ((changedFiles = this._waitingNotificationMap.get(userId)) == null) {
            return null;
        }
        this._waitingNotificationMap.remove(userId);
        if (changedFiles.size() > 0) {
            System.out.println("checkForFileChanges:found " + changedFiles);
        }
        return changedFiles;
    }

    public void fileCreated(FileChangeEvent event) {
        this.fileUpdated(event, FileChangeInfo.FileChangeType.FileCreated);
    }

    public void fileDeleted(FileChangeEvent event) {
        this.fileUpdated(event, FileChangeInfo.FileChangeType.FileDeleted);
    }

    public void fileChanged(FileChangeEvent event) {
        this.fileUpdated(event, FileChangeInfo.FileChangeType.FileChanged);
    }

    private void fileUpdated(FileChangeEvent event, FileChangeInfo.FileChangeType fileChangeType) {
        if (event == null) {
            return;
        }
        System.out.println("fileUpdated:" + event);
        Path filePath = this.getFilePath(event);
        if (filePath == null) {
            return;
        }
        System.out.println("fileUpdated:path=" + filePath);
        Path checkPath = filePath;
        List<String> listeners = null;
        do {
            if ((listeners = this.getUsersForPath(checkPath)) != null && !listeners.isEmpty()) continue;
            checkPath = checkPath.getParent();
        } while (listeners.isEmpty() && checkPath != null);
        if (!listeners.isEmpty()) {
            this.addFileWaitingNotification(listeners, filePath, fileChangeType);
        } else {
            this._fileMonitor.removeFile(ServerFileListener.getFileObject(filePath.toString()));
        }
    }

    private void addFileWaitingNotification(List<String> userIds, Path filePath, FileChangeInfo.FileChangeType fileChange) {
        for (int i = 0; i < userIds.size(); ++i) {
            FileChangeInfo info;
            String userId = userIds.get(i);
            List<FileChangeInfo> waitingFiles = this._waitingNotificationMap.get(userId);
            if (waitingFiles == null) {
                waitingFiles = new ArrayList<FileChangeInfo>();
                this._waitingNotificationMap.put(userId, waitingFiles);
            }
            if (waitingFiles.contains(info = new FileChangeInfo(filePath.toString(), fileChange))) continue;
            waitingFiles.add(info);
        }
    }

    private List<String> getUsersForPath(Path filePath) {
        Set<String> keys = this._listeners.keySet();
        Iterator<String> iter = keys.iterator();
        ArrayList<String> userIdsForFile = new ArrayList<String>();
        while (iter.hasNext()) {
            String userId = iter.next();
            Set<Path> files = this._listeners.get(userId);
            if (!files.contains(filePath)) continue;
            userIdsForFile.add(userId);
        }
        return userIdsForFile;
    }

    private Path getFilePath(FileChangeEvent event) {
        Path filePath;
        FileObject file = event.getFile();
        if (file == null) {
            return null;
        }
        try {
            String path = this.cleanPath(file.getURL().getFile());
            filePath = Paths.get(path, new String[0]);
        }
        catch (FileSystemException e) {
            System.out.println("getFilePath:failed to convert FileObject to URL " + e);
            return null;
        }
        if (filePath == null) {
            return null;
        }
        return filePath;
    }

    private String cleanPath(String path) {
        if (path == null) {
            return path;
        }
        while (path.startsWith("/") && path.contains(":")) {
            path = path.substring(1);
        }
        return path;
    }
}

