/*
 * Decompiled with CFR 0.152.
 */
package hec.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class ServerJavaLoggerLoader {
    public static void loadConfiguration() {
        new ServerJavaLoggerLoader();
    }

    public ServerJavaLoggerLoader() {
        String cwmsExe;
        String cwmsHome = System.getProperty("CWMS_HOME");
        String cwmsServerName = System.getProperty("CWMS_SERVER_NAME");
        boolean bLoaded = false;
        if (cwmsHome != null) {
            String loggingFileName;
            String cwmsHomeLogging = cwmsHome + "/config/system_config/";
            if (cwmsServerName != null) {
                loggingFileName = cwmsServerName + "_logging.properties";
                bLoaded = this.loadLogPropFile(loggingFileName = cwmsHomeLogging + loggingFileName);
                if (!bLoaded) {
                    cwmsServerName = cwmsServerName.toLowerCase();
                    loggingFileName = cwmsServerName + "_logging.properties";
                    loggingFileName = cwmsHomeLogging + loggingFileName;
                    bLoaded = this.loadLogPropFile(loggingFileName);
                }
                this.logLoadingSuccess(bLoaded, loggingFileName);
            }
            if (!bLoaded) {
                loggingFileName = cwmsHomeLogging + "cwms_system_logging.properties";
                bLoaded = this.loadLogPropFile(loggingFileName);
                this.logLoadingSuccess(bLoaded, loggingFileName);
            }
        }
        if (!bLoaded && (cwmsExe = System.getProperty("CWMS_EXE")) != null) {
            String cwmsSystemLogging = cwmsExe + "system_config/cwms_system_logging.properties";
            bLoaded = this.loadLogPropFile(cwmsSystemLogging);
            this.logLoadingSuccess(bLoaded, cwmsSystemLogging);
        }
        if (!bLoaded) {
            Logger logger = Logger.getLogger(ServerJavaLoggerLoader.class.getName());
            logger.log(Level.WARNING, "Unable to load a custom logging properties file");
        }
    }

    private void logLoadingSuccess(boolean bSuccess, String fileName) {
        if (bSuccess) {
            Logger logger = Logger.getLogger(ServerJavaLoggerLoader.class.getName());
            logger.log(Level.WARNING, "Logging properties file {0} loaded ", fileName);
        } else {
            Logger logger = Logger.getLogger(ServerJavaLoggerLoader.class.getName());
            logger.log(Level.WARNING, "Failed to load Logging properties file {0} ", fileName);
        }
    }

    private boolean loadLogPropFile(String loggingFileName) {
        boolean bLoaded = false;
        File loggingPropFile = new File(loggingFileName);
        if (loggingPropFile.exists()) {
            try (FileInputStream is = new FileInputStream(loggingPropFile);){
                String message = "Reading logging properties file " + loggingFileName;
                Logger logger = Logger.getLogger(ServerJavaLoggerLoader.class.getName());
                logger.log(Level.WARNING, message);
                LogManager logManager = LogManager.getLogManager();
                logManager.readConfiguration(is);
                bLoaded = true;
            }
            catch (IOException | SecurityException e) {
                String message = "Error loading logging properties file " + loggingFileName;
                Logger logger = Logger.getLogger(ServerJavaLoggerLoader.class.getName());
                logger.log(Level.WARNING, message, e);
            }
        } else {
            String message = "Error logging properties file " + loggingFileName + " does not exist";
            Logger logger = Logger.getLogger(ServerJavaLoggerLoader.class.getName());
            logger.log(Level.WARNING, message);
        }
        return bLoaded;
    }
}

