/*
 * Decompiled with CFR 0.152.
 */
package hec.server;

import com.google.common.flogger.FluentLogger;
import hec.io.FileOffsetError;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;

public class TimeWindowFileReader {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final int DEFAULT_TIMESTAMP_FILE_IDENTIFICATION_LINES = 20;
    private static final int TIMESTAMP_FILE_IDENTIFICATION_LINES = Integer.getInteger("TimeWindowFileReader.identifylogfile.lines", 20);
    private static final Pattern TIME_PATTERN = Pattern.compile("^[0-9][0-9]:[0-9][0-9]:[0-9][0-9]:.+$");
    private static final String TIME_FORMAT = "HH:mm";
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private static final int TIME_FORMAT_LENGTH = "HH:mm".length();
    private static final int NEWLINE_LENGTH = System.lineSeparator().length();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long findStartOffset(File file, String startTimeString) {
        if (file == null) {
            ((FluentLogger.Api)LOGGER.atFine()).log("file is null. returning");
            return FileOffsetError.INVALID_ARGUMENTS.getErrorCode();
        }
        if (startTimeString == null) {
            ((FluentLogger.Api)LOGGER.atFine()).log("start time is null. returning.");
            return FileOffsetError.INVALID_ARGUMENTS.getErrorCode();
        }
        if (startTimeString.isEmpty()) {
            ((FluentLogger.Api)LOGGER.atFine()).log("Start time is empty");
            return FileOffsetError.INVALID_ARGUMENTS.getErrorCode();
        }
        LocalTime start = LocalTime.parse(startTimeString);
        ((FluentLogger.Api)LOGGER.atFine()).log("File %s starting at %s", (Object)file, (Object)start);
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            String line;
            long startOffset = this.findTimeOffset(0L, start, raf);
            ((FluentLogger.Api)LOGGER.atFine()).log("Found start offset: %s", startOffset);
            if (startOffset < 0L) {
                ((FluentLogger.Api)LOGGER.atFine()).log("Start offset is invalid. Abort.");
                long l = startOffset;
                return l;
            }
            long firstDifferentOffset = startOffset;
            long lastDifferentOffset = startOffset;
            long currentLineOffset = startOffset;
            boolean prevDiffLineFound = false;
            while (!prevDiffLineFound) {
                lastDifferentOffset = firstDifferentOffset;
                ((FluentLogger.Api)LOGGER.atFiner()).log("New calcualted offset: %s", firstDifferentOffset -= 2048L);
                if (firstDifferentOffset < 0L) {
                    ((FluentLogger.Api)LOGGER.atFiner()).log("Corrected offset to 0");
                    firstDifferentOffset = 0L;
                }
                if (lastDifferentOffset == 0L && firstDifferentOffset == 0L) {
                    ((FluentLogger.Api)LOGGER.atFiner()).log("Read first line multiple times. Specified time begins at beginning of file.");
                    break;
                }
                ((FluentLogger.Api)LOGGER.atFiner()).log("Seeking back to %s", firstDifferentOffset);
                raf.seek(firstDifferentOffset);
                String partialLine = raf.readLine();
                ((FluentLogger.Api)LOGGER.atFiner()).log("Read partial line %s", (Object)partialLine);
                currentLineOffset = raf.getFilePointer();
                ((FluentLogger.Api)LOGGER.atFiner()).log("Line offset (start of next line): %s", currentLineOffset);
                line = raf.readLine();
                ((FluentLogger.Api)LOGGER.atFiner()).log("Read complete line: %s", (Object)line);
                if (!this.getLineTimeIdentificationPattern().matcher(line).matches()) continue;
                ((FluentLogger.Api)LOGGER.atFiner()).log("Line matches.");
                LocalTime localTime = LocalTime.parse(line.substring(0, this.getTimeFormatLength()), this.getTimeFormatter());
                ((FluentLogger.Api)LOGGER.atFiner()).log("Parsed time %s", (Object)localTime);
                int comparisonResult = localTime.compareTo(start);
                ((FluentLogger.Api)LOGGER.atFiner()).log("Comparison Result: %s", comparisonResult);
                if (comparisonResult == 0) continue;
                prevDiffLineFound = true;
            }
            currentLineOffset = raf.getFilePointer();
            while ((line = raf.readLine()) != null) {
                ((FluentLogger.Api)LOGGER.atFiner()).log("Current line offset %s", currentLineOffset);
                ((FluentLogger.Api)LOGGER.atFiner()).log("Read line %s", (Object)line);
                if (this.getLineTimeIdentificationPattern().matcher(line).matches()) {
                    ((FluentLogger.Api)LOGGER.atFiner()).log("Line matches.");
                    LocalTime localTime = LocalTime.parse(line.substring(0, this.getTimeFormatLength()), this.getTimeFormatter());
                    ((FluentLogger.Api)LOGGER.atFiner()).log("Parsed time %s", (Object)localTime);
                    int comparisonResult = localTime.compareTo(start);
                    ((FluentLogger.Api)LOGGER.atFiner()).log("Comparison result: %s", comparisonResult);
                    if (comparisonResult == 0) {
                        ((FluentLogger.Api)LOGGER.atFiner()).log("Time matches. Returning current line offset %s", currentLineOffset);
                        long l = currentLineOffset;
                        return l;
                    }
                    ((FluentLogger.Api)LOGGER.atFiner()).log("Time doesn't match. Moving to next line.");
                }
                currentLineOffset = raf.getFilePointer();
            }
            long l = FileOffsetError.UNKNOWN.getErrorCode();
            return l;
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log();
            return FileOffsetError.IO_EXCEPTION.getErrorCode();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long findEndOffset(File file, String endTimeString, long fileStartOffset) {
        if (file == null) {
            ((FluentLogger.Api)LOGGER.atFine()).log("file is null. returning");
            return FileOffsetError.INVALID_ARGUMENTS.getErrorCode();
        }
        if (endTimeString == null) {
            ((FluentLogger.Api)LOGGER.atFine()).log("start time is null. returning.");
            return FileOffsetError.INVALID_ARGUMENTS.getErrorCode();
        }
        if (endTimeString.isEmpty()) {
            ((FluentLogger.Api)LOGGER.atFine()).log("Start time is empty");
            return FileOffsetError.INVALID_ARGUMENTS.getErrorCode();
        }
        LocalTime end = LocalTime.parse(endTimeString);
        ((FluentLogger.Api)LOGGER.atFine()).log("File %s ends at %s", (Object)file, (Object)end);
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            String line;
            long endOffset = this.findTimeOffset(fileStartOffset, end, raf);
            ((FluentLogger.Api)LOGGER.atFine()).log("Binary search found offset %s", endOffset);
            if (endOffset < 0L) {
                ((FluentLogger.Api)LOGGER.atFine()).log("Offset is < 0, time not found, returning.");
                long l = endOffset;
                return l;
            }
            ((FluentLogger.Api)LOGGER.atFine()).log("Seeking to offset %s", endOffset);
            raf.seek(endOffset);
            long lastValidOffset = endOffset;
            long currentLineOffset = endOffset;
            while ((line = raf.readLine()) != null) {
                ((FluentLogger.Api)LOGGER.atFiner()).log("Current line offset %s, last valid %s", currentLineOffset, lastValidOffset);
                ((FluentLogger.Api)LOGGER.atFiner()).log("Read line %s", (Object)line);
                if (this.getLineTimeIdentificationPattern().matcher(line).matches()) {
                    ((FluentLogger.Api)LOGGER.atFiner()).log("Line matches.");
                    LocalTime localTime = LocalTime.parse(line.substring(0, this.getTimeFormatLength()), this.getTimeFormatter());
                    ((FluentLogger.Api)LOGGER.atFiner()).log("Parsed time %s", (Object)localTime);
                    int comparisonResult = localTime.compareTo(end);
                    ((FluentLogger.Api)LOGGER.atFiner()).log("Comparison result: %s", comparisonResult);
                    if (comparisonResult != 0) {
                        ((FluentLogger.Api)LOGGER.atFiner()).log("Time doesn't match. Returning end of last line %s", currentLineOffset - (long)this.getNewlineLength());
                        long l = currentLineOffset - (long)this.getNewlineLength();
                        return l;
                    }
                    ((FluentLogger.Api)LOGGER.atFiner()).log("Time matches. Moving to next line.");
                    lastValidOffset = currentLineOffset;
                }
                currentLineOffset = raf.getFilePointer();
            }
            ((FluentLogger.Api)LOGGER.atFine()).log("Hit EoF. Returning end of last line %s", currentLineOffset - (long)this.getNewlineLength());
            long l = currentLineOffset - (long)this.getNewlineLength();
            return l;
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log();
            return FileOffsetError.IO_EXCEPTION.getErrorCode();
        }
    }

    protected long findTimeOffset(long start, LocalTime time, RandomAccessFile randomAccessFile) throws IOException {
        if (!this.isTimestampedFile(randomAccessFile)) {
            ((FluentLogger.Api)LOGGER.atFine()).log("Not a timestamped file.");
            return FileOffsetError.INVALID_ARGUMENTS.getErrorCode();
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("Finding offset for File %s for time %s", (Object)randomAccessFile, (Object)time);
        long startOffset = start;
        if (startOffset < 0L) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("Invalid start parameter %s. Resetting to 0.", start);
            startOffset = 0L;
        }
        long endOffset = randomAccessFile.length() - 1L;
        ((FluentLogger.Api)LOGGER.atFine()).log("Initial end offset is %s, initial start offset is %s", endOffset, startOffset);
        int iterations = 0;
        boolean readNextLine = false;
        while (endOffset > startOffset) {
            ((FluentLogger.Api)LOGGER.atFiner()).log("Starting iteration with start %s end %s", startOffset, endOffset);
            long filePointerPosition = (startOffset + endOffset) / 2L;
            if (readNextLine) {
                ((FluentLogger.Api)LOGGER.atFiner()).log("Reading next line, previous line not valid.");
            } else {
                ((FluentLogger.Api)LOGGER.atFiner()).log("Seeking to new pos: %s", filePointerPosition);
                randomAccessFile.seek(filePointerPosition);
            }
            ((FluentLogger.Api)LOGGER.atFiner()).log("Seeking to start of line");
            String partialLine = randomAccessFile.readLine();
            ((FluentLogger.Api)LOGGER.atFiner()).log("Read possibly incomplete line: %s", (Object)partialLine);
            long beginningOfLinePos = randomAccessFile.getFilePointer();
            ((FluentLogger.Api)LOGGER.atFiner()).log("Advanced to start of line at new pos: %s", beginningOfLinePos);
            String line = randomAccessFile.readLine();
            ((FluentLogger.Api)LOGGER.atFiner()).log("Read line %s", (Object)line);
            if (line == null) {
                return FileOffsetError.EOF.getErrorCode();
            }
            if (this.getLineTimeIdentificationPattern().matcher(line).matches()) {
                readNextLine = false;
                ((FluentLogger.Api)LOGGER.atFiner()).log("Matches TIME_PATTERN");
                LocalTime localTime = LocalTime.parse(line.substring(0, this.getTimeFormatLength()), this.getTimeFormatter());
                ((FluentLogger.Api)LOGGER.atFiner()).log("Parsed time %s", (Object)localTime);
                int comparisonResult = localTime.compareTo(time);
                ((FluentLogger.Api)LOGGER.atFiner()).log("comparisonResult: %s", comparisonResult);
                if (comparisonResult == 0) {
                    ((FluentLogger.Api)LOGGER.atFine()).log("Found position %s in %s iterations", beginningOfLinePos, iterations);
                    return beginningOfLinePos;
                }
                if (comparisonResult >= 1) {
                    endOffset = filePointerPosition - 1L;
                    ((FluentLogger.Api)LOGGER.atFiner()).log("Reversing farther back into the file. New endOffset: %s", endOffset);
                } else {
                    ((FluentLogger.Api)LOGGER.atFiner()).log("Advancing further into the file. New startOffset: %s", startOffset);
                    startOffset = filePointerPosition + 1L;
                }
            } else {
                ((FluentLogger.Api)LOGGER.atFiner()).log("Does NOT match TIME_PATTERN. Skipping to next line.");
                readNextLine = true;
            }
            ++iterations;
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("Terminating search. Start is %s, end is %s. Invalid.", startOffset, endOffset);
        return FileOffsetError.SPECIFIED_DATA_NOT_FOUND.getErrorCode();
    }

    protected boolean isTimestampedFile(RandomAccessFile raf) throws IOException {
        int attempts = this.getTimestampFileIdentficationLineCount();
        if (attempts < 0) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("Invalid number of identification lines(%s). Using %s.", attempts, this.getDefaultTimestampFileIdentificationLineCount());
            attempts = this.getDefaultTimestampFileIdentificationLineCount();
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("Using %s attempts to identify timestamped file.", attempts);
        raf.seek(0L);
        for (int i = 0; i < attempts; ++i) {
            String line = raf.readLine();
            if (line == null) {
                ((FluentLogger.Api)LOGGER.atFine()).log("Hit EOF on iteration %s", i);
                break;
            }
            if (this.getLineTimeIdentificationPattern().matcher(line).matches()) {
                ((FluentLogger.Api)LOGGER.atFine()).log("File is timestamped file on iteration %s", i);
                return true;
            }
            ((FluentLogger.Api)LOGGER.atFiner()).log("Did not find timestamp on iteration %s", i);
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("Not a timestamped file.");
        return false;
    }

    protected int getTimestampFileIdentficationLineCount() {
        return TIMESTAMP_FILE_IDENTIFICATION_LINES;
    }

    protected int getDefaultTimestampFileIdentificationLineCount() {
        return 20;
    }

    protected Pattern getLineTimeIdentificationPattern() {
        return TIME_PATTERN;
    }

    protected DateTimeFormatter getTimeFormatter() {
        return TIME_FORMATTER;
    }

    protected int getTimeFormatLength() {
        return TIME_FORMAT_LENGTH;
    }

    protected int getNewlineLength() {
        return NEWLINE_LENGTH;
    }
}

