/*
 * Decompiled with CFR 0.152.
 */
package hec.supplemental.model;

import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.lang.WorkspaceNameFactory;
import hec.model.ModelConstants;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.ProgramOrderLoggingMarker;

public class ProgramOrderItem
extends NamedType
implements Serializable,
AsciiSerializable,
ModelConstants,
Cloneable {
    private static final MarkingClassLogger PROGRAM_ORDER_LOGGER = MarkingClassLogger.forMarkingClass(ProgramOrderLoggingMarker.class);
    private static List _programOrderItems = new Vector();
    public static final ProgramOrderItem HEC5Q_MODEL = new ProgramOrderItem("HEC5Q", "Water Quality", true, 3);
    public static final ProgramOrderItem RMA2_MODEL = new ProgramOrderItem("RMA2", "Hydrodynamics", true, 3);
    public static final ProgramOrderItem RMA11_MODEL = new ProgramOrderItem("RMA11", "Water Quality", true, 3);
    public static final ProgramOrderItem MFP_MODEL = new ProgramOrderItem("MFP", "Precipitation", true, -1);
    public static final ProgramOrderItem HFP_MODEL = new ProgramOrderItem("HFP", "Hydrologic", true, 1);
    public static final ProgramOrderItem RSS_MODEL = new ProgramOrderItem("RSS", "Reservoir Op.", true, 2);
    public static final ProgramOrderItem RAS_MODEL = new ProgramOrderItem("RAS", "Hydraulics", true, 3);
    public static final ProgramOrderItem FIA_MODEL = new ProgramOrderItem("FIA", "Economics", true, 3);
    public static final ProgramOrderItem RESPRM_MODEL = new ProgramOrderItem("ResPRM", "ResPRM", true, 2);
    public static final int NO_INPUT_SELECTED = -1;
    private boolean _standardModel;
    private String _script;
    private int _inputModelNum = -1;

    public static boolean isStandardModel(String name) {
        name = WorkspaceNameFactory.getWorkspaceName(name);
        List l = ProgramOrderItem.getProgramOrderItems();
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            ProgramOrderItem poi = (ProgramOrderItem)l.get(i);
            if (!name.equalsIgnoreCase(poi.getName())) continue;
            return poi.isStandardModel();
        }
        return name.equalsIgnoreCase("MFP") || name.equalsIgnoreCase("HFP") || name.equalsIgnoreCase("RSS") || name.equalsIgnoreCase("RAS") || name.equalsIgnoreCase("FIA") || name.equalsIgnoreCase("ResPRM") || name.equalsIgnoreCase("rma");
    }

    public ProgramOrderItem() {
    }

    public ProgramOrderItem(String name, boolean standardModel) {
        super(name);
        this._standardModel = standardModel;
    }

    public ProgramOrderItem(String name, String description, boolean standardModel, int input) {
        super(name, description);
        this._standardModel = standardModel;
        this._inputModelNum = input;
    }

    public ProgramOrderItem(ProgramOrderItem poi) {
        super(poi);
        if (poi == null) {
            return;
        }
        this._standardModel = poi._standardModel;
        this._script = poi._script;
    }

    @Override
    public String toString() {
        String name = this.getName();
        if (name.equals("RSS")) {
            return "ResSim";
        }
        if (name.equals("HFP")) {
            return "HMS";
        }
        return this.getName();
    }

    public String paramString() {
        String s = "Name=" + this.getName() + " description=" + this.getDescription() + " standardModel=" + this._standardModel + " ModelPosition=" + this.getIndex() + " inputPosition=" + this._inputModelNum;
        return s;
    }

    public void setStandardModel(boolean b) {
        this._standardModel = b;
    }

    public boolean isStandardModel() {
        return this._standardModel;
    }

    public void setScript(String script) {
        this._script = script;
    }

    public String getScript() {
        return this._script;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProgramOrderItem) {
            return this.equals((ProgramOrderItem)obj);
        }
        return false;
    }

    public boolean equals(ProgramOrderItem that) {
        if (that == this) {
            return true;
        }
        if (that._name.equals(this._name)) {
            if (that._index == -1 || this._index == -1) {
                return true;
            }
            return that._index == this._index;
        }
        return false;
    }

    public int getInputModelNumber() {
        return this._inputModelNum;
    }

    public void setInputModelNumber(int num) {
        this._inputModelNum = num;
    }

    @Override
    public Object clone() {
        try {
            ProgramOrderItem poi = (ProgramOrderItem)super.clone();
            return poi;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static void addProgramOrderItem(ProgramOrderItem poi) {
        if (poi == null) {
            return;
        }
        if (_programOrderItems.contains(poi)) {
            return;
        }
        _programOrderItems.add(poi);
        ((MarkingClassLogger.Api)PROGRAM_ORDER_LOGGER.atFine()).log("Order now: %s", _programOrderItems);
    }

    public static void insertProgramOrderItem(ProgramOrderItem poi, int pos) {
        if (poi == null) {
            return;
        }
        ((MarkingClassLogger.Api)PROGRAM_ORDER_LOGGER.atFine()).log("inserting %s at %s", poi, pos);
        if (_programOrderItems.contains(poi)) {
            ((MarkingClassLogger.Api)PROGRAM_ORDER_LOGGER.atFine()).log("%s already in ProgramOrder", poi);
            return;
        }
        if (pos < 0) {
            pos = 0;
        }
        if (pos > _programOrderItems.size()) {
            ProgramOrderItem.addProgramOrderItem(poi);
        } else {
            _programOrderItems.add(pos, poi);
            ((MarkingClassLogger.Api)PROGRAM_ORDER_LOGGER.atFine()).log("order now: %s", _programOrderItems);
        }
    }

    public static void removeProgramOrderItem(ProgramOrderItem poi) {
        _programOrderItems.remove(poi);
    }

    public static List getProgramOrderItems() {
        Vector l = new Vector(_programOrderItems.size());
        l.addAll(_programOrderItems);
        return l;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    static {
        _programOrderItems.add(RSS_MODEL);
        _programOrderItems.add(RAS_MODEL);
        _programOrderItems.add(FIA_MODEL);
    }
}

