/*
 * Decompiled with CFR 0.152.
 */
package hec.tcu;

import com.google.common.flogger.FluentLogger;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDialog;
import rma.swing.SearchableJEditorPane;
import rma.util.RMAIO;

public abstract class AcknowledgeInterimTermsFileDialog
extends RmaJDialog {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final String INTERIM_TERMS_DIALOG_PREFERENCES_NODE = "InterimNotificationDialog";
    private static final String DONT_SHOW_PROPERTY = "dontShow";
    private static final String OVERRIDE_ACCEPT_INTERIM_TERMS_PROPERTY = "IAcceptInterimTerms";
    private boolean _hasLoaded = false;
    private final Path _tcuFile;
    private JEditorPane _textPane;
    private JCheckBox _dontShowAgainCheck;
    private ButtonCmdPanel _cmdPanel;

    protected AcknowledgeInterimTermsFileDialog(Window parent, String title, Path tcuFile) {
        super(parent, title, true);
        this._tcuFile = tcuFile;
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setSize(570, 350);
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this._textPane = new SearchableJEditorPane();
        this._textPane.setEditable(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)new JScrollPane(this._textPane), gbc);
        this._dontShowAgainCheck = new RmaJCheckBox("Don't show this again");
        this._dontShowAgainCheck.setSelected(!this.shouldShowDialogAtStartup());
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._dontShowAgainCheck, gbc);
        this._cmdPanel = new ButtonCmdPanel(8);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.add((Component)this._cmdPanel, gbc);
    }

    private void addListeners() {
        this._cmdPanel.addCmdPanelListener(e -> {
            if (e.getID() == 8) {
                this.setVisible(false);
            }
        });
        this._textPane.addHyperlinkListener(this::openHyperLink);
    }

    private void openHyperLink(HyperlinkEvent e) {
        HyperlinkEvent.EventType type = e.getEventType();
        if (type != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        URL url = e.getURL();
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(url.toURI());
            }
            catch (IOException | URISyntaxException ex) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)ex)).log("Failed to browse URL!");
            }
        }
    }

    private void loadFile(Path tcuFile) {
        if (!this._hasLoaded) {
            String contentType = this.getContentType(tcuFile);
            this._textPane.setContentType(contentType);
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(tcuFile, new OpenOption[0]));){
                this._textPane.read((InputStream)is, (Object)"TCU file");
                this._hasLoaded = true;
            }
            catch (IOException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Failed to load TCU File!");
            }
        }
    }

    private String getContentType(Path tcuFile) {
        String ext = RMAIO.getFileExtension(tcuFile.toString());
        if ((ext = ext.toLowerCase()).equals(".html")) {
            return "text/html";
        }
        return "text/plain";
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.loadFile(this._tcuFile);
            this.setLocationRelativeTo(this.getParent());
        }
        super.setVisible(visible);
        if (!visible) {
            this.saveShowOption();
        }
    }

    private void saveShowOption() {
        boolean dontShow = this._dontShowAgainCheck.isSelected();
        String version = this.getVersion();
        Preferences prefNode = this.getInterimTermsDialogPreferences(version);
        prefNode.putBoolean(DONT_SHOW_PROPERTY, dontShow);
    }

    private Preferences getInterimTermsDialogPreferences(String appVersion) {
        Preferences applicationPreferences = this.getApplicationPreferenceNode();
        Preferences node = applicationPreferences.node(INTERIM_TERMS_DIALOG_PREFERENCES_NODE);
        return node.node(appVersion);
    }

    protected abstract Preferences getApplicationPreferenceNode();

    public boolean shouldShowDialogAtStartup() {
        String version = this.getVersion();
        Preferences prefNode = this.getInterimTermsDialogPreferences(version);
        boolean dontShow = prefNode.getBoolean(DONT_SHOW_PROPERTY, false);
        boolean doNotShowOverride = Boolean.getBoolean(OVERRIDE_ACCEPT_INTERIM_TERMS_PROPERTY);
        return !dontShow && !doNotShowOverride;
    }

    public String getVersion() {
        String shortVersion = this.getAppVersionProperties().getProperty("shortVersion");
        String lowerShortVersion = shortVersion.toLowerCase();
        int idx = lowerShortVersion.indexOf("beta");
        int idx2 = lowerShortVersion.indexOf("alpha");
        String version = shortVersion;
        if (idx > -1) {
            version = shortVersion.substring(0, idx);
        } else if (idx2 > -1) {
            version = shortVersion.substring(0, idx2);
        }
        return version;
    }

    protected abstract Properties getAppVersionProperties();
}

