/*
 * Decompiled with CFR 0.152.
 */
package hec.tcu;

import hec.tcu.AcknowledgeInterimTermsFileDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.AbstractAction;

public abstract class CheckForInterimTermsAction
extends AbstractAction {
    private static final String BETA_TOC_FILE_NAME = "Interim Software Release Terms and Conditions.html";
    private static final String TITLE = "Interim Release Terms and Conditions...";
    private AcknowledgeInterimTermsFileDialog _dialog;

    protected CheckForInterimTermsAction(Window parent) {
        super(TITLE);
        Path tocFile = this.getInterimTermsFilepath();
        this._dialog = this.createDialog(parent, TITLE, tocFile);
        this.setEnabled(this.betaFileExists());
    }

    protected abstract AcknowledgeInterimTermsFileDialog createDialog(Window var1, String var2, Path var3);

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showIfFileExists();
    }

    public void showIfAppropriate() {
        if (this._dialog.shouldShowDialogAtStartup()) {
            this.showIfFileExists();
        }
    }

    public void showIfFileExists() {
        if (this.betaFileExists()) {
            this._dialog.setVisible(true);
        }
    }

    public boolean betaFileExists() {
        return Files.exists(this.getInterimTermsFilepath(), new LinkOption[0]);
    }

    protected Path getInterimTermsFilepath() {
        String installDir = System.getProperty("user.dir");
        Path tocFile = Paths.get(installDir, BETA_TOC_FILE_NAME);
        return tocFile;
    }
}

