/*
 * Decompiled with CFR 0.152.
 */
package hec.tcu;

import hec.tcu.TcuInfo;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.print.DocumentRenderer;

public class TcuDialog
extends RmaJDialog {
    protected JLabel _pleaseReadLabel;
    protected JEditorPane _tcuText;
    protected ButtonCmdPanel _cmdPanel;
    boolean canceled = false;
    protected JScrollPane _tcuScrollPane;
    private Dimension _size = new Dimension(440, 336);

    public TcuDialog(Dialog parent, TcuInfo info) {
        super(parent, true);
        this.buildControls(info);
        this.setSize(440, 336);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public TcuDialog(Frame parent, TcuInfo info) {
        super(parent, true);
        this.buildControls(info);
        this.setSize(440, 336);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return this._size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this._size;
    }

    protected void buildControls(TcuInfo info) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(info.getTitle());
        GridBagConstraints gbc = new GridBagConstraints();
        this._pleaseReadLabel = new JLabel("Please read the following TCU carefully");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        Font font = this._pleaseReadLabel.getFont();
        font = new Font(font.getName(), 0, 14);
        this._pleaseReadLabel.setFont(font);
        this.getContentPane().add((Component)this._pleaseReadLabel, gbc);
        this._tcuText = new JEditorPane(info.getMimeType(), info.getText());
        this._tcuText.setEditable(false);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this._tcuScrollPane = new JScrollPane(this._tcuText);
        this.getContentPane().add((Component)this._tcuScrollPane, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)panel, gbc);
        JButton printButton = new JButton("Print");
        printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TcuDialog.this.printTcu();
            }
        });
        printButton.setIcon(null);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipadx = 28;
        panel.add((Component)printButton, gbc);
        this._cmdPanel = new ButtonCmdPanel(this.getCmdPanelOptions());
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.ipadx = 0;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        panel.add((Component)this._cmdPanel, gbc);
        this._cmdPanel.addCmdPanelListener(this.createCmdPanelListener());
        try {
            this._tcuText.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Dimension getSize() {
        return new Dimension(440, 336);
    }

    protected ButtonCmdPanelListener createCmdPanelListener() {
        return new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 256: {
                        TcuDialog.this.setVisible(false);
                    }
                }
            }
        };
    }

    protected void printTcu() {
        DocumentRenderer renderer = new DocumentRenderer();
        renderer.print(this._tcuText);
    }

    protected int getCmdPanelOptions() {
        return 256;
    }
}

