/*
 * Decompiled with CFR 0.152.
 */
package hec.tcu;

import hec.tcu.TcuInfoAbout;
import hec.tcu.TcuInfoAccept;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;

public class TcuInfo {
    private static final String ACCEPT_TCU_FILE = "hec/tcu/hecAgreeTcu.html";
    private static final String ABOUT_TCU_FILE = "hec/tcu/hecAboutTcu.html";
    public static final int TCU_READ = 1;
    public static final int TCU_UNDREAD = 0;
    public static final int TCU_ABOUT = 0;
    public static final int TCU_ACCEPT = 1;
    private String _title;
    private String _text;
    private String _mimeType;
    protected String _filename;

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public void setText(String text) {
        this._text = text;
    }

    public void setMimeType(String mimeType) {
        this._mimeType = mimeType;
    }

    public String getText() {
        return this._text;
    }

    public String getMimeType() {
        String file;
        if (this._mimeType == null && (file = this.getTcuFilename()) != null) {
            if (file.endsWith("htm") || file.endsWith("html")) {
                return "text/html";
            }
            if (file.endsWith("rtf")) {
                return "text/rtf";
            }
            return "text/plain";
        }
        return this._mimeType;
    }

    public static TcuInfo getTcuInfo(int type) {
        TcuInfo info;
        block29: {
            info = null;
            if (type == 0) {
                info = new TcuInfoAbout(ABOUT_TCU_FILE);
            } else if (type == 1) {
                info = new TcuInfoAccept(ACCEPT_TCU_FILE);
            } else {
                throw new IllegalArgumentException("Argument TCU type: " + type + " is invalid");
            }
            info.setTitle("Terms and Conditions for Use (TCU)");
            String filename = info.getTcuFilename();
            if (filename != null) {
                if (filename.endsWith(".rtf")) {
                    info.setMimeType("text/rtf");
                } else if (filename.endsWith(".html") || filename.endsWith(".htm")) {
                    info.setMimeType("text/html");
                } else {
                    info.setMimeType("text/plain");
                }
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);){
                    if (is == null) break block29;
                    try (InputStreamReader inputStreamReader = new InputStreamReader(is);
                         BufferedReader reader = new BufferedReader(inputStreamReader);){
                        String line;
                        StringBuilder builder = new StringBuilder(1024);
                        while ((line = reader.readLine()) != null) {
                            builder.append(line);
                            builder.append("\n");
                        }
                        info.setText(builder.toString());
                    }
                }
                catch (IOException e) {
                    System.out.println("getTcuInfo:IOException " + e);
                    e.printStackTrace();
                }
            } else {
                info.setMimeType("text/plain");
                info.setText("your terms and conditions here");
            }
        }
        return info;
    }

    protected String getTcuFilename() {
        return this._filename;
    }

    public void setAppName(String appName) {
        if (appName != null) {
            this._text = this.getText();
            MessageFormat fmt = new MessageFormat(this._text);
            this.setText(fmt.format(new String[]{appName, appName}));
        }
        if (this._title != null) {
            this._title = appName + " " + this._title;
        }
    }
}

