/*
 * Decompiled with CFR 0.152.
 */
package hec.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileHunter {
    boolean verbose = false;
    long starthunt;
    long lasthunt;
    Vector cmwsPropertyKeys = new Vector();
    Vector cwmsPropertyValues = new Vector();
    File inputFile = null;
    FileReader inputFileReader = null;
    BufferedReader inputBufferedReader = null;
    File logFile = null;
    boolean logfilelineread = false;
    FileWriter logFileWriter = null;
    BufferedWriter logBufferedWriter = null;
    BufferedWriter listBufferedWriter = null;
    ZipOutputStream zipout = null;
    Vector zipContents = null;
    HuntList huntListHead = null;
    ThreadList threadListHead = null;
    float repeatinterval = 0.0f;
    int spawnedjobs;
    ThreadList lastJob = null;
    int totaldirs = 0;
    int totalfiles = 0;
    int totalothers = 0;
    int totalmatches = 0;
    int fileexceptions = 0;
    int listedfiles = 0;
    int movedfiles = 0;
    int deletedfiles = 0;
    int zippedfiles = 0;
    int dirswithamatch = 0;
    int threadsMade = 0;
    int commandsrun = 0;
    int skipdirs = 0;
    int skipfiles = 0;
    boolean version1dot2 = false;
    static final long ONE_DAY = 86400000L;
    static final int MAX_HUNTS = -9999;
    static final int MAX_EXEC = 999;
    static final int MAX_JOB_TIME = 120;
    static final boolean DEBUGGING = false;
    static final float MISSING_VALUE = -9999.0f;

    public FileHunter() {
        this.starthunt = System.currentTimeMillis();
        String jversion = System.getProperty("java.version", "0.0");
        if (jversion.charAt(0) > '1' || jversion.charAt(0) == '1' && jversion.length() > 2 && jversion.charAt(2) > '1') {
            this.version1dot2 = true;
        }
    }

    public static void main(String[] args) {
        FileHunter fileHunter = new FileHunter();
        fileHunter.doit(args);
    }

    public void doit(String[] args) {
        this.lasthunt = this.starthunt;
        int numhunts = 0;
        Date huntDate = null;
        FileWriter listFileWriter = null;
        if (args.length != 1) {
            this.usage();
        }
        try {
            Enumeration<?> keys = System.getProperties().propertyNames();
            while (keys.hasMoreElements()) {
                this.cmwsPropertyKeys.addElement(keys.nextElement());
                if (this.cmwsPropertyKeys.elementAt(this.cmwsPropertyKeys.size() - 1).toString().startsWith("CWMS") || this.cmwsPropertyKeys.elementAt(this.cmwsPropertyKeys.size() - 1).toString().startsWith("CWMS")) {
                    this.cwmsPropertyValues.addElement(System.getProperty((String)this.cmwsPropertyKeys.elementAt(this.cmwsPropertyKeys.size() - 1)));
                    continue;
                }
                this.cmwsPropertyKeys.removeElementAt(this.cmwsPropertyKeys.size() - 1);
            }
            if (this.cmwsPropertyKeys.isEmpty()) {
                System.out.println("No replaceable Strings found!");
            } else if (this.verbose) {
                for (int n = 0; n < this.cmwsPropertyKeys.size(); ++n) {
                    System.out.println("Replace string " + this.cmwsPropertyKeys.elementAt(n) + " with " + this.cwmsPropertyValues.elementAt(n));
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            this.adios(-5);
        }
        this.inputFile = new File(args[0]);
        this.readInput(this.inputFile);
        while (true) {
            int i = 0;
            HuntList hl = this.huntListHead;
            while (hl != null) {
                huntDate = new Date(this.lasthunt);
                this.logit("");
                this.logit("Starting search at " + huntDate.toString());
                this.logit(" Now processing for hunt " + ++i);
                this.logit("   input line: " + hl.inputline);
                this.fileexceptions = 0;
                this.listedfiles = 0;
                this.movedfiles = 0;
                this.totalmatches = 0;
                this.deletedfiles = 0;
                this.commandsrun = 0;
                this.zippedfiles = 0;
                this.dirswithamatch = 0;
                if (hl.listfile != null) {
                    try {
                        listFileWriter = new FileWriter(hl.listfile.getAbsolutePath(), true);
                        this.listBufferedWriter = new BufferedWriter(listFileWriter);
                        this.logit("# Results from search at " + huntDate.toString());
                    }
                    catch (Exception e) {
                        System.err.println(e.toString());
                        this.logit(" Unable to open " + hl.listfile.getAbsolutePath() + " for APPEND");
                        this.adios(-6);
                    }
                }
                if (hl.zipfilename == null) {
                    this.zipout = null;
                } else {
                    boolean okforappend = false;
                    File tmpzip = null;
                    try {
                        File zf = new File(hl.zipfilename);
                        if (zf.exists()) {
                            if (this.verbose) {
                                this.logit(" Opening existing zip file for append: " + zf.getAbsolutePath());
                            }
                            if (!zf.renameTo(tmpzip = new File(zf.getPath() + "$"))) {
                                this.logit(" Unable to rename " + hl.zipfilename + " to " + tmpzip.getAbsolutePath());
                                this.logit(" So can not append to it.");
                                this.zipout = null;
                            } else {
                                ZipEntry e;
                                ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(tmpzip)));
                                this.zipout = new ZipOutputStream(new FileOutputStream(hl.zipfilename));
                                this.zipContents = new Vector();
                                byte[] b = new byte[512];
                                while ((e = zin.getNextEntry()) != null) {
                                    try {
                                        this.zipout.putNextEntry(e);
                                        this.zipContents.addElement(e.getName());
                                        int len = 0;
                                        while ((len = zin.read(b)) != -1) {
                                            this.zipout.write(b, 0, len);
                                        }
                                    }
                                    catch (ZipException ze) {
                                        this.logit(" Omitting file " + e.getName(), true);
                                        this.logit(ze.toString(), true);
                                    }
                                }
                                zin.close();
                                if (this.verbose) {
                                    this.logit("Successfully opened for append.");
                                }
                                okforappend = true;
                                if (!tmpzip.delete()) {
                                    this.logit("Unable to delete temporary zip file: " + zf.getAbsolutePath(), true);
                                }
                            }
                        } else {
                            if (this.verbose) {
                                this.logit(" Creating zip file " + zf.getAbsolutePath());
                            }
                            this.zipout = new ZipOutputStream(new FileOutputStream(hl.zipfilename));
                            this.zipContents = null;
                        }
                    }
                    catch (Exception e) {
                        this.logit(" Unable to open " + hl.zipfilename, true);
                        if (tmpzip != null) {
                            this.logit(" Failed trying to re-write the existing zip file", true);
                            this.logit(" Original version has been renamed to " + tmpzip.getAbsolutePath(), true);
                        }
                        this.logit(e.toString(), true);
                        this.adios(-6);
                    }
                }
                if (!hl.allroots) {
                    this.exploreDir(hl.dir, hl, 2);
                }
                if (hl.listfile != null) {
                    try {
                        this.listBufferedWriter.flush();
                        this.listBufferedWriter.close();
                        this.listBufferedWriter = null;
                        listFileWriter.close();
                    }
                    catch (Exception e) {
                        this.logit("Problem flushing and closing list file: " + hl.listfile.getAbsolutePath(), true);
                        this.logit(e.toString(), true);
                        this.adios(-6);
                    }
                }
                if (this.zipout != null) {
                    try {
                        try {
                            this.zipout.close();
                            this.zipout = null;
                        }
                        catch (ZipException ze) {
                            File junkit;
                            if (this.zippedfiles == 0 && (junkit = new File(hl.zipfilename)).length() == 0L) {
                                junkit.delete();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logit("Problem closing zip file: " + hl.zipfilename, true);
                        this.logit(e.toString(), true);
                        this.adios(-6);
                    }
                }
                this.logit(this.totalmatches + " files matched criteria (in " + this.dirswithamatch + " different directories)");
                this.logit(this.fileexceptions + " exceptions encountered");
                this.logit(this.listedfiles + " files listed");
                this.logit(this.commandsrun + " system commands executed");
                this.logit(this.movedfiles + " files moved");
                this.logit(this.zippedfiles + " files zipped");
                this.logit(this.deletedfiles + " files deleted");
                hl = hl.next;
            }
            if (this.repeatinterval < 1.0E-6f) break;
            if ((float)this.lasthunt + this.repeatinterval * 8.64E7f < (float)System.currentTimeMillis()) {
                this.logit("Oops.  Repeat time is shorter than  time it takes to perform the search!", true);
                this.logit("Shutting down while you see if there is anything unexpected going on.", true);
                this.adios(-4);
            }
            this.logit(" ");
            this.logit("Elapsed time: " + (float)(System.currentTimeMillis() - this.lasthunt) / 1000.0f + " seconds");
            this.logit(" Threads still alive: " + this.relinkThreadList());
            if (++numhunts == -9999) break;
            this.logit("Sleeping until " + new Date(this.lasthunt + (long)(this.repeatinterval * 8.64E7f)).toString() + " . . . ");
            try {
                if (this.logBufferedWriter != null) {
                    this.logBufferedWriter.flush();
                    this.logBufferedWriter.close();
                    this.logBufferedWriter = null;
                    this.logFileWriter.close();
                }
                Thread.currentThread();
                Thread.sleep(this.lasthunt + (long)(this.repeatinterval * 8.64E7f) - System.currentTimeMillis());
                if (this.logFile != null && !this.initLogFile()) {
                    System.err.println("Unable to write to log file: " + this.logFile.getAbsolutePath());
                    this.adios(-8);
                }
                if (this.verbose) {
                    this.logit(" . . . done sleeping.  Time to do another hunt.");
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
                this.adios(-4);
            }
            this.lasthunt += (long)(this.repeatinterval * 8.64E7f);
            this.logit(" Threads still alive: " + this.relinkThreadList());
        }
        this.adios(0);
    }

    public void exploreDir(File dirObj, HuntList hunt, int tabstoindent) {
        String[] dirContents = null;
        String indent = "";
        Object tmpstr = null;
        boolean thisdirhasmatches = false;
        for (int j = 0; j < tabstoindent; ++j) {
            indent = indent.concat("    ");
        }
        ++this.totaldirs;
        try {
            if (this.verbose) {
                this.logit("    ... searching directory " + dirObj.getAbsolutePath());
            }
            dirContents = dirObj.list(hunt.customFilter);
        }
        catch (Exception e) {
            ++this.fileexceptions;
            this.logit("Unable to search directory: " + dirObj.getAbsolutePath() + "!", true);
            this.logit(e.toString(), true);
            return;
        }
        if (dirContents == null || dirContents.length == 0) {
            if (this.verbose) {
                this.logit(indent + "no matches found in " + dirObj.getAbsolutePath());
            }
            return;
        }
        if (hunt.similarfilestokeep > 0) {
            long[] fa = new long[dirContents.length];
            int[] listpos = new int[dirContents.length];
            File fo = null;
            for (int k = 0; k < dirContents.length; ++k) {
                listpos[k] = k;
                fo = new File(dirObj, dirContents[k]);
                try {
                    if (fo.isFile()) {
                        fa[k] = fo.lastModified();
                        continue;
                    }
                    fa[k] = -1L;
                    continue;
                }
                catch (Exception e) {
                    this.logit("Unable to determine age of " + dirContents[k] + "!", true);
                    this.logit("Will consider it to be old.", true);
                    this.logit(e.toString(), true);
                    fa[k] = 0L;
                }
            }
            int indexofnewer = 0;
            for (int k = 0; k < fa.length - 1; ++k) {
                for (int m = k + 1; m < fa.length; ++m) {
                    if (fa[listpos[m]] <= fa[listpos[k]]) continue;
                    indexofnewer = listpos[m];
                    listpos[m] = listpos[k];
                    listpos[k] = indexofnewer;
                }
            }
            int fileskept = 0;
            for (int k = 0; fileskept < hunt.similarfilestokeep && k < fa.length; ++k) {
                if (fa[listpos[k]] > 0L) {
                    thisdirhasmatches = true;
                    this.logit("Striking " + dirContents[listpos[k]] + " from list of files to process (inside keeper limit of " + hunt.similarfilestokeep + " files).");
                    dirContents[listpos[k]] = "";
                    ++fileskept;
                    continue;
                }
                if (!this.verbose || fa[listpos[k]] == -1L) continue;
                this.logit("Leaving " + dirContents[listpos[k]] + " in list of files to process (outside keeper limit of " + hunt.similarfilestokeep + " files).");
            }
        }
        for (int i = 0; i < dirContents.length; ++i) {
            if (dirContents[i].length() == 0) continue;
            File dirEntry = new File(dirObj, dirContents[i]);
            if (this.verbose) {
                this.logit(indent + "acting on " + dirEntry.getAbsolutePath());
            }
            try {
                if (dirEntry.isDirectory()) {
                    if (!hunt.recursive) continue;
                    this.exploreDir(dirEntry, hunt, tabstoindent + 1);
                    if (!this.verbose) continue;
                    this.logit(indent + "  . . . resuming search through directory " + dirObj.getAbsolutePath());
                    continue;
                }
            }
            catch (Exception e) {
                ++this.fileexceptions;
                this.logit("Unable to access " + dirContents[i] + "!", true);
                this.logit(e.toString(), true);
            }
            thisdirhasmatches = true;
            boolean deletable = true;
            if (this.listBufferedWriter != null) {
                String finfo = null;
                if (this.verbose) {
                    this.logit("listing it in " + hunt.listfile.getAbsolutePath() + " . . . ");
                }
                try {
                    finfo = dirEntry.getAbsolutePath() + "\t" + dirEntry.length() + " bytes\t" + new Date(dirEntry.lastModified()).toString();
                }
                catch (Exception e) {
                    finfo = dirEntry.getAbsolutePath() + "\tNA bytes NA";
                }
                try {
                    this.listBufferedWriter.write(finfo);
                    this.listBufferedWriter.newLine();
                    ++this.listedfiles;
                }
                catch (Exception e) {
                    System.err.println("Unable to write to list file!");
                    System.err.println(e.toString());
                    deletable = false;
                }
                this.logit("===> new entry in " + hunt.listfile.getAbsolutePath() + ": " + finfo);
            }
            if (this.zipout != null) {
                boolean alreadyzipped = false;
                if (this.zipContents != null) {
                    for (int jj = 0; jj < this.zipContents.size() && !alreadyzipped; ++jj) {
                        if (this.zipContents.elementAt(jj).toString().compareTo(dirEntry.getAbsolutePath()) != 0) continue;
                        alreadyzipped = true;
                    }
                }
                if (alreadyzipped) {
                    this.logit("===> Not zipping because entry already exists: " + dirEntry.getAbsolutePath(), true);
                } else {
                    try {
                        int len;
                        if (this.verbose) {
                            this.logit("zipping it in " + hunt.zipfilename + " . . . ");
                        }
                        FileInputStream in = new FileInputStream(dirEntry);
                        this.zipout.putNextEntry(new ZipEntry(dirEntry.getAbsolutePath()));
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) > 0) {
                            this.zipout.write(buf, 0, len);
                        }
                        in.close();
                    }
                    catch (Exception e) {
                        this.logit("===> Unable to zip " + dirEntry.getAbsolutePath(), true);
                        this.logit(e.toString(), true);
                        deletable = false;
                        try {
                            this.zipout.closeEntry();
                        }
                        catch (IOException buf) {
                            // empty catch block
                        }
                    }
                    if (deletable) {
                        this.logit("===> new entry in " + hunt.zipfilename + ": " + dirEntry.getAbsolutePath());
                        ++this.zippedfiles;
                    }
                }
            }
            if (hunt.syscommand != null) {
                tmpstr = hunt.syscommand;
                int bp = 0;
                while ((bp = ((String)tmpstr).indexOf("$FILE", bp)) >= 0) {
                    tmpstr = ((String)tmpstr).substring(0, bp) + dirEntry.getAbsolutePath() + ((String)tmpstr).substring(bp + 5);
                }
                this.logit("===> spawning job: " + (String)tmpstr);
                SystemCall sysCommand = new SystemCall((String)tmpstr, hunt);
                if (++this.threadsMade == 999) {
                    System.err.println("Too many jobs are running!");
                    deletable = false;
                }
                ++this.commandsrun;
                this.lastJob = new ThreadList(this.lastJob, sysCommand);
                ++this.spawnedjobs;
            }
            if (hunt.destdir != null) {
                File newpath = new File(hunt.destdir, dirEntry.getAbsolutePath().replace(File.separatorChar, '+').replace(':', '+'));
                String messfrag = dirEntry.getAbsolutePath() + " to " + newpath.getAbsolutePath();
                try {
                    if (dirEntry.renameTo(newpath)) {
                        this.logit("===> moved " + messfrag);
                        ++this.movedfiles;
                    } else {
                        byte[] buf = new byte[1024];
                        int bi = 0;
                        FileInputStream fis = new FileInputStream(dirEntry);
                        FileOutputStream fos = new FileOutputStream(newpath);
                        while ((bi = fis.read(buf)) != -1) {
                            fos.write(buf, 0, bi);
                        }
                        fis.close();
                        fos.close();
                        if (newpath.length() == dirEntry.length()) {
                            if (dirEntry.delete()) {
                                this.logit("===> moved " + messfrag);
                            } else {
                                this.logit("===> Unable to move " + messfrag, true);
                                this.logit("===> Made a copy, but unable to delete the original.", true);
                            }
                        } else {
                            this.logit("===> Unable to move " + messfrag, true);
                            this.logit("Copy failed.", true);
                            deletable = false;
                        }
                    }
                }
                catch (Exception e) {
                    this.logit("===> Unable to move " + messfrag, true);
                    this.logit(e.toString(), true);
                    deletable = false;
                }
            }
            if (!hunt.delete) continue;
            if (deletable) {
                try {
                    if (dirEntry.delete()) {
                        this.logit("===> deleted " + dirEntry.getAbsolutePath());
                        ++this.deletedfiles;
                        continue;
                    }
                    this.logit("===> Unable to delete " + dirEntry.getAbsolutePath(), true);
                }
                catch (Exception e) {
                    this.logit("===> Unable to delete " + dirEntry.getAbsolutePath(), true);
                    this.logit(e.toString(), true);
                }
                continue;
            }
            this.logit("===> Due to failure of an earlier action, will not delete " + dirEntry.getAbsolutePath(), true);
        }
        if (thisdirhasmatches) {
            ++this.dirswithamatch;
        }
    }

    public void usage() {
        System.err.println("Usage:");
        System.err.println("   java {-DCWMS_XXXX=double_quoted_string} FileHunter <inputfile>");
        this.adios(-5);
    }

    public void readInput(File inputFile) {
        Object inline = "";
        HuntList huntListTail = null;
        Object tmpFloat = null;
        int numsemicolons = 0;
        try {
            if (!inputFile.exists()) {
                System.err.println("Specified input file not found: " + inputFile.getAbsolutePath());
                this.adios(-2);
            }
            if (!inputFile.isFile()) {
                System.err.println("Specified pathname is not a regular file: " + inputFile.getAbsolutePath());
                this.adios(-2);
            }
            this.inputFileReader = new FileReader(inputFile);
            this.inputBufferedReader = new BufferedReader(this.inputFileReader);
            int linenum = 0;
            while ((inline = this.inputBufferedReader.readLine()) != null) {
                ++linenum;
                if (((String)(inline = ((String)inline).trim())).length() == 0) continue;
                this.logit("   > " + (String)inline);
                if (((String)inline).charAt(0) == '#') continue;
                for (int rv = 0; rv < this.cmwsPropertyKeys.size(); ++rv) {
                    int bp = 0;
                    while ((bp = ((String)inline).indexOf("$" + (String)this.cmwsPropertyKeys.elementAt(rv), bp)) >= 0) {
                        inline = ((String)inline).substring(0, bp) + this.cwmsPropertyValues.elementAt(rv) + ((String)inline).substring(bp + ("$" + (String)this.cmwsPropertyKeys.elementAt(rv)).length());
                    }
                }
                numsemicolons = 0;
                for (int i = 0; i < ((String)inline).length(); ++i) {
                    if (((String)inline).charAt(i) != ';') continue;
                    ++numsemicolons;
                }
                if (numsemicolons >= 4) {
                    huntListTail = new HuntList(huntListTail, ((String)inline).trim(), linenum);
                    continue;
                }
                if (((String)inline).toLowerCase().startsWith("verb")) {
                    this.verbose = true;
                    this.logit("Verbose is ON");
                    continue;
                }
                if (((String)inline).toLowerCase().startsWith("repeat")) {
                    this.repeatinterval = this.parseTime(this.getParameter(':', (String)inline));
                    if (this.repeatinterval == -9999.0f) {
                        this.readError("Unable to read repeat interval.", (String)inline, linenum, -2);
                    }
                    this.logit("Repeating search every " + this.repeatinterval + " days.");
                    continue;
                }
                if (((String)inline).toLowerCase().startsWith("logfile")) {
                    this.logFile = new File(this.getParameter(':', (String)inline));
                    this.logfilelineread = true;
                    if (this.initLogFile()) continue;
                    this.readError("Unable to initialize user-specified log file!", (String)inline, linenum, -1);
                    continue;
                }
                if (numsemicolons > 1) {
                    this.readError("Not enough fields found in input line!", (String)inline, linenum, -2);
                    continue;
                }
                this.readError("Unrecognized input line!", (String)inline, linenum, -2);
            }
            this.inputFileReader.close();
            this.inputBufferedReader.close();
        }
        catch (Exception e) {
            this.logit("Problem while reading input file: " + inputFile.getAbsolutePath() + "!", true);
            this.logit(e.toString(), true);
            this.adios(-2);
        }
        if (huntListTail == null) {
            this.logit("No search criteria found!  What's happening here?", true);
            this.adios(-2);
        }
        if (this.logBufferedWriter == null && !this.initLogFile()) {
            this.logit("Unable to initialize log file using default name.", true);
            this.adios(-2);
        }
        this.huntListHead = huntListTail.head;
    }

    boolean initLogFile(String logFileName) {
        boolean newlog = false;
        if (this.logFile == null || !logFileName.endsWith(this.logFile.getName())) {
            newlog = true;
        }
        this.logFile = new File(logFileName);
        try {
            if (this.logFile.exists()) {
                if (!this.logFile.isFile()) {
                    this.logit("Specified pathname is not a regular file: " + this.logFile.getAbsolutePath(), true);
                    return false;
                }
                if (!this.logFile.canWrite()) {
                    this.logit("Unable to write to specified log file: " + this.logFile.getAbsolutePath(), true);
                    return false;
                }
                if (this.verbose) {
                    System.out.println("Appending to existing log file: " + this.logFile.getAbsolutePath());
                }
            }
            this.logFileWriter = new FileWriter(this.logFile.getAbsolutePath(), true);
            this.logBufferedWriter = new BufferedWriter(this.logFileWriter);
            this.logBufferedWriter.newLine();
            this.logit("=======");
            this.logit("Log (this) file: " + this.logFile.getAbsolutePath());
            this.logit("Log file opened at " + new Date().toString());
            if (newlog) {
                this.dumpInfo();
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    boolean initLogFile() {
        String deflog = null;
        try {
            if (this.logfilelineread && !this.logFile.isDirectory()) {
                return this.initLogFile(this.logFile.getAbsolutePath());
            }
            long day0 = System.currentTimeMillis();
            SimpleDateFormat dow = new SimpleDateFormat("E");
            dow.setTimeZone(TimeZone.getTimeZone("UTC"));
            while (!dow.format(new Date(day0)).startsWith("Sun")) {
                day0 -= 86400000L;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            deflog = "filehunter.wk." + sdf.format(new Date(day0)) + ".utc";
            if (!this.logfilelineread) {
                return this.initLogFile(deflog);
            }
            if (!this.logFile.isDirectory() || !this.logFile.exists()) {
                System.err.println("Weird problem with directory for log file: " + this.logFile.getAbsolutePath());
                return false;
            }
            if (!this.logFile.canWrite()) {
                System.err.println("Unable to write to directory for log file: " + this.logFile.getAbsolutePath());
                return false;
            }
        }
        catch (Exception e) {
            System.err.println("Unable to initialize log file:" + this.logFile.getAbsolutePath());
            System.err.println(e.toString());
            return false;
        }
        return this.initLogFile(new File(this.logFile, deflog).getAbsolutePath());
    }

    public void dumpInfo() {
        this.logit("Input file: " + this.inputFile.getAbsolutePath());
        this.logit("FileHunter running since " + new Date(this.starthunt).toString());
        if (this.verbose) {
            this.logit("System.getProperties output:");
            PrintWriter tpw = new PrintWriter(this.logBufferedWriter);
            System.getProperties().list(tpw);
            tpw.flush();
            this.logit("");
        }
        this.logit("Hunt Criteria:");
        this.logit(". . . will repeat file searches every " + this.repeatinterval + " days (" + this.repeatinterval * 24.0f + " hours).");
        int j = 0;
        int i = 0;
        String[] dirstring = new String[]{"", " (recursive)"};
        HuntList hl = this.huntListHead;
        while (hl != null) {
            j = 0;
            this.logit("");
            this.logit(" Hunt " + ++i + ":");
            this.logit(" input line: " + hl.inputline);
            if (hl.recursive) {
                j = 1;
            }
            if (hl.allroots) {
                this.logit("   search whole filesystem" + dirstring[j]);
            } else {
                this.logit("   search " + hl.dir.getAbsolutePath() + dirstring[j]);
            }
            this.logit("   fitting filemask of " + hl.customFilter.filemask);
            if (hl.similarfilestokeep > 0) {
                this.logit("   except for the " + hl.similarfilestokeep + " most recently modified (per directory)");
            } else {
                this.logit("   at least " + hl.customFilter.daysold + " days old");
            }
            this.logit("   actions to take:");
            if (hl.listfile != null) {
                this.logit("     list matches in file " + hl.listfile);
            }
            if (hl.destdir != null) {
                this.logit("     move matches to directory " + hl.destdir.getAbsolutePath());
            }
            if (hl.syscommand != null) {
                this.logit("     run command " + hl.syscommand);
            }
            if (hl.delete) {
                this.logit("     attempt deletion");
            }
            hl = hl.next;
        }
    }

    public void readError(String message, String inputline, int linenum, int exitcode) {
        try {
            if (this.logBufferedWriter != null) {
                this.logBufferedWriter.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logit("   STOP!", true);
        this.logit("   Error reading input.", true);
        this.logit(message, true);
        this.logit("Error occurred at line number " + linenum + ":", true);
        this.logit(inputline, true);
        this.adios(exitcode);
    }

    public String getParameter(char delimiter, String line, int[] endfield) {
        String tmpstr = "";
        int pos = line.indexOf(delimiter);
        if (pos < 0) {
            this.logit("Oops!  No delimiter ('" + delimiter + "') found within line:", true);
            this.logit(line, true);
            this.adios(-2);
        }
        if (++pos < line.length()) {
            if (endfield[0] >= 0) {
                endfield[0] = line.indexOf(delimiter, pos);
                if (endfield[0] < 0) {
                    endfield[0] = line.length();
                }
                tmpstr = line.substring(pos, endfield[0]).trim();
                if (endfield[0] == pos) {
                    endfield[0] = endfield[0] + 1;
                }
            } else {
                tmpstr = line.substring(pos).trim();
            }
        }
        return tmpstr;
    }

    public String getParameter(char delimiter, String line) {
        int[] dummy = new int[]{-1};
        return this.getParameter(delimiter, line, dummy);
    }

    public float parseTime(String ts) {
        float timeindays = -9999.0f;
        if (ts.length() == 0) {
            this.logit("Empty field!", true);
        } else {
            int lastdigit = 0;
            for (int p = 0; p < ts.length() && (ts.charAt(p) == '.' || ts.charAt(p) >= '0' && ts.charAt(p) <= '9'); ++p) {
                ++lastdigit;
            }
            if (lastdigit == 0) {
                this.logit("Input field does not start with a number: " + ts, true);
            } else {
                Float tmpFloat;
                try {
                    tmpFloat = new Float(ts.substring(0, lastdigit));
                }
                catch (NumberFormatException n) {
                    this.logit("Invalid number:" + ts.substring(0, lastdigit), true);
                    this.logit(n.toString(), true);
                    return timeindays;
                }
                if (ts.length() == lastdigit) {
                    this.logit("No time units found after number: " + ts, true);
                } else {
                    switch (ts.substring(lastdigit).trim().charAt(0)) {
                        case 'H': 
                        case 'h': {
                            timeindays = tmpFloat.floatValue() / 24.0f;
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            timeindays = tmpFloat.floatValue();
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            timeindays = tmpFloat.floatValue() * 30.44f;
                            break;
                        }
                        case 'Y': 
                        case 'y': {
                            timeindays = tmpFloat.floatValue() * 365.25f;
                            break;
                        }
                        default: {
                            this.logit("Unrecognized time units: " + ts.substring(lastdigit).trim(), true);
                        }
                    }
                }
            }
        }
        return timeindays;
    }

    public void logit(String message) {
        this.logit(message, false);
    }

    public void logit(String message, boolean mustprint) {
        if (mustprint) {
            System.err.println(message);
        } else if (this.verbose) {
            System.out.println(message);
        }
        if (this.logBufferedWriter != null) {
            try {
                this.logBufferedWriter.write(message);
                this.logBufferedWriter.newLine();
            }
            catch (Exception e) {
                System.err.println("Unable to write to log file!");
                System.err.println(e.toString());
            }
        }
    }

    public void adios(int exitcode) {
        int nt = this.relinkThreadList();
        if (nt > 0) {
            this.logit("There are still " + nt + " spawned jobs running.", true);
            long lasttime = -1L;
            ThreadList t = this.threadListHead;
            while (t != null) {
                if (t.starttime > lasttime) {
                    lasttime = t.starttime;
                }
                t = t.next;
            }
            long sleeptime = lasttime + 120000L - System.currentTimeMillis();
            if (sleeptime > 100L) {
                this.logit("Waiting up to " + (int)(sleeptime / 1000L) + " seconds for jobs to finish . . . ", true);
                sleeptime = lasttime + 120000L;
                while (this.relinkThreadList() > 0 && System.currentTimeMillis() < sleeptime) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(2000L);
                    }
                    catch (Exception e) {
                        System.err.println(e.toString());
                    }
                }
            }
            if ((nt = this.relinkThreadList()) > 0) {
                this.logit(nt + " threads still running;  trying to kill them . . .", true);
                t = this.threadListHead;
                while (t != null) {
                    try {
                        t.systemCall.runit.destroy();
                    }
                    catch (Exception e) {
                        System.err.println(e.toString());
                    }
                    t = t.next;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(4000L);
                }
                catch (Exception e) {
                    System.err.println(e.toString());
                }
                nt = this.relinkThreadList();
                if (nt > 0) {
                    this.logit("Couldn't kill " + nt + " threads.  You'll have to clean them up:", true);
                    t = this.threadListHead;
                    while (t != null) {
                        this.logit("\t" + t.job.getName(), true);
                        t = t.next;
                    }
                } else {
                    this.logit("Threads killed successfully.", true);
                }
            }
        }
        try {
            if (this.logBufferedWriter != null) {
                this.logBufferedWriter.flush();
                this.logBufferedWriter.close();
                this.logFileWriter.close();
            }
            int i = -1;
            if (exitcode < 0) {
                System.err.println("There was a problem!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(exitcode);
    }

    public int relinkThreadList() {
        if (this.threadListHead == null) {
            this.lastJob = null;
            return 0;
        }
        ThreadList t = this.threadListHead;
        int numthreads = 0;
        int alive = 0;
        while (t != null) {
            ++numthreads;
            if (this.verbose) {
                this.logit("Checking thread " + numthreads + " at " + new Date(System.currentTimeMillis()).toString());
            }
            if (t.job.isAlive()) {
                if (this.verbose) {
                    this.logit(" . . . alive: " + t.job.getName());
                }
                ++alive;
                this.lastJob = t;
            } else {
                if (this.verbose) {
                    this.logit(" . . . dead: " + t.job.getName());
                }
                if (t == this.threadListHead) {
                    this.threadListHead = t.next;
                } else {
                    this.lastJob.next = t.next;
                }
            }
            t = t.next;
        }
        return alive;
    }

    public class HuntList {
        public HuntList head = null;
        public HuntList next = null;
        public String inputline = null;
        public int inputlinenum = 0;
        public File dir = null;
        public boolean allroots = false;
        public boolean recursive = false;
        public FileHuntFilter customFilter = null;
        public int similarfilestokeep = 0;
        public File listfile = null;
        public String zipfilename = null;
        public File destdir = null;
        public String syscommand = null;
        public boolean delete = false;

        public HuntList(HuntList previous, String inlinearg, int linenumarg) {
            int p;
            if (previous == null) {
                this.head = this;
            } else {
                previous.next = this;
                this.head = previous.head;
            }
            this.next = null;
            this.inputline = inlinearg;
            this.inputlinenum = linenumarg;
            int[] endfield = new int[1];
            String ts = this.inputline;
            endfield[0] = 0;
            int startfield = 0;
            String inline = this.inputline;
            ts = FileHunter.this.getParameter(';', ";" + inline, endfield);
            if (ts.length() == 0) {
                if (!FileHunter.this.version1dot2) {
                    FileHunter.this.logit(" You cannot walk across multiple filesystem  roots in Java version " + System.getProperty("java.version") + "!", true);
                    FileHunter.this.logit(" You must either run Java 1.2 or higher, or  specify something in the first field: ", true);
                    FileHunter.this.adios(-6);
                }
                this.allroots = true;
            } else {
                this.dir = new File(ts);
                try {
                    if (!this.dir.exists()) {
                        FileHunter.this.readError("Specified directory not found: " + ts, this.inputline, this.inputlinenum, -3);
                    }
                    if (!this.dir.isDirectory()) {
                        FileHunter.this.readError("Specified path is not a directory: " + ts, this.inputline, this.inputlinenum, -3);
                    }
                }
                catch (Exception e) {
                    FileHunter.this.logit(e.toString(), true);
                    FileHunter.this.readError("Unable to access directory: " + ts, this.inputline, this.inputlinenum, -3);
                }
            }
            endfield[0] = endfield[0] - 1;
            ts = FileHunter.this.getParameter(';', inline.substring(startfield += endfield[0]), endfield);
            if (ts.length() > 0 && ts.toLowerCase().charAt(0) == 'r') {
                this.recursive = true;
            }
            endfield[0] = endfield[0] - 1;
            String tmpmask = null;
            ts = FileHunter.this.getParameter(';', inline.substring(startfield += endfield[0]), endfield);
            tmpmask = ts.length() == 0 ? "*" : ts;
            endfield[0] = endfield[0] - 1;
            float ageindays = -9999.0f;
            ts = FileHunter.this.getParameter(';', inline.substring(startfield += endfield[0]), endfield);
            if (ts.length() > 0) {
                for (p = 0; !(p >= ts.length() || ts.charAt(p) >= 'A' && ts.charAt(p) <= 'Z' || ts.charAt(p) >= 'a' && ts.charAt(p) <= 'z'); ++p) {
                }
                if (p == 0 || p == ts.length()) {
                    FileHunter.this.readError("Unable to determine value or units for age field.", this.inputline, this.inputlinenum, -3);
                }
                if (ts.charAt(p) == 'F' || ts.charAt(p) == 'f') {
                    --p;
                    try {
                        this.similarfilestokeep = Integer.parseInt(ts.substring(0, p));
                    }
                    catch (NumberFormatException n) {
                        FileHunter.this.logit("Invalid integer:" + ts.substring(0, p), true);
                        FileHunter.this.logit(n.toString(), true);
                        FileHunter.this.readError("Unable to determine value or units for age field.", this.inputline, this.inputlinenum, -3);
                    }
                    if (this.similarfilestokeep <= 0) {
                        FileHunter.this.readError("Invalid number of similar files to keep (must be positive).", this.inputline, this.inputlinenum, -3);
                    }
                } else {
                    ageindays = FileHunter.this.parseTime(ts);
                    if (ageindays == -9999.0f) {
                        FileHunter.this.readError("Unable to read file age requirement.", this.inputline, this.inputlinenum, -3);
                    }
                }
            }
            endfield[0] = endfield[0] - 1;
            this.customFilter = new FileHuntFilter(tmpmask, ageindays);
            if ((startfield += endfield[0]) >= inline.length() - 2) {
                FileHunter.this.readError("No actions specified!", this.inputline, this.inputlinenum, -3);
            }
            while (startfield < inline.length() - 2) {
                ts = FileHunter.this.getParameter(';', inline.substring(startfield), endfield);
                endfield[0] = endfield[0] - 1;
                startfield += endfield[0];
                if (ts.length() == 0) {
                    FileHunter.this.readError("Oops!  Blank field not allowed in action list", this.inputline, this.inputlinenum, -3);
                }
                if (ts.startsWith("d")) {
                    this.delete = true;
                    if (this.destdir == null) continue;
                    FileHunter.this.readError("Files already set for moving.  Can't do both.", this.inputline, this.inputlinenum, -3);
                    continue;
                }
                for (p = 0; p < ts.length() && ts.charAt(p) != ' '; ++p) {
                }
                if (p == ts.length()) {
                    FileHunter.this.readError("No parameter given - need more than just move/list/run:" + ts, this.inputline, this.inputlinenum, -3);
                }
                String paramstring = ts.substring(p).trim();
                if (ts.startsWith("m")) {
                    if (this.delete) {
                        FileHunter.this.readError("Files already set for deletion.  Can't do both.", this.inputline, this.inputlinenum, -3);
                    }
                    this.destdir = new File(paramstring);
                    try {
                        if (!this.destdir.exists()) {
                            FileHunter.this.readError("Destination directory does not already exist: " + this.destdir.getAbsolutePath(), this.inputline, this.inputlinenum, -3);
                        }
                        if (!this.dir.isDirectory()) {
                            FileHunter.this.readError("Destination directory is not a directory: " + this.destdir.getAbsolutePath(), this.inputline, this.inputlinenum, -3);
                        }
                        if (this.dir.canWrite()) continue;
                        FileHunter.this.readError("Destination directory is not a writable : " + this.destdir.getAbsolutePath(), this.inputline, this.inputlinenum, -3);
                    }
                    catch (Exception e) {
                        FileHunter.this.logit(e.toString(), true);
                        FileHunter.this.readError("Unable to access destination directory: " + this.destdir.getAbsolutePath(), this.inputline, this.inputlinenum, -3);
                    }
                    continue;
                }
                if (ts.startsWith("z")) {
                    this.zipfilename = paramstring;
                    continue;
                }
                if (ts.startsWith("l")) {
                    this.listfile = new File(paramstring);
                    try {
                        if (!this.listfile.exists()) continue;
                        if (!this.listfile.isFile()) {
                            FileHunter.this.readError("Specified list file is not a regular file: " + this.listfile.getAbsolutePath(), this.inputline, this.inputlinenum, -3);
                        }
                        if (!this.listfile.canWrite()) {
                            FileHunter.this.readError("Unable to write to specified list file: " + this.listfile.getAbsolutePath(), this.inputline, this.inputlinenum, -3);
                        }
                        FileHunter.this.logit("Appending to existing list file : " + this.listfile.getAbsolutePath());
                    }
                    catch (Exception e) {
                        System.err.println(e.toString());
                        FileHunter.this.readError("Unable to access " + this.listfile.getAbsolutePath(), this.inputline, this.inputlinenum, -3);
                    }
                    continue;
                }
                if (ts.startsWith("r")) {
                    this.syscommand = paramstring;
                    continue;
                }
                FileHunter.this.readError("Unrecognized action to perform: " + ts, this.inputline, this.inputlinenum, -3);
            }
        }
    }

    public class ThreadList {
        public ThreadList next = null;
        public Thread job = null;
        long starttime = 0L;
        SystemCall systemCall = null;

        public ThreadList(ThreadList previous, SystemCall runMe) {
            if (previous == null) {
                FileHunter.this.threadListHead = this;
            } else {
                previous.next = this;
            }
            this.next = null;
            this.starttime = System.currentTimeMillis();
            this.systemCall = runMe;
            this.job = new Thread((Runnable)runMe, runMe.name);
            this.job.setPriority(Thread.currentThread().getPriority() - 1);
            this.job.start();
        }
    }

    public class FileHuntFilter
    implements FilenameFilter {
        String filemask;
        float daysold;

        public FileHuntFilter(String mask, float age) {
            this.filemask = mask;
            this.daysold = age;
        }

        @Override
        public boolean accept(File dir, String name) {
            int np = 0;
            int mp = 0;
            if (FileHunter.this.verbose) {
                FileHunter.this.logit("filemask=" + this.filemask + " age=" + this.daysold + " days dir=" + dir + " name=" + name);
            }
            File f = new File(dir, name);
            try {
                if (f.isDirectory()) {
                    if (FileHunter.this.verbose) {
                        FileHunter.this.logit("  . . . is a directory");
                    }
                    return true;
                }
                if (!f.exists()) {
                    FileHunter.this.logit(" Phantom entry in directory " + dir.getAbsolutePath() + " does not exist: " + name + "!", true);
                    ++FileHunter.this.fileexceptions;
                    return false;
                }
                if (!f.isFile()) {
                    if (FileHunter.this.verbose) {
                        FileHunter.this.logit(f + " is not a normal file or dir");
                    }
                    return false;
                }
                ++FileHunter.this.totalfiles;
            }
            catch (Exception e) {
                ++FileHunter.this.fileexceptions;
                FileHunter.this.logit("Unable to access " + f.getPath() + "!", true);
                FileHunter.this.logit(e.toString(), true);
                return false;
            }
            String misfit = "    . . . doesn't fit filemask";
            block8: for (mp = 0; mp < this.filemask.length() && np < f.getName().length(); ++mp) {
                switch (this.filemask.charAt(mp)) {
                    case '?': {
                        ++np;
                        continue block8;
                    }
                    case '*': {
                        if (mp == this.filemask.length() - 1) {
                            np = f.getName().length();
                            continue block8;
                        }
                        int ns = this.filemask.indexOf(42, mp + 1);
                        int nq = this.filemask.indexOf(63, mp + 1);
                        if (nq > 1 && (ns > 1 && nq < ns || ns <= 1)) {
                            ns = nq;
                        }
                        if (ns - mp == 1) {
                            FileHunter.this.logit("Badly formed filemask: " + this.filemask, true);
                            FileHunter.this.logit("The character after a '*' may not be another wildcard.", true);
                            FileHunter.this.adios(-2);
                        }
                        if (ns - mp < 1) {
                            ns = this.filemask.length();
                        }
                        String regtxt = this.filemask.substring(mp + 1, ns);
                        nq = f.getName().indexOf(regtxt, np);
                        if (nq == -1) {
                            if (FileHunter.this.verbose) {
                                FileHunter.this.logit(misfit);
                            }
                            return false;
                        }
                        mp = ns - 1;
                        np = nq + regtxt.length();
                        continue block8;
                    }
                    default: {
                        if (this.filemask.charAt(mp) == f.getName().charAt(np)) {
                            ++np;
                            continue block8;
                        }
                        if (FileHunter.this.verbose) {
                            FileHunter.this.logit(misfit);
                        }
                        return false;
                    }
                }
            }
            if (np == f.getName().length() && mp == this.filemask.length() - 1 && this.filemask.charAt(mp) == '*') {
                ++mp;
            }
            if (np != f.getName().length() || mp != this.filemask.length()) {
                if (FileHunter.this.verbose) {
                    FileHunter.this.logit(misfit);
                }
                return false;
            }
            if (this.daysold > 0.0f) {
                long filedate;
                try {
                    filedate = f.lastModified();
                }
                catch (Exception e) {
                    ++FileHunter.this.fileexceptions;
                    FileHunter.this.logit("Unable to get age of " + f.getPath() + "!", true);
                    FileHunter.this.logit(e.toString(), true);
                    return false;
                }
                if ((float)(FileHunter.this.lasthunt - filedate) / 8.64E7f < this.daysold) {
                    if (FileHunter.this.verbose) {
                        FileHunter.this.logit("    . . . is too young");
                    }
                    return false;
                }
            }
            if (f.equals(FileHunter.this.logFile)) {
                if (FileHunter.this.verbose) {
                    FileHunter.this.logit("    . . . is the output file for this run");
                }
                return false;
            }
            if (FileHunter.this.verbose) {
                FileHunter.this.logit("    . . . is a MATCH!");
            }
            ++FileHunter.this.totalmatches;
            return true;
        }
    }

    public class SystemCall
    implements Runnable {
        String command;
        String name;
        public HuntList hunt = null;
        Process runit = null;
        int exitcode = 0;

        public SystemCall(String command, HuntList hl) {
            this.command = command;
            this.hunt = hl;
            this.name = "Job #" + FileHunter.this.spawnedjobs + ": " + command;
        }

        @Override
        public void run() {
            try {
                this.runit = Runtime.getRuntime().exec(this.command);
                this.exitcode = this.runit.waitFor();
            }
            catch (Exception e) {
                System.err.println("Unable to run " + this.command);
                System.err.println(e.toString());
            }
            FileHunter.this.logit(this.name + " returned " + this.exitcode + " at " + new Date(System.currentTimeMillis()).toString(), true);
        }
    }
}

