/*
 * Decompiled with CFR 0.152.
 */
package hec.ui;

import hec.ui.TristateDecorator;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ActionMapUIResource;

public class TristateCheckBox
extends JCheckBox {
    private boolean _modified = false;
    private boolean _modifiable = true;
    public static final State NOT_SELECTED = new State();
    public static final State SELECTED = new State();
    public static final State SEMI_SELECTED = new State();
    private final TristateDecorator model;
    private boolean isRestricted = false;

    public TristateCheckBox(String text, Icon icon, State initial) {
        super(text, icon);
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.nextState(TristateCheckBox.this.isRestricted);
            }
        });
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.nextState(TristateCheckBox.this.isRestricted);
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(initial);
    }

    public TristateCheckBox(String text, State initial) {
        this(text, null, initial);
    }

    public TristateCheckBox(String text) {
        this(text, SEMI_SELECTED);
    }

    public TristateCheckBox() {
        this((String)null);
    }

    public void setRestictUserInput(boolean state) {
        this.isRestricted = state;
    }

    public void itemStateChanged(ItemEvent e) {
        this.setModified(true);
    }

    public void setModified(boolean b) {
        this._modified = b;
    }

    public boolean isModified() {
        return this._modified;
    }

    @Override
    public String getToolTipText() {
        return this.getText();
    }

    public void setIsEditable(boolean b) {
        if (this._modifiable) {
            this.setEnabled(b);
        }
    }

    public void setModifiable(boolean b) {
        this._modifiable = b;
    }

    @Override
    public void addMouseListener(MouseListener l) {
    }

    public void setState(State state) {
        this.model.setState(state);
    }

    public State getState() {
        return this.model.getState();
    }

    @Override
    public void setSelected(boolean b) {
        if (b) {
            this.setState(SELECTED);
        } else {
            this.setState(NOT_SELECTED);
        }
    }

    public static class State {
        private State() {
        }

        public String toString() {
            if (this == SELECTED) {
                return "Selected";
            }
            if (this == SEMI_SELECTED) {
                return "Semi-Selected";
            }
            if (this == NOT_SELECTED) {
                return "Not Selected";
            }
            return "State Undefined";
        }
    }
}

