/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.util.AnimatedWaitIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AnimatedStatusIconPanel
extends JPanel {
    public static final int VISTA = 1;
    public static final int FIREFOX = 2;
    public static final int WORKING_STATUS = 1;
    public static final int NORMAL_STATUS = 2;
    protected int _state;
    protected ImageIcon _normalStatusIcon;
    protected AnimatedWaitIcon _animatedWaitIcon;

    public AnimatedStatusIconPanel(int style, ImageIcon normalStatusIcon) {
        this.setLayout(new BorderLayout());
        this._normalStatusIcon = normalStatusIcon;
        this._animatedWaitIcon = new AnimatedWaitIcon(style);
        this.setSize();
        this.setState(2);
    }

    public void setState(int state) {
        this._state = state;
        this.removeAll();
        if (state == 1) {
            this.add(this._animatedWaitIcon);
            this._animatedWaitIcon.setActive(true);
        } else {
            this._animatedWaitIcon.setActive(false);
            if (this._normalStatusIcon != null) {
                JLabel l = new JLabel(this._normalStatusIcon);
                this.add(l);
            }
        }
    }

    public int getState() {
        return this._state;
    }

    public AnimatedWaitIcon getWaitIcon() {
        return this._animatedWaitIcon;
    }

    public void setSize() {
        if (this._normalStatusIcon != null) {
            int dia = this._normalStatusIcon.getIconHeight();
            if (this._normalStatusIcon.getIconWidth() > dia) {
                dia = this._normalStatusIcon.getIconWidth();
            }
            this.setSize(dia);
        }
    }

    public void setSize(int diameter) {
        int innerRadius = this._animatedWaitIcon.getInnerCircleRadius();
        int outerRadius = this._animatedWaitIcon.getOuterCircleRadius();
        int numberSpokes = this._animatedWaitIcon.getNumberOfSpoke();
        int spokeThickness = this._animatedWaitIcon.getSpokeThickness();
        double diff = (double)diameter / 2.0 - (double)outerRadius;
        double change = 1.0 + diff / (double)outerRadius;
        innerRadius = (int)(change * (double)innerRadius);
        outerRadius = diameter / 2;
        numberSpokes = (int)(change * (double)numberSpokes);
        this._animatedWaitIcon.setCircleAppearance(numberSpokes, spokeThickness, innerRadius, outerRadius);
        Dimension dim = new Dimension(diameter += 4, diameter);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        int delay = this._animatedWaitIcon.getRotationSpeed();
        delay = (int)((double)delay / change);
        this._animatedWaitIcon.setRotationSpeed(delay);
    }

    public void setRotationSpeed(int milliseconds) {
        this._animatedWaitIcon.setRotationSpeed(milliseconds);
    }

    public void setColor(Color color) {
        this._animatedWaitIcon.setColor(color);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        AnimatedStatusIconPanel ic = new AnimatedStatusIconPanel(1, new ImageIcon("J:/dev/code/Images/cavi.gif"));
        frame.add(ic);
        frame.setSize(200, 200);
        frame.setLocation(20, 20);
        ic.setState(1);
        frame.setVisible(true);
    }
}

