/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.util.AnimatedWaitIcon;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingWorker;

public class AnimatedWaitGlassPane
extends AnimatedWaitIcon {
    private Color textColor = Color.DARK_GRAY.darker().darker();
    private float _transparency = 0.65f;
    private String message = "";

    public AnimatedWaitGlassPane() {
        super(1);
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        this.addKeyListener(new KeyAdapter(){});
        this.setFocusTraversalKeysEnabled(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                AnimatedWaitGlassPane.this.requestFocusInWindow();
            }
        });
        this.setBackground(Color.WHITE);
        this.setFont(new Font("Default", 1, 16));
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color c2) {
        this.textColor = c2;
    }

    public float getTransparency() {
        return this._transparency;
    }

    public void setTransparency(float transparency) {
        this._transparency = transparency;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle clip = g.getClipBounds();
        AlphaComposite alpha = AlphaComposite.SrcOver.derive(this._transparency);
        Composite composite = g2.getComposite();
        g2.setComposite(alpha);
        g2.setColor(this.getBackground());
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        FontMetrics metrics = g.getFontMetrics();
        Point2D.Float controlCenterPoint = this.getControlCenterPoint();
        int descent = metrics.getDescent();
        descent += this.getOuterCircleRadius();
        Point2D.Float coordinate = this.GetCoordinate(controlCenterPoint, descent += 3, 270.0);
        float stringWidth = metrics.stringWidth(this.message) / 2;
        g2.setColor(this.textColor);
        g2.drawString(this.message, coordinate.x - stringWidth, coordinate.y);
        g2.setComposite(composite);
        super.paintComponent(g);
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        JLabel label = new JLabel("I am stuff being displayed in the window.");
        frame.getContentPane().add((Component)label, "Center");
        JButton button = new JButton("I am Button, click me");
        frame.getContentPane().add((Component)button, "South");
        final AnimatedWaitGlassPane animatedWaitGlassPane = new AnimatedWaitGlassPane();
        animatedWaitGlassPane.setColor(Color.BLACK);
        frame.setGlassPane(animatedWaitGlassPane);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setCursor(new Cursor(3));
                frame.getGlassPane().setVisible(true);
                animatedWaitGlassPane.setMessage("Waiting 10 seconds");
                animatedWaitGlassPane.setActive(true);
                SwingWorker<Object, Void> sw = new SwingWorker<Object, Void>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        Thread.sleep(10000L);
                        return null;
                    }

                    @Override
                    protected void done() {
                        frame.setCursor(new Cursor(0));
                        frame.getGlassPane().setVisible(false);
                        animatedWaitGlassPane.setActive(false);
                    }
                };
                sw.execute();
            }
        });
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 400);
        frame.setLocation(500, 500);
        frame.setVisible(true);
    }
}

