/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import javax.swing.Timer;

public class AnimatedWaitIcon
extends JPanel {
    public static final int VISTA = 1;
    public static final int FIREFOX = 2;
    protected int _style;
    private final double NUMBER_OF_DEGREES_IN_CIRCLE = 360.0;
    private final double NUMBER_OF_DEGREES_IN_HALF_CIRCLE = 180.0;
    private final int fireFoxInnerCircleRadius = 5;
    private final int fireFoxOuterCircleRadius = 7;
    private final int fireFoxNumberOfSpoke = 9;
    private final int fireFoxSpokeThickness = 4;
    private final int vistaInnerCircleRadius = 7;
    private final int vistaOuterCircleRadius = 9;
    private final int vistaNumberOfSpoke = 24;
    private final int vistaSpokeThickness = 4;
    private Timer animationTimer;
    private boolean timerActive;
    private int numberOfSpoke;
    private int spokeThickness;
    private int progressValue;
    private int outerCircleRadius;
    private int innerCircleRadius;
    private Point2D.Float centerPoint;
    private Color currentColor;
    private Color[] palleteColors;
    private double[] lineAngles;

    public AnimatedWaitIcon(int style) {
        this.setStyle(style);
        this.currentColor = this._style == 1 ? new Color(0, 255, 240) : Color.darkGray;
        this.generateColorsPallet();
        this.getSpokesAngles();
        this.getControlCenterPoint();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AnimatedWaitIcon.this.getControlCenterPoint();
            }
        });
        this.animationTimer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ++AnimatedWaitIcon.this.progressValue;
                AnimatedWaitIcon.this.progressValue %= AnimatedWaitIcon.this.numberOfSpoke;
                AnimatedWaitIcon.this.repaint();
            }
        });
        this.activateTimer();
        this.animationTimer.setDelay(40);
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setColor(Color color) {
        this.currentColor = color;
        this.generateColorsPallet();
        this.invalidate();
    }

    public int getInnerCircleRadius() {
        return this.innerCircleRadius;
    }

    public void setInnerCircleRadius(int innerCircleRadius) {
        this.innerCircleRadius = innerCircleRadius;
        this.invalidate();
    }

    public int getOuterCircleRadius() {
        return this.outerCircleRadius;
    }

    public void setOuterCircleRadius(int outerCircleRadius) {
        this.outerCircleRadius = outerCircleRadius;
    }

    public int getNumberOfSpoke() {
        return this.numberOfSpoke;
    }

    public void setNumberOfSpoke(int numberOfSpoke) {
        if (this.numberOfSpoke != numberOfSpoke && numberOfSpoke > 0) {
            this.numberOfSpoke = numberOfSpoke;
            this.generateColorsPallet();
            this.getSpokesAngles();
            this.invalidate();
        }
    }

    public boolean isTimerActive() {
        return this.timerActive;
    }

    public void setActive(boolean active) {
        this.timerActive = active;
        this.activateTimer();
    }

    public int getSpokeThickness() {
        return this.spokeThickness;
    }

    public void setSpokeThickness(int spokeThickness) {
        this.spokeThickness = spokeThickness;
        this.invalidate();
    }

    public int getRotationSpeed() {
        return this.animationTimer.getDelay();
    }

    public void setRotationSpeed(int milliseconds) {
        this.animationTimer.setDelay(milliseconds);
    }

    protected void setStyle(int style) {
        this._style = style;
        switch (this._style) {
            case 2: {
                this.initCircleAppearance(9, 4, 5, 7);
                break;
            }
            case 1: {
                this.initCircleAppearance(24, 4, 7, 9);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.centerPoint.x == 0.0f && this.centerPoint.y == 0.0f) {
            this.getControlCenterPoint();
        }
        if (this.numberOfSpoke > 0) {
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints renderingHints = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            int intPosition = this.progressValue;
            for (int intCounter = 0; intCounter < this.numberOfSpoke; ++intCounter) {
                Point2D.Float p1 = this.GetCoordinate(this.centerPoint, this.innerCircleRadius, this.lineAngles[intPosition %= this.numberOfSpoke]);
                Point2D.Float p2 = this.GetCoordinate(this.centerPoint, this.outerCircleRadius, this.lineAngles[intPosition]);
                this.drawStroke(g2, p1, p2, this.palleteColors[intCounter], this.spokeThickness);
                ++intPosition;
            }
            g2.setRenderingHints(renderingHints);
        }
    }

    private void drawStroke(Graphics2D g2, Point2D.Float p1, Point2D.Float p2, Color color, int thickness) {
        Color c2 = g2.getColor();
        Stroke stroke = g2.getStroke();
        g2.setColor(color);
        BasicStroke basicStroke = new BasicStroke(thickness, 1, 1);
        g2.setStroke(basicStroke);
        Line2D.Double line = new Line2D.Double(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        g2.draw(line);
        g2.setColor(c2);
        g2.setStroke(stroke);
    }

    private Color getDarkerColor(Color color, int alphaPercent) {
        int intRed = color.getRed();
        int intGreen = color.getGreen();
        int intBlue = color.getBlue();
        return new Color(Math.min(intRed, 127), Math.min(intGreen, 127), Math.min(intBlue, 127), alphaPercent);
    }

    private void generateColorsPallet() {
        this.palleteColors = this.GenerateColorsPallet(this.currentColor, this.isTimerActive(), this.numberOfSpoke);
    }

    private Color[] GenerateColorsPallet(Color color, boolean shade, int numberOfSpoke) {
        Color[] returnColors = new Color[this.getNumberOfSpoke()];
        byte byteIncrement = (byte)(127 / this.getNumberOfSpoke());
        int PERCENTAGE_OF_DARKEN = 0;
        for (int i = 0; i < this.getNumberOfSpoke(); ++i) {
            if (shade) {
                if (i == 0 || i < this.getNumberOfSpoke() - numberOfSpoke) {
                    returnColors[i] = color;
                    continue;
                }
                if ((PERCENTAGE_OF_DARKEN = (byte)(PERCENTAGE_OF_DARKEN + byteIncrement)) > 127) {
                    PERCENTAGE_OF_DARKEN = 127;
                }
                returnColors[i] = this.getDarkerColor(color, PERCENTAGE_OF_DARKEN);
                continue;
            }
            returnColors[i] = color;
        }
        return returnColors;
    }

    protected Point2D.Float getControlCenterPoint() {
        this.centerPoint = new Point2D.Float((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        return this.centerPoint;
    }

    protected Point2D.Float GetCoordinate(Point2D.Float circleCenter, int radius, double angle) {
        double dblAngle = Math.PI * angle / 180.0;
        Point2D.Float point = new Point2D.Float(circleCenter.x + (float)radius * (float)Math.cos(dblAngle), circleCenter.y + (float)radius * (float)Math.sin(dblAngle));
        return point;
    }

    private void getSpokesAngles() {
        this.lineAngles = this.getSpokesAngles(this.getNumberOfSpoke());
    }

    private double[] getSpokesAngles(int spokeNumber) {
        if (spokeNumber <= 1) {
            double[] d = new double[]{0.0};
            return d;
        }
        double[] returnAngles = new double[spokeNumber];
        double angle = 360.0 / (double)spokeNumber;
        returnAngles[0] = 0.0;
        for (int j = 1; j < spokeNumber; ++j) {
            returnAngles[j] = j == 0 ? angle : returnAngles[j - 1] + angle;
        }
        return returnAngles;
    }

    private void activateTimer() {
        if (this.timerActive) {
            this.animationTimer.start();
        } else {
            this.animationTimer.stop();
            this.progressValue = 0;
        }
        this.generateColorsPallet();
        this.invalidate();
    }

    public void setCircleAppearance(int numberSpoke, int spokeThickness, int innerCircleRadius, int outerCircleRadius) {
        this.setNumberOfSpoke(numberSpoke);
        this.setSpokeThickness(spokeThickness);
        this.setInnerCircleRadius(innerCircleRadius);
        this.setOuterCircleRadius(outerCircleRadius);
        this.invalidate();
        this.getControlCenterPoint();
    }

    protected void initCircleAppearance(int numberOfSpoke, int spokeThickness, int innerCircleRadius, int outerCircleRadius) {
        this.numberOfSpoke = numberOfSpoke;
        this.spokeThickness = spokeThickness;
        this.innerCircleRadius = innerCircleRadius;
        this.outerCircleRadius = outerCircleRadius;
    }
}

