/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static byte[] chars = new String("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/").getBytes();

    public static String encode(String str) throws UnsupportedEncodingException {
        return Base64.encode(str, "ISO-8859-1");
    }

    public static String encode(String str, String charset) throws UnsupportedEncodingException {
        return new String(Base64.encode(str.getBytes(charset)), charset);
    }

    public static String decode(String str) throws UnsupportedEncodingException {
        return Base64.decode(str, "ISO-8859-1");
    }

    public static String decode(String str, String charset) throws UnsupportedEncodingException {
        return new String(Base64.decode(str.getBytes(charset)), charset);
    }

    public static byte[] encode(byte[] in, int offset, int len) {
        int groupCount = (len - 1) / 3 + 1;
        byte[] inbuf = new byte[]{0, 0, 0};
        byte[] outbuf = new byte[]{0, 0, 0, 0};
        byte[] out = new byte[groupCount * 4];
        for (int i = 0; i < groupCount; ++i) {
            int byteCount;
            int iin = offset + i * 3;
            int iout = i * 4;
            inbuf[0] = in[iin++];
            if (iin < len) {
                inbuf[1] = in[iin++];
                if (iin < len) {
                    inbuf[2] = in[iin];
                    byteCount = 3;
                } else {
                    byteCount = 2;
                    inbuf[2] = 0;
                }
            } else {
                byteCount = 1;
                inbuf[2] = 0;
                inbuf[1] = 0;
            }
            outbuf[0] = chars[inbuf[0] >>> 2 & 0x3F];
            outbuf[1] = chars[inbuf[0] << 4 & 0x30 | inbuf[1] >>> 4 & 0xF];
            outbuf[2] = byteCount > 1 ? chars[inbuf[1] << 2 & 0x3C | inbuf[2] >>> 6 & 3] : 61;
            outbuf[3] = byteCount > 2 ? chars[inbuf[2] & 0x3F] : 61;
            for (int j = 0; j < 4; ++j) {
                out[iout + j] = outbuf[j];
            }
        }
        return out;
    }

    public static byte[] encode(byte[] in) {
        return Base64.encode(in, 0, in.length);
    }

    public static byte[] decode(byte[] in, int offset, int len) {
        if (len % 4 != 0) {
            throw new IllegalArgumentException("Length of input is not multiple of 4");
        }
        int groupCount = len / 4;
        int outlen = groupCount * 3;
        if (in[offset + len - 1] == 61) {
            --outlen;
            if (in[offset + len - 2] == 61) {
                --outlen;
            }
        }
        byte[] out = new byte[outlen];
        byte[] inbuf = new byte[]{0, 0, 0, 0};
        for (int i = 0; i < groupCount; ++i) {
            int iin;
            for (int j = 0; j < 4 && in[iin = offset + i * 4 + j] != 61; ++j) {
                int k;
                for (k = 0; k < 64; ++k) {
                    if (chars[k] != in[iin]) continue;
                    inbuf[j] = (byte)k;
                    break;
                }
                if (k != 64) continue;
                throw new IllegalArgumentException("Input contains non-base64 character  (" + (char)in[iin] + ")at position " + iin);
            }
            int iout = i * 3;
            out[iout++] = (byte)(inbuf[0] << 2 & 0xFC | inbuf[1] >>> 4 & 3);
            if (iout >= outlen) continue;
            out[iout++] = (byte)(inbuf[1] << 4 & 0xF0 | inbuf[2] >>> 2 & 0xF);
            if (iout >= outlen) continue;
            out[iout] = (byte)(inbuf[2] << 6 & 0xC0 | inbuf[3] & 0x3F);
        }
        return out;
    }

    public static byte[] decode(byte[] in) {
        return Base64.decode(in, 0, in.length);
    }
}

