/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.lang.NamedType;
import hec.map.LocalRect;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMAConst;
import rma.util.RmaBaseXmlUtilities;

public class BaseXMLUtilities
extends RmaBaseXmlUtilities {
    public static void saveNamedType(Element elem, NamedType nt) {
        if (elem == null || nt == null) {
            return;
        }
        elem.setAttribute("Name", nt.getName());
        BaseXMLUtilities.saveDescription(elem, nt);
        if (RMAConst.isValidValue(nt.getIndex())) {
            elem.setAttribute("Index", String.valueOf(nt.getIndex()));
        }
    }

    public static void loadNamedType(Element elem, NamedType nt) {
        if (elem == null || nt == null) {
            return;
        }
        nt.setName(elem.getAttributeValue("Name", nt.getName()));
        BaseXMLUtilities.setDescription(elem, nt);
        nt.setIndex(BaseXMLUtilities.getAttributeValueAsInt(elem, "Index", nt.getIndex()));
    }

    public static void saveDescription(Element parent, NamedType nt) {
        if (parent == null || nt == null) {
            return;
        }
        String desc = nt.getDescription();
        BaseXMLUtilities.saveDescription(parent, desc);
    }

    public static void setDescription(Element descElem, NamedType nt) {
        String desc = BaseXMLUtilities.getDescription(descElem);
        if (desc != null) {
            nt.setDescription(desc);
        }
    }

    public static void saveWorldPt(Element parent, WorldPt wpt) {
        if (parent == null || wpt == null) {
            return;
        }
        Element elem = new Element("WorldPt");
        parent.addContent((Content)elem);
        elem.setAttribute("n", String.valueOf(wpt.n));
        elem.setAttribute("e", String.valueOf(wpt.e));
    }

    public static WorldPt loadWorldPt(Element elem) {
        if (elem == null) {
            return null;
        }
        if (!"WorldPt".equals(elem.getName())) {
            elem = elem.getChild("WorldPt");
        }
        if (elem == null) {
            return null;
        }
        WorldPt wpt = new WorldPt();
        wpt.n = BaseXMLUtilities.getAttributeValueAsDouble(elem, "n", 0.0);
        wpt.e = BaseXMLUtilities.getAttributeValueAsDouble(elem, "e", 0.0);
        return wpt;
    }

    public static void saveLocalRect(Element parent, LocalRect rect) {
        if (parent == null || rect == null) {
            return;
        }
        Element elem = new Element("LocalRect");
        parent.addContent((Content)elem);
        elem.setAttribute("bottom", String.valueOf(rect.b));
        elem.setAttribute("top", String.valueOf(rect.t));
        elem.setAttribute("left", String.valueOf(rect.l));
        elem.setAttribute("right", String.valueOf(rect.r));
    }

    public static LocalRect loadLocalRect(Element elem) {
        if (elem == null) {
            return null;
        }
        if (!"LocalRect".equals(elem.getName())) {
            elem = elem.getChild("LocalRect");
        }
        if (elem == null) {
            return null;
        }
        LocalRect lr = new LocalRect();
        lr.b = BaseXMLUtilities.getAttributeValueAsInt(elem, "bottom", 0);
        lr.t = BaseXMLUtilities.getAttributeValueAsInt(elem, "top", 0);
        lr.l = BaseXMLUtilities.getAttributeValueAsInt(elem, "left", 0);
        lr.r = BaseXMLUtilities.getAttributeValueAsInt(elem, "right", 0);
        return lr;
    }

    public static void saveWorldRect(Element parent, WorldRect rect) {
        if (parent == null || rect == null) {
            return;
        }
        Element elem = new Element("WorldRect");
        parent.addContent((Content)elem);
        elem.setAttribute("e", String.valueOf(rect.e));
        elem.setAttribute("w", String.valueOf(rect.w));
        elem.setAttribute("n", String.valueOf(rect.n));
        elem.setAttribute("s", String.valueOf(rect.s));
    }

    public static WorldRect loadWorldRect(Element elem) {
        if (elem == null) {
            return null;
        }
        if (!"WorldRect".equals(elem.getName())) {
            elem = elem.getChild("WorldRect");
        }
        if (elem == null) {
            return null;
        }
        WorldRect wr = new WorldRect();
        wr.e = BaseXMLUtilities.getAttributeValueAsDouble(elem, "e", 0.0);
        wr.w = BaseXMLUtilities.getAttributeValueAsDouble(elem, "w", 0.0);
        wr.n = BaseXMLUtilities.getAttributeValueAsDouble(elem, "n", 0.0);
        wr.s = BaseXMLUtilities.getAttributeValueAsDouble(elem, "s", 0.0);
        return wr;
    }

    public static void saveWorldRegion(Element parent, WorldRegion region) {
        if (parent == null || region == null) {
            return;
        }
        Element regionNode = new Element("WorldRegion");
        parent.addContent((Content)regionNode);
        Vector pts = region.pts;
        regionNode.setAttribute("NumPts", String.valueOf(pts.size()));
        for (int i = 0; i < pts.size(); ++i) {
            WorldPt wpt = (WorldPt)pts.get(i);
            BaseXMLUtilities.saveWorldPt(regionNode, wpt);
        }
    }

    public static WorldRegion loadWorldRegion(Element element, WorldRegion region) {
        if (element == null) {
            return region;
        }
        if (!"WorldRegion".equals(element.getName()) && (element = element.getChild("WorldRegion")) == null) {
            return region;
        }
        if (region == null) {
            region = new WorldRegion();
        }
        int size = BaseXMLUtilities.getAttributeValueAsInt(element, "NumPts", 10);
        region.pts.ensureCapacity(size);
        List ptsList = element.getChildren();
        for (int i = 0; i < ptsList.size(); ++i) {
            Element child = (Element)ptsList.get(i);
            WorldPt wpt = BaseXMLUtilities.loadWorldPt(child);
            region.pts.add(wpt);
        }
        return region;
    }

    public static void saveWorldLine(Element parent, WorldLine line) {
        if (parent == null || line == null) {
            return;
        }
        Element lineNode = new Element("WorldLine");
        parent.addContent((Content)lineNode);
        Vector pts = line.pts;
        lineNode.setAttribute("NumPts", String.valueOf(pts.size()));
        for (int i = 0; i < pts.size(); ++i) {
            WorldPt wpt = (WorldPt)pts.get(i);
            BaseXMLUtilities.saveWorldPt(lineNode, wpt);
        }
    }

    public static WorldLine loadWorldLine(Element element, WorldLine line) {
        if (element == null) {
            return line;
        }
        if (!"WorldLine".equals(element.getName()) && (element = element.getChild("WorldLine")) == null) {
            return line;
        }
        if (line == null) {
            line = new WorldLine();
        }
        int size = BaseXMLUtilities.getAttributeValueAsInt(element, "NumPts", 10);
        line.pts.ensureCapacity(size);
        List ptsList = element.getChildren();
        for (int i = 0; i < ptsList.size(); ++i) {
            Element child = (Element)ptsList.get(i);
            WorldPt wpt = BaseXMLUtilities.loadWorldPt(child);
            line.pts.add(wpt);
        }
        return line;
    }

    public static Element getChildElement(Element parent, String childNamesPath) {
        String[] paths = childNamesPath.split("/");
        Element top = parent;
        for (int i = 0; i < paths.length; ++i) {
            Element child = top.getChild(paths[i]);
            if (child == null) {
                return null;
            }
            if (i == paths.length - 1) {
                return child;
            }
            top = child;
        }
        return null;
    }

    public static Element addChildContent(Element parent, String childElemName, boolean value) {
        return BaseXMLUtilities.addChildContent(parent, childElemName, Boolean.toString(value));
    }

    public static Element addChildContent(Element parent, String childElemName, double value) {
        return BaseXMLUtilities.addChildContent(parent, childElemName, String.valueOf(value));
    }

    public static Element addChildContent(Element parent, String childElemName, int value) {
        return BaseXMLUtilities.addChildContent(parent, childElemName, String.valueOf(value));
    }

    public static Element addChildContent(Element parent, String childElemName, long value) {
        return BaseXMLUtilities.addChildContent(parent, childElemName, String.valueOf(value));
    }

    public static Element addChildContent(Element parent, String childElemName, String value) {
        Element child = new Element(childElemName);
        child.setText(value);
        parent.addContent((Content)child);
        return child;
    }
}

