/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.CRC32;

public class CRC32Util {
    long fileSize = 0L;
    CRC32 crc32 = null;
    byte[] lastBytes = new byte[5];

    public CRC32Util() {
        this.crc32 = new CRC32();
    }

    public void computeFileCRC32(String filename) throws IOException {
        File file = new File(filename);
        this.computeFileCRC32(filename, file.length());
    }

    public void computeFileCRC32(String filename, long byteSize) throws IOException {
        this.lastBytes = new byte[5];
        int bufferSize = 4096;
        this.reset();
        if (byteSize <= 0L) {
            return;
        }
        FileInputStream in = new FileInputStream(filename);
        byte[] bytes = new byte[bufferSize];
        int n = -1;
        int fullBlocks = (int)(byteSize / (long)bufferSize);
        int residual = (int)(byteSize % (long)bufferSize);
        for (int i = 0; i < fullBlocks; ++i) {
            n = in.read(bytes);
            this.update(bytes, 0, n);
        }
        if (n >= 5) {
            this.lastBytes[0] = bytes[n - 5];
            this.lastBytes[1] = bytes[n - 4];
            this.lastBytes[2] = bytes[n - 3];
            this.lastBytes[3] = bytes[n - 2];
            this.lastBytes[4] = bytes[n - 1];
        }
        n = 0;
        if (residual > 0) {
            n = in.read(bytes, 0, residual);
            this.update(bytes, 0, n);
        }
        if (n >= 5) {
            this.lastBytes[0] = bytes[n - 5];
            this.lastBytes[1] = bytes[n - 4];
            this.lastBytes[2] = bytes[n - 3];
            this.lastBytes[3] = bytes[n - 2];
            this.lastBytes[4] = bytes[n - 1];
        } else if (n == 4) {
            this.lastBytes[1] = bytes[n - 4];
            this.lastBytes[2] = bytes[n - 3];
            this.lastBytes[3] = bytes[n - 2];
            this.lastBytes[4] = bytes[n - 1];
        } else if (n == 3) {
            this.lastBytes[2] = bytes[n - 3];
            this.lastBytes[3] = bytes[n - 2];
            this.lastBytes[4] = bytes[n - 1];
        } else if (n == 2) {
            this.lastBytes[3] = bytes[n - 2];
            this.lastBytes[4] = bytes[n - 1];
        } else if (n == 1) {
            this.lastBytes[4] = bytes[n - 1];
        }
        in.close();
    }

    public byte[] getLastBytes() {
        return this.lastBytes;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getFileCRC() {
        return this.crc32.getValue();
    }

    public void update(byte[] b, int off, int len) {
        this.crc32.update(b, off, len);
        this.fileSize += (long)len;
    }

    public void update(byte[] b) {
        this.crc32.update(b);
        this.fileSize += (long)b.length;
    }

    public void update(int b) {
        this.crc32.update(b);
        ++this.fileSize;
    }

    public void reset() {
        this.crc32.reset();
        this.fileSize = 0L;
    }
}

